/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xpath.axes.AxesWalker;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import java.util.Stack;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceWalker
extends AxesWalker {
    transient Stack m_namespaces;

    public NamespaceWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceWalker clone = (NamespaceWalker)super.clone();
        if (null != this.m_namespaces) {
            clone.m_namespaces = (Stack)this.m_namespaces.clone();
        }
        return clone;
    }

    public void setRoot(Node root) {
        this.m_nextLevelAmount = 1;
        this.m_namespaces = new Stack();
        for (Node nsContext = root; null != nsContext; nsContext = nsContext.getParentNode()) {
            NamedNodeMap attributeList = nsContext.getAttributes();
            if (null == attributeList) continue;
            int nAttrs = attributeList.getLength();
            for (int i = nAttrs - 1; i >= 0; --i) {
                Node attr = attributeList.item(i);
                if (!this.m_lpi.getDOMHelper().isNamespaceNode(attr)) continue;
                this.m_namespaces.push(attr);
            }
        }
        super.setRoot(root);
    }

    public Node firstChild() {
        this.m_nextLevelAmount = 0;
        return this.nextSibling();
    }

    public Node nextSibling() {
        Node next = this.m_namespaces.isEmpty() ? null : (Node)this.m_namespaces.pop();
        return this.setCurrentIfNotNull(next);
    }
}

