/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xalan.stree.Child;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.WrappedRuntimeException;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.axes.SubContextList;
import com.scenari.xsldom.xpath.compiler.Compiler;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.patterns.NodeTest;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    public PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    public PredicatedNodeTest() {
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest clone = (PredicatedNodeTest)super.clone();
        if (null != this.m_proximityPositions && this.m_proximityPositions == clone.m_proximityPositions) {
            clone.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, clone.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (clone.m_lpi == this) {
            clone.m_lpi = (LocPathIterator)clone;
        }
        return clone;
    }

    public int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicateCount(int count) {
        if (count > 0) {
            Expression[] newPredicates = new Expression[count];
            for (int i = 0; i < count; ++i) {
                newPredicates[i] = this.m_predicates[i];
            }
            this.m_predicates = newPredicates;
        } else {
            this.m_predicates = null;
        }
    }

    protected void initPredicateInfo(Compiler compiler, int opPos) throws TransformerException {
        int pos = compiler.getFirstPredicateOpPos(opPos);
        this.m_predicates = compiler.getCompiledPredicates(pos);
    }

    Expression getPredicate(int index) {
        return this.m_predicates[index];
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition();
    }

    public abstract int getLastPos(XPathContext var1);

    protected int getProximityPosition(int predicateIndex) {
        return predicateIndex >= 0 ? this.m_proximityPositions[predicateIndex] : 0;
    }

    public void resetProximityPositions() {
        int nPredicates = this.getPredicateCount();
        if (nPredicates > 0) {
            if (null == this.m_proximityPositions) {
                this.m_proximityPositions = new int[nPredicates];
            }
            for (int i = 0; i < nPredicates; ++i) {
                try {
                    this.initProximityPosition(i);
                    continue;
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
    }

    public void initProximityPosition(int i) throws TransformerException {
        this.m_proximityPositions[i] = 0;
    }

    protected void countProximityPosition(int i) {
        if (i < this.m_proximityPositions.length) {
            int n = i;
            this.m_proximityPositions[n] = this.m_proximityPositions[n] + 1;
        }
    }

    public boolean isReverseAxes() {
        return false;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executePredicates(Node context, XPathContext xctxt) throws TransformerException {
        this.m_predicateIndex = 0;
        int nPredicates = this.getPredicateCount();
        if (nPredicates == 0) {
            return true;
        }
        PrefixResolver savedResolver = xctxt.getPrefixResolver();
        try {
            xctxt.pushSubContextList(this);
            xctxt.setPrefixResolver(this.m_lpi.getPrefixResolver());
            xctxt.pushCurrentNode(context);
            for (int i = 0; i < nPredicates; ++i) {
                XObject pred = this.m_predicates[i].execute(xctxt);
                if (2 == pred.getType()) {
                    int proxPos = this.getProximityPosition(this.m_predicateIndex);
                    if (proxPos != (int)pred.num()) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (!pred.bool()) {
                    boolean bl = false;
                    return bl;
                }
                this.countProximityPosition(++this.m_predicateIndex);
            }
        }
        finally {
            xctxt.popCurrentNode();
            xctxt.setPrefixResolver(savedResolver);
            xctxt.popSubContextList();
        }
        this.m_predicateIndex = -1;
        return true;
    }

    protected String nodeToString(Node n) {
        try {
            return null != n ? n.getNodeName() + "{" + ((Child)n).getUid() + "}" : "null";
        }
        catch (ClassCastException cce) {
            return null != n ? n.getNodeName() : "null";
        }
    }

    public short acceptNode(Node n) {
        XPathContext xctxt = this.m_lpi.getXPathContext();
        try {
            xctxt.pushCurrentNode(n);
            XObject score = this.execute(xctxt, n);
            if (score != NodeTest.SCORE_NONE) {
                if (this.getPredicateCount() > 0) {
                    this.countProximityPosition(0);
                    if (!this.executePredicates(n, xctxt)) {
                        short s = 3;
                        return s;
                    }
                }
                short s = 1;
                return s;
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        finally {
            xctxt.popCurrentNode();
        }
        return 3;
    }

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    public void setLocPathIterator(LocPathIterator li) {
        this.m_lpi = li;
    }
}

