/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.axes.FilterExprWalker;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.axes.WalkerFactory;
import com.scenari.xsldom.xpath.compiler.Compiler;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XObject;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class UnionPathIterator
extends Expression
implements Cloneable,
NodeIterator,
ContextNodeList {
    transient NodeSet m_cachedNodes = null;
    protected transient int m_next = 0;
    transient Node m_lastFetched;
    protected transient boolean m_foundLast = false;
    protected transient XPathContext m_execContext;
    protected transient Node m_context;
    protected transient Node m_currentContextNode;
    protected LocPathIterator[] m_iterators;
    private transient int m_last = 0;

    public UnionPathIterator() {
        this.m_iterators = null;
    }

    public void initContext(XPathContext execContext) {
        this.m_execContext = execContext;
        this.m_currentContextNode = execContext.getCurrentExpressionNode();
        this.m_context = execContext.getCurrentNode();
        if (null != this.m_iterators) {
            int n = this.m_iterators.length;
            for (int i = 0; i < n; ++i) {
                this.m_iterators[i].initContext(execContext);
                this.m_iterators[i].nextNode();
            }
        }
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_context = null;
        int n = this.m_iterators.length;
        for (int i = 0; i < n; ++i) {
            this.m_iterators[i].detach();
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        try {
            UnionPathIterator clone = null;
            if (null == clone) {
                clone = (UnionPathIterator)this.clone();
            }
            clone.initContext(xctxt);
            return new XNodeSet(clone);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setShouldCacheNodes(boolean b) {
        this.m_cachedNodes = b ? new NodeSet() : null;
    }

    public void setCurrentPos(int i) {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = i;
        this.m_cachedNodes.setCurrentPos(i);
    }

    public int size() {
        if (null == this.m_cachedNodes) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node previousNode() throws DOMException {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public int getWhatToShow() {
        return -17;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public Node getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void addIterator(LocPathIterator iter) {
        if (null == this.m_iterators) {
            this.m_iterators = new LocPathIterator[1];
            this.m_iterators[0] = iter;
        } else {
            LocPathIterator[] iters = this.m_iterators;
            int len = this.m_iterators.length;
            this.m_iterators = new LocPathIterator[len + 1];
            System.arraycopy(iters, 0, this.m_iterators, 0, len);
            this.m_iterators[len] = iter;
        }
    }

    public UnionPathIterator(Compiler compiler, int opPos) throws TransformerException {
        opPos = Compiler.getFirstChildPos(opPos);
        this.loadLocationPaths(compiler, opPos, 0);
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)this.clone();
        clone.reset();
        return clone;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)super.clone();
        int n = this.m_iterators.length;
        clone.m_iterators = new LocPathIterator[n];
        for (int i = 0; i < n; ++i) {
            clone.m_iterators[i] = (LocPathIterator)this.m_iterators[i].clone();
        }
        return clone;
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_next = 0;
        this.m_last = 0;
        this.m_lastFetched = null;
        int n = this.m_iterators.length;
        for (int i = 0; i < n; ++i) {
            this.m_iterators[i].reset();
            this.m_iterators[i].nextNode();
        }
    }

    protected void loadLocationPaths(Compiler compiler, int opPos, int count) throws TransformerException {
        int steptype = compiler.getOpMap()[opPos];
        if (steptype == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
            this.m_iterators[count] = this.createLocPathIterator(compiler, opPos);
        } else {
            switch (steptype) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
                    LocPathIterator iter = new LocPathIterator(compiler.getNamespaceContext());
                    if (compiler.getLocationPathDepth() <= 0) {
                        iter.setIsTopLevel(true);
                    }
                    iter.m_firstWalker = new FilterExprWalker(iter);
                    iter.m_firstWalker.init(compiler, opPos, steptype);
                    this.m_iterators[count] = iter;
                    break;
                }
                default: {
                    this.m_iterators = new LocPathIterator[count];
                }
            }
        }
    }

    protected LocPathIterator createLocPathIterator(Compiler compiler, int opPos) throws TransformerException {
        LocPathIterator lpi = WalkerFactory.newLocPathIterator(compiler, opPos);
        if (compiler.getLocationPathDepth() <= 0) {
            lpi.setIsTopLevel(true);
        }
        return lpi;
    }

    public Node nextNode() throws DOMException {
        if (null != this.m_cachedNodes && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            return this.m_cachedNodes.nextNode();
        }
        if (this.m_foundLast) {
            return null;
        }
        Node earliestNode = null;
        if (null != this.m_iterators) {
            int n = this.m_iterators.length;
            int iteratorUsed = -1;
            for (int i = 0; i < n; ++i) {
                Node node = this.m_iterators[i].getCurrentNode();
                if (null == node) continue;
                if (null == earliestNode) {
                    iteratorUsed = i;
                    earliestNode = node;
                    continue;
                }
                if (node.equals(earliestNode)) {
                    this.m_iterators[i].nextNode();
                    continue;
                }
                DOMHelper dh = this.m_execContext.getDOMHelper();
                if (!dh.isNodeAfter(node, earliestNode)) continue;
                iteratorUsed = i;
                earliestNode = node;
            }
            if (null != earliestNode) {
                this.m_iterators[iteratorUsed].nextNode();
                if (null != this.m_cachedNodes) {
                    this.m_cachedNodes.addElement(earliestNode);
                }
                ++this.m_next;
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = earliestNode;
        return earliestNode;
    }

    public void runTo(int index) {
        if (this.m_foundLast || index >= 0 && index <= this.m_next) {
            return;
        }
        while (null == this.nextNode() && this.m_next < index) {
        }
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    public Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int last) {
        this.m_last = last;
    }
}

