/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xpath.axes.AncestorOrSelfWalker;
import com.scenari.xsldom.xpath.axes.AncestorWalker;
import com.scenari.xsldom.xpath.axes.AttributeIterator;
import com.scenari.xsldom.xpath.axes.AttributeWalker;
import com.scenari.xsldom.xpath.axes.AttributeWalkerOneStep;
import com.scenari.xsldom.xpath.axes.AxesWalker;
import com.scenari.xsldom.xpath.axes.ChildIterator;
import com.scenari.xsldom.xpath.axes.ChildTestIterator;
import com.scenari.xsldom.xpath.axes.ChildWalker;
import com.scenari.xsldom.xpath.axes.ChildWalkerMultiStep;
import com.scenari.xsldom.xpath.axes.ChildWalkerOneStep;
import com.scenari.xsldom.xpath.axes.DescendantIterator;
import com.scenari.xsldom.xpath.axes.DescendantOrSelfWalker;
import com.scenari.xsldom.xpath.axes.DescendantWalker;
import com.scenari.xsldom.xpath.axes.FilterExprWalker;
import com.scenari.xsldom.xpath.axes.FollowingSiblingWalker;
import com.scenari.xsldom.xpath.axes.FollowingWalker;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.axes.NamespaceWalker;
import com.scenari.xsldom.xpath.axes.ParentWalker;
import com.scenari.xsldom.xpath.axes.PrecedingSiblingWalker;
import com.scenari.xsldom.xpath.axes.PrecedingWalker;
import com.scenari.xsldom.xpath.axes.RootWalker;
import com.scenari.xsldom.xpath.axes.RootWalkerMultiStep;
import com.scenari.xsldom.xpath.axes.SelfWalker;
import com.scenari.xsldom.xpath.axes.SelfWalkerOneStep;
import com.scenari.xsldom.xpath.compiler.Compiler;
import javax.xml.transform.TransformerException;

public class WalkerFactory {
    static final boolean DEBUG_WALKER_CREATION = false;
    static final boolean DEBUG_ITERATOR_CREATION = false;
    public static final int BITS_COUNT = 255;
    public static final int BITS_RESERVED = 3840;
    public static final int BIT_PREDICATE = 4096;
    public static final int BIT_ANCESTOR = 8192;
    public static final int BIT_ANCESTOR_OR_SELF = 16384;
    public static final int BIT_ATTRIBUTE = 32768;
    public static final int BIT_CHILD = 65536;
    public static final int BIT_DESCENDANT = 131072;
    public static final int BIT_DESCENDANT_OR_SELF = 262144;
    public static final int BIT_FOLLOWING = 524288;
    public static final int BIT_FOLLOWING_SIBLING = 0x100000;
    public static final int BIT_NAMESPACE = 0x200000;
    public static final int BIT_PARENT = 0x400000;
    public static final int BIT_PRECEDING = 0x800000;
    public static final int BIT_PRECEDING_SIBLING = 0x1000000;
    public static final int BIT_SELF = 0x2000000;
    public static final int BIT_FILTER = 0x4000000;
    public static final int BIT_ROOT = 0x8000000;
    public static final int BITMASK_TRAVERSES_OUTSIDE_SUBTREE = 234381312;
    public static final int BIT_BACKWARDS_SELF = 0x10000000;
    public static final int BIT_ANY_DESCENDANT_FROM_ROOT = 0x20000000;
    public static final int BIT_NODETEST_ANY = 0x40000000;
    public static final int BIT_MATCH_PATTERN = Integer.MIN_VALUE;

    static AxesWalker loadOneWalker(LocPathIterator lpi, Compiler compiler, int stepOpCodePos) throws TransformerException {
        AxesWalker firstWalker = null;
        int stepType = compiler.getOpMap()[stepOpCodePos];
        if (stepType != -1) {
            firstWalker = WalkerFactory.createDefaultWalker(compiler, stepType, lpi, 0);
            firstWalker.init(compiler, stepOpCodePos, stepType);
        }
        return firstWalker;
    }

    static AxesWalker loadWalkers(LocPathIterator lpi, Compiler compiler, int stepOpCodePos, int stepIndex) throws TransformerException {
        int stepType;
        AxesWalker firstWalker = null;
        AxesWalker prevWalker = null;
        int[] ops = compiler.getOpMap();
        int analysis = WalkerFactory.analyze(compiler, stepOpCodePos, stepIndex);
        while (-1 != (stepType = ops[stepOpCodePos])) {
            AxesWalker walker = WalkerFactory.createDefaultWalker(compiler, stepOpCodePos, lpi, analysis);
            walker.init(compiler, stepOpCodePos, stepType);
            if (null == firstWalker) {
                firstWalker = walker;
            } else {
                prevWalker.setNextWalker(walker);
                walker.setPrevWalker(prevWalker);
            }
            prevWalker = walker;
            if ((stepOpCodePos = compiler.getNextStepPos(stepOpCodePos)) >= 0) continue;
            break;
        }
        return firstWalker;
    }

    public static LocPathIterator newLocPathIterator(Compiler compiler, int opPos) throws TransformerException {
        int firstStepPos = Compiler.getFirstChildPos(opPos);
        int analysis = WalkerFactory.analyze(compiler, firstStepPos, 0);
        if (65537 == (analysis & 0x100FF)) {
            if (0x40000000 == (analysis & 0x40000000) && 4096 != (analysis & 0x1000)) {
                return new ChildIterator(compiler, opPos, analysis);
            }
            return new ChildTestIterator(compiler, opPos, analysis);
        }
        if (32769 == (analysis & 0x80FF)) {
            return new AttributeIterator(compiler, opPos, analysis);
        }
        if (0 == (0x1000 & analysis) && (393217 == (analysis & 0x600FF) || 0x2040002 == (analysis & 0x20400FF) || 1107623939 == (analysis & 0x420500FF) || 1745158147 == (analysis & 0x680500FF))) {
            return new DescendantIterator(compiler, opPos, analysis);
        }
        return new LocPathIterator(compiler, opPos, analysis, true);
    }

    private static int analyze(Compiler compiler, int stepOpCodePos, int stepIndex) throws TransformerException {
        int stepType;
        int[] ops = compiler.getOpMap();
        int stepCount = 0;
        int analysisResult = 0;
        while (-1 != (stepType = ops[stepOpCodePos])) {
            ++stepCount;
            boolean predAnalysis = WalkerFactory.analyzePredicate(compiler, stepOpCodePos, stepType);
            if (predAnalysis) {
                analysisResult |= 0x1000;
            }
            switch (stepType) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    analysisResult |= 0x4000000;
                    break;
                }
                case 50: {
                    analysisResult |= 0x8000000;
                    break;
                }
                case 37: {
                    analysisResult |= 0x2000;
                    break;
                }
                case 38: {
                    analysisResult |= 0x4000;
                    break;
                }
                case 39: {
                    analysisResult |= 0x8000;
                    break;
                }
                case 49: {
                    analysisResult |= 0x200000;
                    break;
                }
                case 40: {
                    analysisResult |= 0x10000;
                    break;
                }
                case 41: {
                    analysisResult |= 0x20000;
                    break;
                }
                case 42: {
                    if (2 == stepCount && 0x8000000 == analysisResult) {
                        analysisResult |= 0x20000000;
                    }
                    analysisResult |= 0x40000;
                    break;
                }
                case 43: {
                    analysisResult |= 0x40000;
                    break;
                }
                case 44: {
                    analysisResult |= 0x100000;
                    break;
                }
                case 46: {
                    analysisResult |= 0x800000;
                    break;
                }
                case 47: {
                    analysisResult |= 0x1000000;
                    break;
                }
                case 45: {
                    analysisResult |= 0x400000;
                    break;
                }
                case 48: {
                    analysisResult |= 0x2000000;
                    break;
                }
                case 51: {
                    analysisResult |= 0x80008000;
                    break;
                }
                case 52: {
                    analysisResult |= 0x80002000;
                    break;
                }
                case 53: {
                    analysisResult |= 0x80400000;
                    break;
                }
                default: {
                    throw new RuntimeException("Programmer's assertion: unknown opcode: " + stepType);
                }
            }
            if (1033 == ops[stepOpCodePos + 3]) {
                analysisResult |= 0x40000000;
            }
            if ((stepOpCodePos = compiler.getNextStepPos(stepOpCodePos)) >= 0) continue;
            break;
        }
        return analysisResult |= stepCount & 0xFF;
    }

    static boolean analyzePredicate(Compiler compiler, int opPos, int stepType) throws TransformerException {
        int pos = compiler.getFirstPredicateOpPos(opPos);
        int nPredicates = compiler.countPredicates(pos);
        return nPredicates > 0;
    }

    private static AxesWalker createDefaultWalker(Compiler compiler, int opPos, LocPathIterator lpi, int analysis) {
        AxesWalker ai;
        int stepType = compiler.getOp(opPos);
        boolean simpleInit = false;
        int totalNumberWalkers = analysis & 0xFF;
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                ai = new FilterExprWalker(lpi);
                simpleInit = true;
                break;
            }
            case 50: {
                if (0 == (analysis & 0xF7DE6F00)) {
                    ai = new RootWalkerMultiStep(lpi);
                    break;
                }
                ai = new RootWalker(lpi);
                break;
            }
            case 37: {
                ai = new AncestorWalker(lpi);
                break;
            }
            case 38: {
                ai = new AncestorOrSelfWalker(lpi);
                break;
            }
            case 39: {
                if (1 == totalNumberWalkers) {
                    ai = new AttributeWalkerOneStep(lpi);
                    break;
                }
                ai = new AttributeWalker(lpi);
                break;
            }
            case 49: {
                ai = new NamespaceWalker(lpi);
                break;
            }
            case 40: {
                if (1 == totalNumberWalkers) {
                    ai = new ChildWalkerOneStep(lpi);
                    break;
                }
                if (0 == (analysis & 0xF7DE6F00)) {
                    ai = new ChildWalkerMultiStep(lpi);
                    break;
                }
                ai = new ChildWalker(lpi);
                break;
            }
            case 41: {
                ai = new DescendantWalker(lpi);
                break;
            }
            case 42: {
                ai = new DescendantOrSelfWalker(lpi);
                break;
            }
            case 43: {
                ai = new FollowingWalker(lpi);
                break;
            }
            case 44: {
                ai = new FollowingSiblingWalker(lpi);
                break;
            }
            case 46: {
                ai = new PrecedingWalker(lpi);
                break;
            }
            case 47: {
                ai = new PrecedingSiblingWalker(lpi);
                break;
            }
            case 45: {
                ai = new ParentWalker(lpi);
                break;
            }
            case 48: {
                if (1 == totalNumberWalkers) {
                    ai = new SelfWalkerOneStep(lpi);
                    break;
                }
                ai = new SelfWalker(lpi);
                break;
            }
            case 51: {
                ai = new AttributeWalker(lpi);
                break;
            }
            case 52: {
                ai = new ChildWalker(lpi);
                break;
            }
            case 53: {
                ai = new ChildWalker(lpi);
                break;
            }
            default: {
                throw new RuntimeException("Programmer's assertion: unknown opcode: " + stepType);
            }
        }
        if (simpleInit) {
            ai.initNodeTest(-1);
        } else {
            int whatToShow = compiler.getWhatToShow(opPos);
            if (0 == (whatToShow & 0x43) || whatToShow == -1) {
                ai.initNodeTest(whatToShow);
            } else {
                ai.initNodeTest(whatToShow, compiler.getStepNS(opPos), compiler.getStepLocalName(opPos));
            }
        }
        return ai;
    }
}

