/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.objects;

import com.scenari.xsldom.xml.utils.StringVector;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.objects.Comparator;
import com.scenari.xsldom.xpath.objects.EqualComparator;
import com.scenari.xsldom.xpath.objects.GreaterThanComparator;
import com.scenari.xsldom.xpath.objects.GreaterThanOrEqualComparator;
import com.scenari.xsldom.xpath.objects.LessThanComparator;
import com.scenari.xsldom.xpath.objects.LessThanOrEqualComparator;
import com.scenari.xsldom.xpath.objects.NotEqualComparator;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XString;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class XNodeSet
extends XObject {
    static LessThanComparator S_LT = new LessThanComparator();
    static LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static GreaterThanComparator S_GT = new GreaterThanComparator();
    static GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static EqualComparator S_EQ = new EqualComparator();
    static NotEqualComparator S_NEQ = new NotEqualComparator();

    public XNodeSet(NodeIterator val) {
        super(val);
    }

    public XNodeSet() {
        super(new NodeSet());
    }

    public XNodeSet(Node n) {
        super(new NodeSet());
        if (null != n) {
            ((NodeSet)this.m_obj).addNode(n);
        }
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public static double getNumberFromNode(Node n) {
        return XString.castToNum(XNodeSet.getStringFromNode(n));
    }

    public double num() {
        NodeIterator nl = this.nodeset();
        Node node = nl.nextNode();
        return node != null ? XNodeSet.getNumberFromNode(node) : Double.NaN;
    }

    public boolean bool() {
        return this.nodeset().nextNode() != null;
    }

    public static String getStringFromNode(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 9: {
                return DOMHelper.getNodeData(n);
            }
            case 3: 
            case 4: {
                return ((Text)n).getData();
            }
            case 2: 
            case 7: 
            case 8: {
                return n.getNodeValue();
            }
        }
        return DOMHelper.getNodeData(n);
    }

    public String str() {
        NodeIterator nl = this.nodeset();
        Node node = nl.nextNode();
        return node != null ? XNodeSet.getStringFromNode(node) : "";
    }

    public DocumentFragment rtree(XPathContext support) {
        Node node;
        DocumentFragment frag = support.getDOMHelper().getDOMFactory().createDocumentFragment();
        NodeIterator nl = this.nodeset();
        while (null != (node = nl.nextNode())) {
            frag.appendChild(node.cloneNode(true));
        }
        return frag;
    }

    public NodeIterator nodeset() {
        NodeIterator ns = (NodeIterator)this.m_obj;
        if (ns instanceof ContextNodeList) {
            if (((ContextNodeList)((Object)ns)).isFresh()) {
                return ns;
            }
            try {
                return ((ContextNodeList)((Object)ns)).cloneWithReset();
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.getMessage());
            }
        }
        return ns;
    }

    public NodeSet mutableNodeset() {
        NodeSet mnl;
        if (this.m_obj instanceof NodeSet) {
            mnl = (NodeSet)this.m_obj;
        } else {
            mnl = new NodeSet(this.nodeset());
            this.m_obj = mnl;
        }
        return mnl;
    }

    public boolean compare(XObject obj2, Comparator comparator) throws TransformerException {
        boolean result = false;
        int type = obj2.getType();
        if (4 == type) {
            Node node1;
            NodeIterator list1 = this.nodeset();
            NodeIterator list2 = ((XNodeSet)obj2).nodeset();
            StringVector node2Strings = null;
            block0: while (null != (node1 = list1.nextNode())) {
                String s1 = XNodeSet.getStringFromNode(node1);
                if (null == node2Strings) {
                    Node node2;
                    while (null != (node2 = list2.nextNode())) {
                        String s2 = XNodeSet.getStringFromNode(node2);
                        if (comparator.compareStrings(s1, s2)) {
                            result = true;
                            continue block0;
                        }
                        if (null == node2Strings) {
                            node2Strings = new StringVector();
                        }
                        node2Strings.addElement(s2);
                    }
                    continue;
                }
                int n = node2Strings.size();
                for (int i = 0; i < n; ++i) {
                    if (!comparator.compareStrings(s1, node2Strings.elementAt(i))) continue;
                    result = true;
                    continue block0;
                }
            }
        } else if (1 == type) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            result = comparator.compareNumbers(num1, num2);
        } else if (2 == type) {
            Node node;
            NodeIterator list1 = this.nodeset();
            double num2 = obj2.num();
            while (null != (node = list1.nextNode())) {
                double num1 = XNodeSet.getNumberFromNode(node);
                if (!comparator.compareNumbers(num1, num2)) continue;
                result = true;
                break;
            }
        } else if (5 == type) {
            double num2 = obj2.num();
            if (!Double.isNaN(num2)) {
                Node node;
                NodeIterator list1 = this.nodeset();
                while (null != (node = list1.nextNode())) {
                    double num1 = XNodeSet.getNumberFromNode(node);
                    if (!comparator.compareNumbers(num1, num2)) continue;
                    result = true;
                    break;
                }
            } else {
                Node node;
                String s2 = obj2.str();
                NodeIterator list1 = this.nodeset();
                while (null != (node = list1.nextNode())) {
                    String s1 = XNodeSet.getStringFromNode(node);
                    if (!comparator.compareStrings(s1, s2)) continue;
                    result = true;
                    break;
                }
            }
        } else if (3 == type) {
            Node node;
            String s2 = obj2.str();
            NodeIterator list1 = this.nodeset();
            while (null != (node = list1.nextNode())) {
                String s1 = XNodeSet.getStringFromNode(node);
                if (!comparator.compareStrings(s1, s2)) continue;
                result = true;
                break;
            }
        } else {
            result = comparator.compareNumbers(this.num(), obj2.num());
        }
        return result;
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LT);
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LTE);
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GT);
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GTE);
    }

    public boolean equals(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_EQ);
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_NEQ);
    }
}

