/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.objects;

import com.scenari.xsldom.xpath.objects.XObject;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.xml.transform.TransformerException;

public class XNumber
extends XObject {
    double m_val;
    public static ThreadLocal<DecimalFormat> sFormatter = new ThreadLocal(){

        protected Object initialValue() {
            DecimalFormat vF = new DecimalFormat("#0.#", new DecimalFormatSymbols(Locale.US));
            vF.setMaximumFractionDigits(100);
            return vF;
        }
    };

    public XNumber(double d) {
        this.m_val = d;
    }

    public int getType() {
        return 2;
    }

    public String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.m_val;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public String str() {
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        if (this.m_val == 0.0) {
            return "0";
        }
        if (this.m_val == 1.0) {
            return "1";
        }
        return sFormatter.get().format(this.m_val);
    }

    public Object object() {
        return new Double(this.m_val);
    }

    public boolean equals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.m_val == obj2.num();
    }

    public void set(double pValue) {
        this.m_val = pValue;
    }
}

