/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.objects;

import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.XPathException;
import com.scenari.xsldom.xpath.objects.XBoolean;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XRTreeFrag;
import com.scenari.xsldom.xpath.objects.XString;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class XObject
extends Expression
implements Serializable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;
    public static final int CLASS_UNRESOLVEDVARIABLE = 600;

    public XObject() {
    }

    public XObject(Object obj) {
        this.m_obj = obj;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this;
    }

    public static XObject create(Object val) {
        XObject result = val instanceof XObject ? (XObject)val : (val instanceof String ? new XString((String)val) : (val instanceof Boolean ? ((Boolean)val != false ? XBoolean.S_TRUE : XBoolean.S_FALSE) : (val instanceof Double ? new XNumber((Double)val) : (val instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)val) : (val instanceof Node ? new XNodeSet((Node)val) : (val instanceof NodeIterator ? new XNodeSet((NodeIterator)val) : new XObject(val)))))));
        return result;
    }

    public int getType() {
        return 0;
    }

    public String getTypeString() {
        return "#UNKNOWN (" + (this.object() != null ? this.object().getClass().getName() : "null") + ")";
    }

    public double num() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public boolean bool() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public String str() {
        return this.m_obj != null ? this.m_obj.toString() : "null";
    }

    public String toString() {
        return this.str();
    }

    public DocumentFragment rtree(XPathContext support) {
        DocumentFragment result = this.rtree();
        if (null == result) {
            result = support.getDOMHelper().getDOMFactory().createDocumentFragment();
            Text textNode = support.getDOMHelper().getDOMFactory().createTextNode(this.str());
            result.appendChild(textNode);
        }
        return result;
    }

    public DocumentFragment rtree() {
        return null;
    }

    public Object object() {
        return this.m_obj;
    }

    public NodeIterator nodeset() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public NodeSet mutableNodeset() throws TransformerException {
        this.error(20, new Object[]{this.getTypeString()});
        return (NodeSet)this.m_obj;
    }

    public Object castToType(int t, XPathContext support) throws TransformerException {
        Object result;
        switch (t) {
            case 3: {
                result = this.str();
                break;
            }
            case 2: {
                result = new Double(this.num());
                break;
            }
            case 4: {
                result = this.nodeset();
                break;
            }
            case 1: {
                result = new Boolean(this.bool());
                break;
            }
            case 0: {
                result = this.m_obj;
                break;
            }
            case 5: {
                result = this.rtree(support);
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(t)});
                result = null;
            }
        }
        return result;
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.greaterThan(this);
        }
        return this.num() < obj2.num();
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.greaterThanOrEqual(this);
        }
        return this.num() <= obj2.num();
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.lessThan(this);
        }
        return this.num() > obj2.num();
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.lessThanOrEqual(this);
        }
        return this.num() >= obj2.num();
    }

    public boolean equals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        if (null != this.m_obj) {
            return this.m_obj.equals(obj2.m_obj);
        }
        return obj2.m_obj == null;
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.notEquals(this);
        }
        return !this.equals(obj2);
    }

    protected void error(int msg) throws TransformerException {
        this.error(msg, null);
    }

    protected void error(int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        throw new XPathException(fmsg);
    }
}

