/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.patterns;

import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.XMLCharacterRecognizer;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.WhitespaceStrippingElementMatcher;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeTest
extends Expression {
    public static final String WILD = "*";
    public static final String SUPPORTS_PRE_STRIPPING = "http://xml.apache.org/xpath/features/whitespace-pre-stripping";
    protected int m_whatToShow;
    public static final int SHOW_NAMESPACE = 4096;
    public static final int SHOW_BYFUNCTION = 65536;
    String m_namespace;
    String m_name;
    XNumber m_score;
    public static final XNumber SCORE_NODETEST = new XNumber(-0.5);
    public static final XNumber SCORE_NSWILD = new XNumber(-0.25);
    public static final XNumber SCORE_QNAME = new XNumber(0.0);
    public static final XNumber SCORE_OTHER = new XNumber(0.5);
    public static final XNumber SCORE_NONE = new XNumber(Double.NEGATIVE_INFINITY);
    private boolean m_isTotallyWild;

    public int getWhatToShow() {
        return this.m_whatToShow;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getLocalName() {
        return null == this.m_name ? "" : this.m_name;
    }

    public NodeTest(int whatToShow, String namespace, String name) {
        this.initNodeTest(whatToShow, namespace, name);
    }

    public NodeTest(int whatToShow) {
        this.initNodeTest(whatToShow);
    }

    public NodeTest() {
    }

    public void initNodeTest(int whatToShow) {
        this.m_whatToShow = whatToShow;
        this.calcScore();
    }

    public void initNodeTest(int whatToShow, String namespace, String name) {
        this.m_whatToShow = whatToShow;
        this.m_namespace = namespace;
        this.m_name = name;
        this.calcScore();
    }

    protected void calcScore() {
        this.m_score = this.m_namespace == null && this.m_name == null ? SCORE_NODETEST : ((this.m_namespace == WILD || this.m_namespace == null) && this.m_name == WILD ? SCORE_NODETEST : (this.m_namespace != WILD && this.m_name == WILD ? SCORE_NSWILD : SCORE_QNAME));
        this.m_isTotallyWild = this.m_namespace == null && this.m_name == WILD;
    }

    public double getDefaultScore() {
        return this.m_score.num();
    }

    public static void debugWhatToShow(int whatToShow) {
        Vector<String> v = new Vector<String>();
        if (0 != (whatToShow & 2)) {
            v.addElement("SHOW_ATTRIBUTE");
        }
        if (0 != (whatToShow & 8)) {
            v.addElement("SHOW_CDATA_SECTION");
        }
        if (0 != (whatToShow & 0x80)) {
            v.addElement("SHOW_COMMENT");
        }
        if (0 != (whatToShow & 0x100)) {
            v.addElement("SHOW_DOCUMENT");
        }
        if (0 != (whatToShow & 0x400)) {
            v.addElement("SHOW_DOCUMENT_FRAGMENT");
        }
        if (0 != (whatToShow & 0x200)) {
            v.addElement("SHOW_DOCUMENT_TYPE");
        }
        if (0 != (whatToShow & 1)) {
            v.addElement("SHOW_ELEMENT");
        }
        if (0 != (whatToShow & 0x20)) {
            v.addElement("SHOW_ENTITY");
        }
        if (0 != (whatToShow & 0x10)) {
            v.addElement("SHOW_ENTITY_REFERENCE");
        }
        if (0 != (whatToShow & 0x800)) {
            v.addElement("SHOW_NOTATION");
        }
        if (0 != (whatToShow & 0x40)) {
            v.addElement("SHOW_PROCESSING_INSTRUCTION");
        }
        if (0 != (whatToShow & 4)) {
            v.addElement("SHOW_TEXT");
        }
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                System.out.print(" | ");
            }
            System.out.print(v.elementAt(i));
        }
        if (0 == n) {
            System.out.print("empty whatToShow: " + whatToShow);
        }
        System.out.println();
    }

    private static final boolean subPartMatch(String p, String t) {
        return p == t || null != p && (t == WILD || p.equals(t));
    }

    private static final boolean subPartMatchNS(String p, String t) {
        return p == t || null != p && (p.length() > 0 ? t == WILD || p.equals(t) : null == t);
    }

    public XObject execute(XPathContext xctxt, Node context) throws TransformerException {
        WhitespaceStrippingElementMatcher wsem;
        PrefixResolver resolver;
        String data;
        Node parent;
        short nodeType = context.getNodeType();
        if ((3 == nodeType || 4 == nodeType) && !context.isSupported(SUPPORTS_PRE_STRIPPING, null) && null != (parent = context.getParentNode()) && 1 == parent.getNodeType() && XMLCharacterRecognizer.isWhiteSpace(data = context.getNodeValue()) && (resolver = xctxt.getPrefixResolver()) instanceof WhitespaceStrippingElementMatcher && (wsem = (WhitespaceStrippingElementMatcher)((Object)resolver)).shouldStripWhiteSpace(xctxt, (Element)parent)) {
            return SCORE_NONE;
        }
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << nodeType - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return !xctxt.getDOMHelper().shouldStripSourceNode(context) ? this.m_score : SCORE_NONE;
            }
            case 64: {
                return NodeTest.subPartMatch(context.getNodeName(), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 2: {
                int isNamespace = this.m_whatToShow & 0x1000;
                if (0 == isNamespace) {
                    DOMHelper dh = xctxt.getDOMHelper();
                    if (!dh.isNamespaceNode(context)) {
                        return this.m_isTotallyWild || NodeTest.subPartMatchNS(dh.getNamespaceOfNode(context), this.m_namespace) && NodeTest.subPartMatch(dh.getLocalNameOfNode(context), this.m_name) ? this.m_score : SCORE_NONE;
                    }
                    return SCORE_NONE;
                }
                if (xctxt.getDOMHelper().isNamespaceNode(context)) {
                    String ns = context.getNodeValue();
                    return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
                }
                return SCORE_NONE;
            }
            case 1: {
                DOMHelper dh = xctxt.getDOMHelper();
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dh.getNamespaceOfNode(context), this.m_namespace) && NodeTest.subPartMatch(dh.getLocalNameOfNode(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }
}

