/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.patterns;

import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.SubContextList;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.patterns.NodeTest;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class StepPattern
extends NodeTest
implements SubContextList {
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int whatToShow, String namespace, String name) {
        super(whatToShow, namespace, name);
    }

    public StepPattern(int whatToShow) {
        super(whatToShow);
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        this.calcScore();
    }

    public Expression getPredicate(int i) {
        return this.m_predicates[i];
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        this.calcScore();
    }

    protected void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject executeStep(XPathContext xctxt) throws TransformerException {
        XObject score = super.execute(xctxt);
        if (score == NodeTest.SCORE_NONE) {
            return score;
        }
        int n = this.getPredicateCount();
        if (n == 0) {
            return score;
        }
        try {
            xctxt.pushSubContextList(this);
            for (int i = 0; i < n; ++i) {
                XObject pred = this.m_predicates[i].execute(xctxt);
                if (2 == pred.getType()) {
                    if (this.getProximityPosition(xctxt) == (int)pred.num()) continue;
                    score = NodeTest.SCORE_NONE;
                } else {
                    if (pred.bool()) continue;
                    score = NodeTest.SCORE_NONE;
                }
                break;
            }
        }
        finally {
            xctxt.popSubContextList();
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProximityPosition(XPathContext xctxt) {
        Node context = xctxt.getCurrentNode();
        Node parentContext = xctxt.getDOMHelper().getParentOfNode(context);
        try {
            xctxt.pushCurrentNode(parentContext);
            int pos = 0;
            for (Node child = parentContext.getFirstChild(); child != null; child = child.getNextSibling()) {
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE == super.execute(xctxt)) continue;
                    ++pos;
                    if (!child.equals(context)) continue;
                    int n = pos;
                    return n;
                }
                finally {
                    xctxt.popCurrentNode();
                }
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        finally {
            xctxt.popCurrentNode();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPos(XPathContext xctxt) {
        Node context = xctxt.getCurrentNode();
        Node parentContext = xctxt.getDOMHelper().getParentOfNode(context);
        try {
            xctxt.pushCurrentNode(parentContext);
            int count = 0;
            for (Node child = parentContext.getFirstChild(); child != null; child = child.getNextSibling()) {
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE == super.execute(xctxt)) continue;
                    ++count;
                    continue;
                }
                finally {
                    xctxt.popCurrentNode();
                }
            }
            int n = count;
            return n;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        finally {
            xctxt.popCurrentNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XObject executeRelativePathPattern(XPathContext xctxt) throws TransformerException {
        void var2_7;
        Node parent = xctxt.getDOMHelper().getParentOfNode(xctxt.getCurrentNode());
        if (null != parent) {
            try {
                xctxt.pushCurrentNode(parent);
                XObject xObject = this.execute(xctxt);
                if (xObject == NodeTest.SCORE_NONE) return var2_7;
                XNumber xNumber = SCORE_OTHER;
                return var2_7;
            }
            finally {
                xctxt.popCurrentNode();
            }
        } else {
            XNumber xNumber = NodeTest.SCORE_NONE;
        }
        return var2_7;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject score = this.executeStep(xctxt);
        if (score != NodeTest.SCORE_NONE && null != this.m_relativePathPattern) {
            score = this.m_relativePathPattern.executeRelativePathPattern(xctxt);
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xctxt, Node context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            double d = score.num();
            return d;
        }
        finally {
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
        }
    }
}

