/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.extensions;

import com.scenari.xsldtm.xalan.extensions.ExpressionContext;
import com.scenari.xsldtm.xalan.extensions.ExtensionHandler;
import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.ElemExsltFuncResult;
import com.scenari.xsldtm.xalan.templates.ElemExsltFunction;
import com.scenari.xsldtm.xalan.templates.ElemTemplate;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.templates.Stylesheet;
import com.scenari.xsldtm.xalan.templates.StylesheetRoot;
import com.scenari.xsldtm.xalan.transformer.TransformerImpl;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xpath.ExpressionNode;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.functions.FuncExtFunction;
import com.scenari.xsldtm.xpath.objects.XObject;
import com.scenari.xsldtm.xpath.objects.XString;
import java.io.IOException;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class ExtensionHandlerExsltFunction
extends ExtensionHandler {
    private String m_namespace;
    private StylesheetRoot m_stylesheet;
    private static final QName RESULTQNAME = new QName("http://exslt.org/functions", "result");

    public ExtensionHandlerExsltFunction(String ns, StylesheetRoot stylesheet) {
        super(ns, "xml");
        this.m_namespace = ns;
        this.m_stylesheet = stylesheet;
    }

    public void processElement(String localPart, ElemTemplateElement element, TransformerImpl transformer, Stylesheet stylesheetTree, Object methodKey) throws TransformerException, IOException {
    }

    public ElemExsltFunction getFunction(String funcName) {
        QName qname = new QName(this.m_namespace, funcName);
        ElemTemplate templ = this.m_stylesheet.getTemplateComposed(qname);
        if (templ != null && templ instanceof ElemExsltFunction) {
            return (ElemExsltFunction)templ;
        }
        return null;
    }

    public boolean isFunctionAvailable(String funcName) {
        return this.getFunction(funcName) != null;
    }

    public boolean isElementAvailable(String elemName) {
        if (!new QName(this.m_namespace, elemName).equals(RESULTQNAME)) {
            return false;
        }
        ElemTemplateElement elem = this.m_stylesheet.getFirstChildElem();
        while (elem != null && elem != this.m_stylesheet) {
            if (elem instanceof ElemExsltFuncResult && this.ancestorIsFunction(elem)) {
                return true;
            }
            ElemTemplateElement nextElem = elem.getFirstChildElem();
            if (nextElem == null) {
                nextElem = elem.getNextSiblingElem();
            }
            if (nextElem == null) {
                nextElem = elem.getParentElem();
            }
            elem = nextElem;
        }
        return false;
    }

    private boolean ancestorIsFunction(ElemTemplateElement child) {
        while (child.getParentElem() != null && !(child.getParentElem() instanceof StylesheetRoot)) {
            if (child.getParentElem() instanceof ElemExsltFunction) {
                return true;
            }
            child = child.getParentElem();
        }
        return false;
    }

    public Object callFunction(String funcName, Vector args, Object methodKey, ExpressionContext exprContext) throws TransformerException {
        throw new TransformerException("This method should not be called.");
    }

    public Object callFunction(FuncExtFunction extFunction, Vector args, ExpressionContext exprContext) throws TransformerException {
        for (ExpressionNode parent = extFunction.exprGetParent(); parent != null && !(parent instanceof ElemTemplate); parent = parent.exprGetParent()) {
        }
        XObject[] methodArgs = new XObject[args.size()];
        try {
            for (int i = 0; i < methodArgs.length; ++i) {
                methodArgs[i] = XObject.create(args.elementAt(i));
            }
            ElemExsltFunction elemFunc = this.getFunction(extFunction.getFunctionName());
            if (null != elemFunc) {
                XPathContext context = exprContext.getXPathContext();
                TransformerImpl transformer = (TransformerImpl)context.getOwnerObject();
                transformer.pushCurrentFuncResult(null);
                elemFunc.execute(transformer, methodArgs);
                XObject val = (XObject)transformer.popCurrentFuncResult();
                return val == null ? new XString("") : val;
            }
            throw new TransformerException(XSLMessages.createMessage("ER_FUNCTION_NOT_FOUND", new Object[]{extFunction.getFunctionName()}));
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }
}

