/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.processor;

import com.scenari.xsldtm.xalan.processor.ProcessorTemplateElem;
import com.scenari.xsldtm.xalan.processor.StylesheetHandler;
import com.scenari.xsldtm.xalan.templates.ElemApplyImport;
import com.scenari.xsldtm.xalan.templates.ElemApplyTemplates;
import com.scenari.xsldtm.xalan.templates.ElemAttribute;
import com.scenari.xsldtm.xalan.templates.ElemCallTemplate;
import com.scenari.xsldtm.xalan.templates.ElemComment;
import com.scenari.xsldtm.xalan.templates.ElemCopy;
import com.scenari.xsldtm.xalan.templates.ElemCopyOf;
import com.scenari.xsldtm.xalan.templates.ElemElement;
import com.scenari.xsldtm.xalan.templates.ElemExsltFuncResult;
import com.scenari.xsldtm.xalan.templates.ElemExsltFunction;
import com.scenari.xsldtm.xalan.templates.ElemFallback;
import com.scenari.xsldtm.xalan.templates.ElemLiteralResult;
import com.scenari.xsldtm.xalan.templates.ElemMessage;
import com.scenari.xsldtm.xalan.templates.ElemNumber;
import com.scenari.xsldtm.xalan.templates.ElemPI;
import com.scenari.xsldtm.xalan.templates.ElemParam;
import com.scenari.xsldtm.xalan.templates.ElemTemplate;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.templates.ElemText;
import com.scenari.xsldtm.xalan.templates.ElemTextLiteral;
import com.scenari.xsldtm.xalan.templates.ElemValueOf;
import com.scenari.xsldtm.xalan.templates.ElemVariable;
import com.scenari.xsldtm.xalan.templates.Stylesheet;
import com.scenari.xsldtm.xml.utils.SAXSourceLocator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessorExsltFunction
extends ProcessorTemplateElem {
    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        String msg = "";
        if (!(handler.getElemTemplateElement() instanceof Stylesheet)) {
            msg = "func:function element must be top level.";
            handler.error(msg, new SAXException(msg));
        }
        super.startElement(handler, uri, localName, rawName, attributes);
        String val = attributes.getValue("name");
        int indexOfColon = val.indexOf(":");
        if (indexOfColon > 0) {
            String prefix = val.substring(0, indexOfColon);
            String localVal = val.substring(indexOfColon + 1);
            String ns = handler.getNamespaceSupport().getURI(prefix);
        } else {
            msg = "func:function name must have namespace";
            handler.error(msg, new SAXException(msg));
        }
    }

    protected void appendAndPush(StylesheetHandler handler, ElemTemplateElement elem) throws SAXException {
        super.appendAndPush(handler, elem);
        elem.setDOMBackPointer(handler.getOriginatingNode());
        handler.getStylesheet().setTemplate((ElemTemplate)elem);
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
        ElemTemplateElement function = handler.getElemTemplateElement();
        SAXSourceLocator locator = handler.getLocator();
        this.validate(function, handler);
        super.endElement(handler, uri, localName, rawName);
    }

    public void validate(ElemTemplateElement elem, StylesheetHandler handler) throws SAXException {
        String msg = "";
        while (elem != null) {
            if (elem instanceof ElemExsltFuncResult && elem.getNextSiblingElem() != null && !(elem.getNextSiblingElem() instanceof ElemFallback)) {
                msg = "func:result has an illegal following sibling (only xsl:fallback allowed)";
                handler.error(msg, new SAXException(msg));
            }
            if ((elem instanceof ElemApplyImport || elem instanceof ElemApplyTemplates || elem instanceof ElemAttribute || elem instanceof ElemCallTemplate || elem instanceof ElemComment || elem instanceof ElemCopy || elem instanceof ElemCopyOf || elem instanceof ElemElement || elem instanceof ElemLiteralResult || elem instanceof ElemNumber || elem instanceof ElemPI || elem instanceof ElemText || elem instanceof ElemTextLiteral || elem instanceof ElemValueOf) && !this.ancestorIsOk(elem)) {
                msg = "misplaced literal result in a func:function container.";
                handler.error(msg, new SAXException(msg));
            }
            ElemTemplateElement nextElem = elem.getFirstChildElem();
            while (nextElem == null) {
                nextElem = elem.getNextSiblingElem();
                if (nextElem == null) {
                    elem = elem.getParentElem();
                }
                if (elem != null && !(elem instanceof ElemExsltFunction)) continue;
                return;
            }
            elem = nextElem;
        }
    }

    boolean ancestorIsOk(ElemTemplateElement child) {
        while (child.getParentElem() != null && !(child.getParentElem() instanceof ElemExsltFunction)) {
            ElemTemplateElement parent = child.getParentElem();
            if (parent instanceof ElemExsltFuncResult || parent instanceof ElemVariable || parent instanceof ElemParam || parent instanceof ElemMessage) {
                return true;
            }
            child = parent;
        }
        return false;
    }
}

