/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.templates;

import com.scenari.xsldtm.xalan.processor.StylesheetHandler;
import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.AVTPart;
import com.scenari.xsldtm.xalan.templates.AVTPartSimple;
import com.scenari.xsldtm.xalan.templates.AVTPartXPath;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.templates.XSLTVisitable;
import com.scenari.xsldtm.xalan.templates.XSLTVisitor;
import com.scenari.xsldtm.xml.utils.FastStringBuilder;
import com.scenari.xsldtm.xml.utils.PrefixResolver;
import com.scenari.xsldtm.xml.utils.StringBuilderPool;
import com.scenari.xsldtm.xpath.XPath;
import com.scenari.xsldtm.xpath.XPathContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class AVT
implements Serializable,
XSLTVisitable {
    private String m_simpleString = null;
    private ArrayList m_parts = null;
    private String m_rawName;
    private String m_name;
    private String m_uri;

    public String getRawName() {
        return this.m_rawName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getURI() {
        return this.m_uri;
    }

    public void setURI(String uri) {
        this.m_uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AVT(StylesheetHandler handler, String uri, String name, String rawName, String stringedValue, ElemTemplateElement owner) throws TransformerException {
        this.m_uri = uri;
        this.m_name = name;
        this.m_rawName = rawName;
        if (stringedValue.indexOf(123) < 0) {
            this.m_simpleString = stringedValue;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(stringedValue, "{}\"'", true);
            int nTokens = tokenizer.countTokens();
            FastStringBuilder buffer = StringBuilderPool.get();
            FastStringBuilder exprBuffer = StringBuilderPool.get();
            try {
                this.m_parts = new ArrayList(nTokens + 1);
                String t = null;
                String lookahead = null;
                String error = null;
                while (tokenizer.hasMoreTokens()) {
                    if (lookahead != null) {
                        t = lookahead;
                        lookahead = null;
                    } else {
                        t = tokenizer.nextToken();
                    }
                    if (t.length() == 1) {
                        switch (t.charAt(0)) {
                            case '\"': 
                            case '\'': {
                                buffer.append(t);
                                break;
                            }
                            case '{': {
                                try {
                                    lookahead = tokenizer.nextToken();
                                    if (lookahead.equals("{")) {
                                        buffer.append(lookahead);
                                        lookahead = null;
                                        break;
                                    }
                                    if (buffer.length() > 0) {
                                        this.m_parts.add(new AVTPartSimple(buffer.toString()));
                                        buffer.setLength(0);
                                    }
                                    exprBuffer.setLength(0);
                                    block20: while (null != lookahead) {
                                        if (lookahead.length() == 1) {
                                            switch (lookahead.charAt(0)) {
                                                case '\"': 
                                                case '\'': {
                                                    exprBuffer.append(lookahead);
                                                    String quote = lookahead;
                                                    lookahead = tokenizer.nextToken();
                                                    while (!lookahead.equals(quote)) {
                                                        exprBuffer.append(lookahead);
                                                        lookahead = tokenizer.nextToken();
                                                    }
                                                    exprBuffer.append(lookahead);
                                                    lookahead = tokenizer.nextToken();
                                                    continue block20;
                                                }
                                                case '{': {
                                                    error = XSLMessages.createMessage("ER_NO_CURLYBRACE", null);
                                                    lookahead = null;
                                                    continue block20;
                                                }
                                                case '}': {
                                                    buffer.setLength(0);
                                                    XPath xpath = handler.createXPath(exprBuffer.toString(), owner);
                                                    this.m_parts.add(new AVTPartXPath(xpath));
                                                    lookahead = null;
                                                    continue block20;
                                                }
                                            }
                                            exprBuffer.append(lookahead);
                                            lookahead = tokenizer.nextToken();
                                            continue;
                                        }
                                        exprBuffer.append(lookahead);
                                        lookahead = tokenizer.nextToken();
                                    }
                                    if (error != null) break;
                                }
                                catch (NoSuchElementException ex) {
                                    error = XSLMessages.createMessage("ER_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{name, stringedValue});
                                }
                                break;
                            }
                            case '}': {
                                lookahead = tokenizer.nextToken();
                                if (lookahead.equals("}")) {
                                    buffer.append(lookahead);
                                    lookahead = null;
                                    break;
                                }
                                try {
                                    handler.warn("WG_FOUND_CURLYBRACE", null);
                                }
                                catch (SAXException se) {
                                    throw new TransformerException(se);
                                }
                                buffer.append("}");
                                break;
                            }
                            default: {
                                buffer.append(t);
                                break;
                            }
                        }
                    } else {
                        buffer.append(t);
                    }
                    if (null == error) continue;
                    try {
                        handler.warn("WG_ATTR_TEMPLATE", new Object[]{error});
                        break;
                    }
                    catch (SAXException se) {
                        throw new TransformerException(se);
                    }
                }
                if (buffer.length() > 0) {
                    this.m_parts.add(new AVTPartSimple(buffer.toString()));
                    buffer.setLength(0);
                }
            }
            finally {
                StringBuilderPool.free(buffer);
                StringBuilderPool.free(exprBuffer);
            }
        }
        if (null == this.m_parts && null == this.m_simpleString) {
            this.m_simpleString = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSimpleString() {
        if (null != this.m_simpleString) {
            return this.m_simpleString;
        }
        if (null != this.m_parts) {
            String s;
            FastStringBuilder buf = StringBuilderPool.get();
            try {
                buf.setLength(0);
                int n = this.m_parts.size();
                for (int i = 0; i < n; ++i) {
                    AVTPart part = (AVTPart)this.m_parts.get(i);
                    buf.append(part.getSimpleString());
                }
                s = buf.toString();
            }
            finally {
                StringBuilderPool.free(buf);
            }
            return s;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(XPathContext xctxt, int context, PrefixResolver nsNode) throws TransformerException {
        FastStringBuilder buf = StringBuilderPool.get();
        try {
            if (null != this.m_simpleString) {
                String string = this.m_simpleString;
                return string;
            }
            if (null != this.m_parts) {
                buf.setLength(0);
                int n = this.m_parts.size();
                for (int i = 0; i < n; ++i) {
                    AVTPart part = (AVTPart)this.m_parts.get(i);
                    part.evaluate(xctxt, buf, context, nsNode);
                }
                String string = buf.toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            StringBuilderPool.free(buf);
        }
    }

    public boolean isContextInsensitive() {
        return null != this.m_simpleString;
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_parts) {
            int n = this.m_parts.size();
            for (int i = 0; i < n; ++i) {
                AVTPart part = (AVTPart)this.m_parts.get(i);
                if (!part.canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        if (null != this.m_parts) {
            int n = this.m_parts.size();
            for (int i = 0; i < n; ++i) {
                AVTPart part = (AVTPart)this.m_parts.get(i);
                part.fixupVariables(vars, globalsSize);
            }
        }
    }

    public void callVisitors(XSLTVisitor visitor) {
        if (visitor.visitAVT(this) && null != this.m_parts) {
            int n = this.m_parts.size();
            for (int i = 0; i < n; ++i) {
                AVTPart part = (AVTPart)this.m_parts.get(i);
                part.callVisitors(visitor);
            }
        }
    }

    public boolean isSimple() {
        return this.m_simpleString != null;
    }
}

