/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.templates;

import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.templates.StylesheetRoot;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xml.utils.SAXSourceLocator;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.functions.Function3Args;
import com.scenari.xsldtm.xpath.functions.WrongNumberArgsException;
import com.scenari.xsldtm.xpath.objects.XObject;
import com.scenari.xsldtm.xpath.objects.XString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public class FuncFormatNumb
extends Function3Args {
    public XObject execute(XPathContext xctxt) throws TransformerException {
        ElemTemplateElement templElem = (ElemTemplateElement)xctxt.getNamespaceContext();
        StylesheetRoot ss = templElem.getStylesheetRoot();
        NumberFormat formatter = null;
        DecimalFormatSymbols dfs = null;
        double num = this.getArg0().execute(xctxt).num();
        String patternStr = this.getArg1().execute(xctxt).str();
        if (patternStr.indexOf(164) > 0) {
            ss.error("ER_CURRENCY_SIGN_ILLEGAL");
        }
        try {
            Expression arg2Expr = this.getArg2();
            if (null != arg2Expr) {
                String dfName = arg2Expr.execute(xctxt).str();
                QName qname = new QName(dfName, xctxt.getNamespaceContext());
                dfs = ss.getDecimalFormatComposed(qname);
                if (null == dfs) {
                    this.warn(xctxt, "WG_NO_DECIMALFORMAT_DECLARATION", new Object[]{dfName});
                } else {
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                }
            }
            if (null == formatter) {
                dfs = ss.getDecimalFormatComposed(new QName(""));
                if (dfs != null) {
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                } else {
                    dfs = new DecimalFormatSymbols(Locale.US);
                    dfs.setInfinity("Infinity");
                    dfs.setNaN("NaN");
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    if (null != patternStr) {
                        ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                    }
                }
            }
            return new XString(formatter.format(num));
        }
        catch (Exception iae) {
            templElem.error("ER_MALFORMED_FORMAT_STRING", new Object[]{patternStr});
            return XString.EMPTYSTRING;
        }
    }

    public void warn(XPathContext xctxt, String msg, Object[] args) throws TransformerException {
        String formattedMsg = XSLMessages.createWarning(msg, args);
        ErrorListener errHandler = xctxt.getErrorListener();
        errHandler.warning(new TransformerException(formattedMsg, (SAXSourceLocator)xctxt.getSAXLocator()));
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum > 3 || argNum < 2) {
            this.reportWrongNumberArgs();
        }
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        throw new WrongNumberArgsException(XSLMessages.createMessage("ER_TWO_OR_THREE", null));
    }
}

