/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.templates;

import com.scenari.xsldtm.xalan.extensions.ExtensionNamespacesManager;
import com.scenari.xsldtm.xalan.processor.XSLTSchema;
import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.DecimalFormatProperties;
import com.scenari.xsldtm.xalan.templates.ElemApplyTemplates;
import com.scenari.xsldtm.xalan.templates.ElemAttributeSet;
import com.scenari.xsldtm.xalan.templates.ElemOverlay;
import com.scenari.xsldtm.xalan.templates.ElemTemplate;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.templates.ElemValueOf;
import com.scenari.xsldtm.xalan.templates.ElemVariable;
import com.scenari.xsldtm.xalan.templates.KeyDeclaration;
import com.scenari.xsldtm.xalan.templates.NamespaceAlias;
import com.scenari.xsldtm.xalan.templates.OutputProperties;
import com.scenari.xsldtm.xalan.templates.Stylesheet;
import com.scenari.xsldtm.xalan.templates.StylesheetComposed;
import com.scenari.xsldtm.xalan.templates.TemplateList;
import com.scenari.xsldtm.xalan.templates.WhiteSpaceInfo;
import com.scenari.xsldtm.xalan.transformer.TransformerImpl;
import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.dtm.ref.ExpandedNameTable;
import com.scenari.xsldtm.xml.utils.IntStack;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xpath.XPath;
import com.scenari.xsldtm.xpath.XPathContext;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    private Hashtable m_availElems;
    private ExtensionNamespacesManager m_extNsMgr = null;
    private StylesheetComposed[] m_globalImportList;
    private OutputProperties m_outputProperties;
    private boolean m_outputMethodSet = false;
    private Hashtable m_attrSets;
    private Hashtable m_decimalFormatSymbols;
    private Vector m_keyDecls;
    private Hashtable m_namespaceAliasComposed;
    private TemplateList m_templateList;
    private TemplateList m_overlayList;
    private Vector m_variables;
    private TemplateList m_whiteSpaceInfoList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;
    private ElemTemplate m_startRule;
    XPath m_selectDefault;
    XPath m_selectCurrent;
    private ComposeState m_composeState;

    public StylesheetRoot(ErrorListener errorListener) throws TransformerConfigurationException {
        super(null);
        this.setStylesheetRoot(this);
        try {
            this.m_selectDefault = new XPath("node()", this, this, 0, errorListener);
            this.m_selectCurrent = new XPath(".", this, this, 0, errorListener);
            this.initDefaultRule(errorListener);
        }
        catch (TransformerException se) {
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_CANNOT_INIT_DEFAULT_TEMPLATES", null), se);
        }
    }

    public StylesheetRoot(XSLTSchema schema, ErrorListener listener) throws TransformerConfigurationException {
        this(listener);
        this.m_availElems = schema.getElemsAvailable();
    }

    public boolean isRoot() {
        return true;
    }

    public Hashtable getAvailableElements() {
        return this.m_availElems;
    }

    public ExtensionNamespacesManager getExtensionNamespacesManager() {
        if (this.m_extNsMgr == null) {
            this.m_extNsMgr = new ExtensionNamespacesManager();
        }
        return this.m_extNsMgr;
    }

    public Vector getExtensions() {
        return this.m_extNsMgr != null ? this.m_extNsMgr.getExtensions() : null;
    }

    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public Properties getDefaultOutputProps() {
        return this.m_outputProperties.getProperties();
    }

    public Properties getOutputProperties() {
        return (Properties)this.getDefaultOutputProps().clone();
    }

    public void recompose() throws TransformerException {
        int i;
        Vector recomposableElements = new Vector();
        if (null == this.m_globalImportList) {
            Vector importList = new Vector();
            this.addImports(this, true, importList);
            this.m_globalImportList = new StylesheetComposed[importList.size()];
            int j = importList.size() - 1;
            for (i = 0; i < importList.size(); ++i) {
                this.m_globalImportList[j] = (StylesheetComposed)importList.elementAt(i);
                this.m_globalImportList[j].recomposeIncludes(this.m_globalImportList[j]);
                this.m_globalImportList[j--].recomposeImports();
            }
        }
        int n = this.getGlobalImportCount();
        for (i = 0; i < n; ++i) {
            StylesheetComposed imported = this.getGlobalImport(i);
            imported.recompose(recomposableElements);
        }
        this.QuickSort2(recomposableElements, 0, recomposableElements.size() - 1);
        this.m_outputProperties = new OutputProperties("");
        this.m_attrSets = new Hashtable();
        this.m_decimalFormatSymbols = new Hashtable();
        this.m_keyDecls = new Vector();
        this.m_namespaceAliasComposed = new Hashtable();
        this.m_templateList = new TemplateList();
        this.m_overlayList = new TemplateList();
        this.m_variables = new Vector();
        for (i = recomposableElements.size() - 1; i >= 0; --i) {
            ((ElemTemplateElement)recomposableElements.elementAt(i)).recompose(this);
        }
        this.initComposeState();
        this.m_templateList.compose(this);
        this.m_overlayList.compose(this);
        this.m_outputProperties.compose(this);
        this.m_outputProperties.endCompose(this);
        n = this.getGlobalImportCount();
        for (i = 0; i < n; ++i) {
            StylesheetComposed imported = this.getGlobalImport(i);
            int includedCount = imported.getIncludeCountComposed();
            for (int j = -1; j < includedCount; ++j) {
                Stylesheet included = imported.getIncludeComposed(j);
                this.composeTemplates(included);
            }
        }
        if (this.m_extNsMgr != null) {
            this.m_extNsMgr.registerUnregisteredNamespaces();
        }
        this.clearComposeState();
    }

    void composeTemplates(ElemTemplateElement templ) throws TransformerException {
        templ.compose(this);
        for (ElemTemplateElement child = templ.getFirstChildElem(); child != null; child = child.getNextSiblingElem()) {
            this.composeTemplates(child);
        }
        templ.endCompose(this);
    }

    protected void addImports(Stylesheet stylesheet, boolean addToList, Vector importList) {
        int i;
        int n = stylesheet.getImportCount();
        if (n > 0) {
            for (i = 0; i < n; ++i) {
                StylesheetComposed imported = stylesheet.getImport(i);
                this.addImports(imported, true, importList);
            }
        }
        if ((n = stylesheet.getIncludeCount()) > 0) {
            for (i = 0; i < n; ++i) {
                Stylesheet included = stylesheet.getInclude(i);
                this.addImports(included, false, importList);
            }
        }
        if (addToList) {
            importList.addElement(stylesheet);
        }
    }

    public StylesheetComposed getGlobalImport(int i) {
        return this.m_globalImportList[i];
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList != null ? this.m_globalImportList.length : 1;
    }

    public int getImportNumber(StylesheetComposed sheet) {
        if (this == sheet) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        for (int i = 0; i < n; ++i) {
            if (sheet != this.getGlobalImport(i)) continue;
            return i;
        }
        return -1;
    }

    void recomposeOutput(OutputProperties oprops) throws TransformerException {
        this.m_outputProperties.copyFrom(oprops);
    }

    public OutputProperties getOutputComposed() {
        return this.m_outputProperties;
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    void recomposeAttributeSets(ElemAttributeSet attrSet) {
        Vector<ElemAttributeSet> attrSetList = (Vector<ElemAttributeSet>)this.m_attrSets.get(attrSet.getName());
        if (null == attrSetList) {
            attrSetList = new Vector<ElemAttributeSet>();
            this.m_attrSets.put(attrSet.getName(), attrSetList);
        }
        attrSetList.addElement(attrSet);
    }

    public Vector getAttributeSetComposed(QName name) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(name);
    }

    void recomposeDecimalFormats(DecimalFormatProperties dfp) {
        DecimalFormatSymbols oldDfs = (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(dfp.getName());
        if (null == oldDfs) {
            this.m_decimalFormatSymbols.put(dfp.getName(), dfp.getDecimalFormatSymbols());
        } else if (!dfp.getDecimalFormatSymbols().equals(oldDfs)) {
            String themsg = dfp.getName().equals(new QName("")) ? XSLMessages.createWarning("WG_ONE_DEFAULT_XSLDECIMALFORMAT_ALLOWED", new Object[0]) : XSLMessages.createWarning("WG_XSLDECIMALFORMAT_NAMES_MUST_BE_UNIQUE", new Object[]{dfp.getName()});
            this.error(themsg);
        }
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName name) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(name);
    }

    void recomposeKeys(KeyDeclaration keyDecl) {
        this.m_keyDecls.addElement(keyDecl);
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    void recomposeNamespaceAliases(NamespaceAlias nsAlias) {
        this.m_namespaceAliasComposed.put(nsAlias.getStylesheetNamespace(), nsAlias);
    }

    public NamespaceAlias getNamespaceAliasComposed(String uri) {
        return null == this.m_namespaceAliasComposed ? null : this.m_namespaceAliasComposed.get(uri);
    }

    void recomposeTemplates(ElemTemplate template) {
        this.m_templateList.setTemplate(template);
    }

    void recomposeOverlays(ElemOverlay overlay) {
        this.m_overlayList.setTemplate(overlay);
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public final TemplateList getOverlayListComposed() {
        return this.m_overlayList;
    }

    public final void setTemplateListComposed(TemplateList templateList) {
        this.m_templateList = templateList;
    }

    public ElemTemplate getTemplateComposed(XPathContext xctxt, int targetNode, QName mode, boolean quietConflictWarnings, DTM dtm) throws TransformerException {
        return this.m_templateList.getTemplate(xctxt, targetNode, mode, quietConflictWarnings, dtm);
    }

    public ElemTemplate getTemplateComposed(XPathContext xctxt, int targetNode, QName mode, int maxImportLevel, int endImportLevel, boolean quietConflictWarnings, DTM dtm) throws TransformerException {
        return this.m_templateList.getTemplate(xctxt, targetNode, mode, maxImportLevel, endImportLevel, quietConflictWarnings, dtm);
    }

    public ElemTemplate getTemplateComposed(QName qname) {
        return this.m_templateList.getTemplate(qname);
    }

    void recomposeVariables(ElemVariable elemVar) {
        if (this.getVariableOrParamComposed(elemVar.getName()) == null) {
            elemVar.setIsTopLevel(true);
            elemVar.setIndex(this.m_variables.size());
            this.m_variables.addElement(elemVar);
        }
    }

    public ElemVariable getVariableOrParamComposed(QName qname) {
        if (null != this.m_variables) {
            int n = this.m_variables.size();
            for (int i = 0; i < n; ++i) {
                ElemVariable var = (ElemVariable)this.m_variables.elementAt(i);
                if (!var.getName().equals(qname)) continue;
                return var;
            }
        }
        return null;
    }

    public Vector getVariablesAndParamsComposed() {
        return this.m_variables;
    }

    void recomposeWhiteSpaceInfo(WhiteSpaceInfo wsi) {
        if (null == this.m_whiteSpaceInfoList) {
            this.m_whiteSpaceInfoList = new TemplateList();
        }
        this.m_whiteSpaceInfoList.setTemplate(wsi);
    }

    public boolean shouldCheckWhitespace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext support, int targetElement, DTM dtm) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, false, dtm);
        }
        return null;
    }

    public boolean shouldStripWhiteSpace(XPathContext support, int targetElement) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            while (-1 != targetElement) {
                DTM dtm = support.getDTM(targetElement);
                WhiteSpaceInfo info = (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, false, dtm);
                if (null != info) {
                    return info.getShouldStripSpace();
                }
                int parent = dtm.getParent(targetElement);
                if (-1 != parent && 1 == dtm.getNodeType(parent)) {
                    targetElement = parent;
                    continue;
                }
                targetElement = -1;
            }
        }
        return false;
    }

    public boolean canStripWhiteSpace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    public final ElemTemplate getStartRule() {
        return this.m_startRule;
    }

    private void initDefaultRule(ErrorListener errorListener) throws TransformerException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet(this);
        XPath defMatch = new XPath("*", this, this, 1, errorListener);
        this.m_defaultRule.setMatch(defMatch);
        ElemApplyTemplates childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        childrenElement.setSelect(this.m_selectDefault);
        this.m_defaultRule.appendChild(childrenElement);
        this.m_startRule = this.m_defaultRule;
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet(this);
        defMatch = new XPath("text() | @*", this, this, 1, errorListener);
        this.m_defaultTextRule.setMatch(defMatch);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild(elemValueOf);
        elemValueOf.setSelect(this.m_selectCurrent);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet(this);
        defMatch = new XPath("/", this, this, 1, errorListener);
        this.m_defaultRootRule.setMatch(defMatch);
        childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild(childrenElement);
        childrenElement.setSelect(this.m_selectDefault);
    }

    private void QuickSort2(Vector v, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            ElemTemplateElement midNode = (ElemTemplateElement)v.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && ((ElemTemplateElement)v.elementAt(lo)).compareTo(midNode) < 0) {
                    ++lo;
                }
                while (hi > lo0 && ((ElemTemplateElement)v.elementAt(hi)).compareTo(midNode) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                ElemTemplateElement node = (ElemTemplateElement)v.elementAt(lo);
                v.setElementAt(v.elementAt(hi), lo);
                v.setElementAt(node, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort2(v, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort2(v, lo, hi0);
            }
        }
    }

    void initComposeState() {
        this.m_composeState = new ComposeState();
    }

    ComposeState getComposeState() {
        return this.m_composeState;
    }

    private void clearComposeState() {
        this.m_composeState = null;
    }

    class ComposeState {
        private ExpandedNameTable m_ent = new ExpandedNameTable();
        private Vector m_variableNames = new Vector();
        IntStack m_marks = new IntStack();
        private int m_maxStackFrameSize;

        ComposeState() {
            int size = StylesheetRoot.this.m_variables.size();
            for (int i = 0; i < size; ++i) {
                ElemVariable ev = (ElemVariable)StylesheetRoot.this.m_variables.elementAt(i);
                this.m_variableNames.addElement(ev.getName());
            }
        }

        public int getQNameID(QName qname) {
            return this.m_ent.getExpandedTypeID(qname.getNamespace(), qname.getLocalName(), 1);
        }

        int addVariableName(QName qname) {
            int pos = this.m_variableNames.size();
            this.m_variableNames.addElement(qname);
            int frameSize = this.m_variableNames.size() - this.getGlobalsSize();
            if (frameSize > this.m_maxStackFrameSize) {
                ++this.m_maxStackFrameSize;
            }
            return pos;
        }

        void resetStackFrameSize() {
            this.m_maxStackFrameSize = 0;
        }

        int getFrameSize() {
            return this.m_maxStackFrameSize;
        }

        int getCurrentStackFrameSize() {
            return this.m_variableNames.size();
        }

        void setCurrentStackFrameSize(int sz) {
            this.m_variableNames.setSize(sz);
        }

        int getGlobalsSize() {
            return StylesheetRoot.this.m_variables.size();
        }

        void pushStackMark() {
            this.m_marks.push(this.getCurrentStackFrameSize());
        }

        void popStackMark() {
            int mark = this.m_marks.pop();
            this.setCurrentStackFrameSize(mark);
        }

        Vector getVariableNames() {
            return this.m_variableNames;
        }
    }
}

