/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.transformer;

import com.scenari.xsldtm.xalan.serialize.SerializerUtils;
import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.serializer.SerializationHandler;
import com.scenari.xsldtm.xml.utils.XMLString;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ClonerToResultTree {
    public static void cloneToResultTree(int node, int nodeType, DTM dtm, SerializationHandler rth, boolean shouldCloneAttributes) throws TransformerException {
        try {
            switch (nodeType) {
                case 3: {
                    dtm.dispatchCharactersEvents(node, rth, false);
                    break;
                }
                case 9: 
                case 11: {
                    break;
                }
                case 1: {
                    String ns = dtm.getNamespaceURI(node);
                    if (ns == null) {
                        ns = "";
                    }
                    String localName = dtm.getLocalName(node);
                    rth.startElement(ns, localName, dtm.getNodeNameX(node));
                    if (shouldCloneAttributes) {
                        SerializerUtils.addAttributes(rth, node);
                        SerializerUtils.processNSDecls(rth, node, nodeType, dtm);
                    }
                    break;
                }
                case 4: {
                    rth.startCDATA();
                    dtm.dispatchCharactersEvents(node, rth, false);
                    rth.endCDATA();
                    break;
                }
                case 2: {
                    SerializerUtils.addAttribute(rth, node);
                    break;
                }
                case 13: {
                    SerializerUtils.processNSDecls(rth, node, 13, dtm);
                    break;
                }
                case 8: {
                    XMLString xstr = dtm.getStringValue(node);
                    xstr.dispatchAsComment(rth);
                    break;
                }
                case 5: {
                    rth.entityReference(dtm.getNodeNameX(node));
                    break;
                }
                case 7: {
                    rth.processingInstruction(dtm.getNodeNameX(node), dtm.getNodeValue(node));
                    break;
                }
                default: {
                    throw new TransformerException("Can't clone node: " + dtm.getNodeName(node));
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

