/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.transformer;

import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.KeyDeclaration;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xpath.XPath;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.axes.OneStepIteratorForward;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class KeyIterator
extends OneStepIteratorForward {
    private QName m_name;
    private Vector m_keyDeclarations;

    public QName getName() {
        return this.m_name;
    }

    public Vector getKeyDeclarations() {
        return this.m_keyDeclarations;
    }

    KeyIterator(QName name, Vector keyDeclarations) {
        super(16);
        this.m_keyDeclarations = keyDeclarations;
        this.m_name = name;
    }

    public short acceptNode(int testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        XPathContext xctxt = ki.getXPathContext();
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            int nDeclarations = keys.size();
            for (int i = 0; i < nDeclarations; ++i) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i);
                if (!kd.getName().equals(name)) continue;
                foundKey = true;
                XPath matchExpr = kd.getMatch();
                double score = matchExpr.getMatchScore(xctxt, testNode);
                kd.getMatch();
                if (score == Double.NEGATIVE_INFINITY) continue;
                return 1;
            }
        }
        catch (TransformerException se) {
            // empty catch block
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage("ER_NO_XSLKEY_DECLARATION", new Object[]{name.getLocalName()}));
        }
        return 2;
    }
}

