/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.transformer;

import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.KeyDeclaration;
import com.scenari.xsldtm.xalan.transformer.KeyIterator;
import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.dtm.DTMAxisTraverser;
import com.scenari.xsldtm.xml.dtm.DTMIterator;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xml.utils.WrappedRuntimeException;
import com.scenari.xsldtm.xml.utils.XMLString;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.axes.ChildTestIterator;
import com.scenari.xsldtm.xpath.objects.XNodeSet;
import com.scenari.xsldtm.xpath.objects.XObject;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class KeyRefIterator
extends ChildTestIterator {
    DTMIterator m_keysNodes;
    protected XMLString m_ref;
    protected QName m_name;
    protected Vector m_keyDeclarations;

    public KeyRefIterator(QName name, XMLString ref, Vector keyDecls, DTMIterator ki) {
        super((DTMAxisTraverser)null);
        this.m_name = name;
        this.m_ref = ref;
        this.m_keyDeclarations = keyDecls;
        this.m_keysNodes = ki;
        this.setWhatToShow(-1);
    }

    protected int getNextNode() {
        int next;
        while (-1 != (next = this.m_keysNodes.nextNode()) && 1 != this.filterNode(next)) {
        }
        this.m_lastFetched = next;
        return next;
    }

    public short filterNode(int testNode) {
        boolean foundKey = false;
        Vector keys = this.m_keyDeclarations;
        QName name = this.m_name;
        KeyIterator ki = (KeyIterator)((XNodeSet)this.m_keysNodes).getContainedIter();
        XPathContext xctxt = ki.getXPathContext();
        if (null == xctxt) {
            this.assertion(false, "xctxt can not be null here!");
        }
        try {
            XMLString lookupKey = this.m_ref;
            int nDeclarations = keys.size();
            for (int i = 0; i < nDeclarations; ++i) {
                int useNode;
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i);
                if (!kd.getName().equals(name)) continue;
                foundKey = true;
                XObject xuse = kd.getUse().execute(xctxt, testNode, ki.getPrefixResolver());
                if (xuse.getType() != 4) {
                    XMLString exprResult = xuse.xstr();
                    if (!lookupKey.equals(exprResult)) continue;
                    return 1;
                }
                DTMIterator nl = ((XNodeSet)xuse).iterRaw();
                while (-1 != (useNode = nl.nextNode())) {
                    DTM dtm = this.getDTM(useNode);
                    XMLString exprResult = dtm.getStringValue(useNode);
                    if (null == exprResult || !lookupKey.equals(exprResult)) continue;
                    return 1;
                }
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage("ER_NO_XSLKEY_DECLARATION", new Object[]{name.getLocalName()}));
        }
        return 2;
    }
}

