/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xalan.transformer;

import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.ElemTemplate;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.transformer.TransformerImpl;
import com.scenari.xsldtm.xml.utils.ObjectStack;
import javax.xml.transform.TransformerException;

public class StackGuard {
    public static int m_recursionLimit = -1;
    TransformerImpl m_transformer;

    public int getRecursionLimit() {
        return m_recursionLimit;
    }

    public void setRecursionLimit(int limit) {
        m_recursionLimit = limit;
    }

    public StackGuard(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public int countLikeTemplates(ElemTemplate templ, int pos) {
        ObjectStack elems = this.m_transformer.getCurrentTemplateElements();
        int count = 1;
        for (int i = pos - 1; i >= 0; --i) {
            if ((ElemTemplateElement)elems.elementAt(i) != templ) continue;
            ++count;
        }
        return count;
    }

    private ElemTemplate getNextMatchOrNamedTemplate(int pos) {
        ObjectStack elems = this.m_transformer.getCurrentTemplateElements();
        for (int i = pos; i >= 0; --i) {
            ElemTemplateElement elem = (ElemTemplateElement)elems.elementAt(i);
            if (null == elem || elem.getXSLToken() != 19) continue;
            return (ElemTemplate)elem;
        }
        return null;
    }

    public void checkForInfinateLoop() throws TransformerException {
        ElemTemplate template;
        int nTemplates = this.m_transformer.getCurrentTemplateElementsCount();
        if (nTemplates < m_recursionLimit) {
            return;
        }
        if (m_recursionLimit <= 0) {
            return;
        }
        for (int i = nTemplates - 1; i >= m_recursionLimit && null != (template = this.getNextMatchOrNamedTemplate(i)); --i) {
            int loopCount = this.countLikeTemplates(template, i);
            if (loopCount < m_recursionLimit) continue;
            String idIs = XSLMessages.createMessage(null != template.getName() ? "nameIs" : "matchPatternIs", null);
            Object[] msgArgs = new Object[]{new Integer(loopCount), idIs, null != template.getName() ? template.getName().toString() : template.getMatch().getPatternString()};
            String msg = XSLMessages.createMessage("recursionTooDeep", msgArgs);
            throw new TransformerException(msg);
        }
    }
}

