/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xpath.objects;

import com.scenari.xsldtm.xml.utils.WrappedRuntimeException;
import com.scenari.xsldtm.xpath.ExpressionOwner;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.XPathVisitor;
import com.scenari.xsldtm.xpath.objects.XObject;
import javax.xml.transform.TransformerException;

public class XNumber
extends XObject {
    double m_val;

    public XNumber(double d) {
        this.m_val = d;
    }

    public XNumber(Number num) {
        this.m_val = num.doubleValue();
        this.m_obj = num;
    }

    public int getType() {
        return 2;
    }

    public String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.m_val;
    }

    public double num(XPathContext xctxt) throws TransformerException {
        return this.m_val;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public String str() {
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        if (this.m_val == 0.0) {
            return "0";
        }
        if (this.m_val == 1.0) {
            return "1";
        }
        return com.scenari.xsldom.xpath.objects.XNumber.sFormatter.get().format(this.m_val);
    }

    public Object object() {
        if (null == this.m_obj) {
            this.m_obj = new Double(this.m_val);
        }
        return this.m_obj;
    }

    public boolean equals(XObject obj2) {
        int t = obj2.getType();
        try {
            if (t == 4) {
                return obj2.equals(this);
            }
            if (t == 1) {
                return obj2.bool() == this.bool();
            }
            return this.m_val == obj2.num();
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
    }

    public boolean isStableNumber() {
        return true;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitNumberLiteral(owner, this);
    }
}

