/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xpath.objects;

import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.dtm.DTMIterator;
import com.scenari.xsldtm.xml.dtm.ref.DTMNodeIterator;
import com.scenari.xsldtm.xml.dtm.ref.DTMNodeList;
import com.scenari.xsldtm.xml.utils.FastStringBuilder;
import com.scenari.xsldtm.xml.utils.WrappedRuntimeException;
import com.scenari.xsldtm.xml.utils.XMLString;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.ExpressionNode;
import com.scenari.xsldtm.xpath.NodeSetDTM;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.axes.RTFIterator;
import com.scenari.xsldtm.xpath.objects.XObject;
import com.scenari.xsldtm.xpath.objects.XString;
import javax.xml.transform.TransformerException;
import org.w3c.dom.NodeList;

public class XRTreeFrag
extends XObject
implements Cloneable {
    DTM m_dtm;
    int m_dtmRoot;
    XPathContext m_xctxt;
    boolean m_allowRelease = false;
    private XMLString m_xmlStr = null;

    public XRTreeFrag(int root, XPathContext xctxt, ExpressionNode parent) {
        super(null);
        this.exprSetParent(parent);
        this.m_dtmRoot = root;
        this.m_xctxt = xctxt;
        this.m_dtm = xctxt.getDTM(root);
    }

    public XRTreeFrag(int root, XPathContext xctxt) {
        super(null);
        this.m_dtmRoot = root;
        this.m_xctxt = xctxt;
        this.m_dtm = xctxt.getDTM(root);
    }

    public Object object() {
        if (this.m_xctxt != null) {
            return new DTMNodeIterator(new NodeSetDTM(this.m_dtmRoot, this.m_xctxt.getDTMManager()));
        }
        return super.object();
    }

    public XRTreeFrag(Expression expr) {
        super(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public void allowDetachToRelease(boolean allowRelease) {
        this.m_allowRelease = allowRelease;
    }

    public void detach() {
        if (this.m_allowRelease) {
            int ident = this.m_xctxt.getDTMIdentity(this.m_dtm);
            DTM foundDTM = this.m_xctxt.getDTM(ident);
            if (foundDTM == this.m_dtm) {
                this.m_xctxt.release(this.m_dtm, true);
                this.m_dtm = null;
                this.m_xctxt = null;
            }
            this.m_obj = null;
        }
    }

    public void destruct() {
        int ident;
        DTM foundDTM;
        if (null != this.m_dtm && (foundDTM = this.m_xctxt.getDTM(ident = this.m_xctxt.getDTMIdentity(this.m_dtm))) == this.m_dtm) {
            this.m_xctxt.release(this.m_dtm, true);
            this.m_dtm = null;
            this.m_xctxt = null;
        }
        this.m_obj = null;
    }

    public int getType() {
        return 5;
    }

    public String getTypeString() {
        return "#RTREEFRAG";
    }

    public double num() throws TransformerException {
        XMLString s = this.xstr();
        return s.toDouble();
    }

    public boolean bool() {
        return true;
    }

    public XMLString xstr() {
        if (null == this.m_xmlStr) {
            this.m_xmlStr = this.m_dtm.getStringValue(this.m_dtmRoot);
        }
        return this.m_xmlStr;
    }

    public void appendToFsb(FastStringBuilder fsb) {
        XString xstring = (XString)this.xstr();
        xstring.appendToFsb(fsb);
    }

    public String str() {
        return ((Object)this.xstr()).toString();
    }

    public int rtf() {
        return this.m_dtmRoot;
    }

    public DTMIterator asNodeIterator() {
        return new RTFIterator(this.m_dtmRoot, this.m_xctxt.getDTMManager());
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return new DTMNodeList(this.asNodeIterator());
    }

    public boolean equals(XObject obj2) {
        try {
            if (4 == obj2.getType()) {
                return obj2.equals(this);
            }
            if (1 == obj2.getType()) {
                return this.bool() == obj2.bool();
            }
            if (2 == obj2.getType()) {
                return this.num() == obj2.num();
            }
            if (4 == obj2.getType()) {
                return this.xstr().equals(obj2.xstr());
            }
            if (3 == obj2.getType()) {
                return this.xstr().equals(obj2.xstr());
            }
            if (5 == obj2.getType()) {
                return this.xstr().equals(obj2.xstr());
            }
            return super.equals(obj2);
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
    }
}

