/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xpath.objects;

import com.scenari.xsldtm.xml.dtm.DTM;
import com.scenari.xsldtm.xml.utils.WrappedRuntimeException;
import com.scenari.xsldtm.xml.utils.XMLCharacterRecognizer;
import com.scenari.xsldtm.xml.utils.XMLString;
import com.scenari.xsldtm.xml.utils.XMLStringFactory;
import com.scenari.xsldtm.xpath.ExpressionOwner;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.XPathVisitor;
import com.scenari.xsldtm.xpath.objects.XMLStringFactoryImpl;
import com.scenari.xsldtm.xpath.objects.XNodeSet;
import com.scenari.xsldtm.xpath.objects.XNumber;
import com.scenari.xsldtm.xpath.objects.XObject;
import java.util.Locale;
import javax.xml.transform.TransformerException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XString
extends XObject
implements XMLString {
    public static XString EMPTYSTRING = new XString("");

    protected XString(Object val) {
        super(val);
    }

    public XString(String val) {
        super(val);
    }

    public int getType() {
        return 3;
    }

    public String getTypeString() {
        return "#STRING";
    }

    public boolean hasString() {
        return true;
    }

    public double num() {
        return this.toDouble();
    }

    public double toDouble() {
        char c;
        int end = this.length();
        if (0 == end) {
            return Double.NaN;
        }
        double result = 0.0;
        int start = 0;
        int punctPos = end - 1;
        for (int i = start; i < end && XMLCharacterRecognizer.isWhiteSpace(c = this.charAt(i)); ++i) {
            ++start;
        }
        double sign = 1.0;
        if (start < end && this.charAt(start) == '-') {
            sign = -1.0;
            ++start;
        }
        int digitsFound = 0;
        for (int i = start; i < end; ++i) {
            char c2 = this.charAt(i);
            if (c2 != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c2)) break;
                if (Character.isDigit(c2)) {
                    result = result * 10.0 + (double)(c2 - 48);
                    ++digitsFound;
                    continue;
                }
                return Double.NaN;
            }
            punctPos = i;
            break;
        }
        if (this.charAt(punctPos) == '.') {
            char c3;
            double fractPart = 0.0;
            for (int i = end - 1; i > punctPos && !XMLCharacterRecognizer.isWhiteSpace(c3 = this.charAt(i)); --i) {
                if (Character.isDigit(c3)) {
                    fractPart = fractPart / 10.0 + (double)(c3 - 48);
                    ++digitsFound;
                    continue;
                }
                return Double.NaN;
            }
            result += fractPart / 10.0;
        }
        if (0 == digitsFound) {
            return Double.NaN;
        }
        return result * sign;
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public XMLString xstr() {
        return this;
    }

    public String str() {
        return null != this.m_obj ? (String)this.m_obj : "";
    }

    public int rtf(XPathContext support) {
        DTM frag = support.createDocumentFragment();
        frag.appendTextChild(this.str());
        return frag.getDocument();
    }

    public void dispatchCharactersEvents(ContentHandler ch) throws SAXException {
        String str = this.str();
        ch.characters(str.toCharArray(), 0, str.length());
    }

    public void dispatchAsComment(LexicalHandler lh) throws SAXException {
        String str = this.str();
        lh.comment(str.toCharArray(), 0, str.length());
    }

    public int length() {
        return this.str().length();
    }

    public char charAt(int index) {
        return this.str().charAt(index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.str().getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public boolean equals(XObject obj2) {
        int t = obj2.getType();
        try {
            if (4 == t) {
                return obj2.equals(this);
            }
            if (1 == t) {
                return obj2.bool() == this.bool();
            }
            if (2 == t) {
                return obj2.num() == this.num();
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        return this.xstr().equals(obj2.xstr());
    }

    public boolean equals(XMLString obj2) {
        if (!obj2.hasString()) {
            return obj2.equals(this);
        }
        return this.str().equals(((Object)obj2).toString());
    }

    public boolean equals(Object obj2) {
        if (null == obj2) {
            return false;
        }
        if (obj2 instanceof XNodeSet) {
            return obj2.equals(this);
        }
        if (obj2 instanceof XNumber) {
            return obj2.equals(this);
        }
        return this.str().equals(obj2.toString());
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.str().equalsIgnoreCase(anotherString);
    }

    public int compareTo(XMLString xstr) {
        int len1 = this.length();
        int len2 = xstr.length();
        int n = Math.min(len1, len2);
        int i = 0;
        int j = 0;
        while (n-- != 0) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 != (c2 = xstr.charAt(j))) {
                return c1 - c2;
            }
            ++i;
            ++j;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(XMLString str) {
        throw new WrappedRuntimeException(new NoSuchMethodException("Java 1.2 method, not yet implemented"));
    }

    public boolean startsWith(String prefix, int toffset) {
        return this.str().startsWith(prefix, toffset);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(XMLString prefix, int toffset) {
        int to = toffset;
        int tlim = this.length();
        int po = 0;
        int pc = prefix.length();
        if (toffset < 0 || toffset > tlim - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (this.charAt(to) != prefix.charAt(po)) {
                return false;
            }
            ++to;
            ++po;
        }
        return true;
    }

    public boolean startsWith(XMLString prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.str().endsWith(suffix);
    }

    public int hashCode() {
        return this.str().hashCode();
    }

    public int indexOf(int ch) {
        return this.str().indexOf(ch);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.str().indexOf(ch, fromIndex);
    }

    public int lastIndexOf(int ch) {
        return this.str().lastIndexOf(ch);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        return this.str().lastIndexOf(ch, fromIndex);
    }

    public int indexOf(String str) {
        return this.str().indexOf(str);
    }

    public int indexOf(XMLString str) {
        return this.str().indexOf(((Object)str).toString());
    }

    public int indexOf(String str, int fromIndex) {
        return this.str().indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.str().lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.str().lastIndexOf(str, fromIndex);
    }

    public XMLString substring(int beginIndex) {
        return new XString(this.str().substring(beginIndex));
    }

    public XMLString substring(int beginIndex, int endIndex) {
        return new XString(this.str().substring(beginIndex, endIndex));
    }

    public XMLString concat(String str) {
        return new XString(this.str().concat(str));
    }

    public XMLString toLowerCase(Locale locale) {
        return new XString(this.str().toLowerCase(locale));
    }

    public XMLString toLowerCase() {
        return new XString(this.str().toLowerCase());
    }

    public XMLString toUpperCase(Locale locale) {
        return new XString(this.str().toUpperCase(locale));
    }

    public XMLString toUpperCase() {
        return new XString(this.str().toUpperCase());
    }

    public XMLString trim() {
        return new XString(this.str().trim());
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }

    public XMLString fixWhiteSpace(boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        int s;
        int len = this.length();
        char[] buf = new char[len];
        this.getChars(0, len, buf, 0);
        boolean edit = false;
        for (s = 0; s < len && !XString.isSpace(buf[s]); ++s) {
        }
        int d = s;
        boolean pres = false;
        while (s < len) {
            char c = buf[s];
            if (XString.isSpace(c)) {
                if (!pres) {
                    if (' ' != c) {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && s != 0) {
                        char prevChar = buf[s - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && 1 <= d && ' ' == buf[d - 1]) {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && 0 < d && ' ' == buf[0]) {
            edit = true;
            ++start;
        }
        XMLStringFactory xsf = XMLStringFactoryImpl.getFactory();
        return edit ? xsf.newstr(new String(buf, start, d - start)) : this;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitStringLiteral(owner, this);
    }
}

