/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldtm.xpath.operations;

import com.scenari.xsldtm.xalan.res.XSLMessages;
import com.scenari.xsldtm.xalan.templates.ElemTemplateElement;
import com.scenari.xsldtm.xalan.templates.ElemVariable;
import com.scenari.xsldtm.xalan.templates.Stylesheet;
import com.scenari.xsldtm.xml.utils.QName;
import com.scenari.xsldtm.xml.utils.WrappedRuntimeException;
import com.scenari.xsldtm.xpath.Expression;
import com.scenari.xsldtm.xpath.ExpressionNode;
import com.scenari.xsldtm.xpath.ExpressionOwner;
import com.scenari.xsldtm.xpath.XPath;
import com.scenari.xsldtm.xpath.XPathContext;
import com.scenari.xsldtm.xpath.XPathVisitor;
import com.scenari.xsldtm.xpath.axes.PathComponent;
import com.scenari.xsldtm.xpath.objects.XNodeSet;
import com.scenari.xsldtm.xpath.objects.XObject;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class Variable
extends Expression
implements PathComponent {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;
    static final String PSUEDOVARNAMESPACE = "http://xml.apache.org/xalan/psuedovar";

    public void setIndex(int index) {
        this.m_index = index;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIsGlobal(boolean isGlobal) {
        this.m_isGlobal = isGlobal;
    }

    public boolean getGlobal() {
        return this.m_isGlobal;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_fixUpWasCalled = true;
        for (int i = vars.size() - 1; i >= 0; --i) {
            QName qn = (QName)vars.elementAt(i);
            if (!qn.equals(this.m_qname)) continue;
            if (i < globalsSize) {
                this.m_isGlobal = true;
                this.m_index = i;
            } else {
                this.m_index = i - globalsSize;
            }
            return;
        }
        String msg = XSLMessages.createXPATHMessage("ER_COULD_NOT_FIND_VAR", new Object[]{this.m_qname.toString()});
        TransformerException te = new TransformerException(msg, this);
        throw new WrappedRuntimeException(te);
    }

    public void setQName(QName qname) {
        this.m_qname = qname;
    }

    public QName getQName() {
        return this.m_qname;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject execute(XPathContext xctxt, boolean destructiveOK) throws TransformerException {
        if (this.m_fixUpWasCalled) {
            XObject result = this.m_isGlobal ? xctxt.getVarStack().getGlobalVariable(xctxt, this.m_index, destructiveOK) : xctxt.getVarStack().getLocalVariable(xctxt, this.m_index, destructiveOK);
            if (null == result) {
                this.warn(xctxt, "WG_ILLEGAL_VARIABLE_REFERENCE", new Object[]{this.m_qname.getLocalPart()});
                result = new XNodeSet(xctxt.getDTMManager());
            }
            return result;
        }
        Variable variable = this;
        synchronized (variable) {
            ElemVariable vvar = this.getElemVariable();
            if (null != vvar) {
                this.m_index = vvar.getIndex();
                this.m_isGlobal = vvar.getIsTopLevel();
                this.m_fixUpWasCalled = true;
                return this.execute(xctxt);
            }
        }
        throw new TransformerException(XSLMessages.createXPATHMessage("ER_VAR_NOT_RESOLVABLE", new Object[]{this.m_qname.toString()}));
    }

    public ElemVariable getElemVariable() {
        ExpressionNode owner = this.getExpressionOwner();
        if (null != owner && owner instanceof ElemTemplateElement) {
            ElemVariable vvar;
            ElemTemplateElement prev = (ElemTemplateElement)owner;
            if (!(prev instanceof Stylesheet)) {
                while (!(prev.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement savedprev = prev;
                    while (null != (prev = prev.getPreviousSiblingElem())) {
                        if (!(prev instanceof ElemVariable) || !(vvar = (ElemVariable)prev).getName().equals(this.m_qname)) continue;
                        return vvar;
                    }
                    prev = savedprev.getParentElem();
                }
            }
            if (null != (vvar = prev.getStylesheetRoot().getVariableOrParamComposed(this.m_qname))) {
                return vvar;
            }
        }
        return null;
    }

    public boolean isStableNumber() {
        return true;
    }

    public int getAnalysisBits() {
        Expression expr;
        XPath xpath;
        ElemVariable vvar = this.getElemVariable();
        if (null != vvar && null != (xpath = vvar.getSelect()) && null != (expr = xpath.getExpression()) && expr instanceof PathComponent) {
            return ((PathComponent)((Object)expr)).getAnalysisBits();
        }
        return 0x4000000;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitVariableRef(owner, this);
    }

    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        if (!this.m_qname.equals(((Variable)expr).m_qname)) {
            return false;
        }
        return this.getElemVariable() == ((Variable)expr).getElemVariable();
    }

    public boolean isPsuedoVarRef() {
        String ns = this.m_qname.getNamespaceURI();
        return null != ns && ns.equals(PSUEDOVARNAMESPACE) && this.m_qname.getLocalName().startsWith("#");
    }
}

