/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.facet.export;

import com.scenari.m.bdp.facet.Facet;
import com.scenari.m.bdp.item.IHAttr;
import com.scenari.m.bdp.item.IHItem;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.rename.HRenamingPlan;
import com.scenari.m.bdp.module.rename.IHModuleRename;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.helpers.base.SrcNodeWrapper;
import eu.scenari.facet.export.IFacetExporter;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.IBlob;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.InputStream;
import java.util.Iterator;

public class FacetExport
extends Facet
implements IFacetExporter {
    public FacetExport(IHItemType pItemType, String pCdModule) {
        super(pItemType, pCdModule, null);
    }

    public ISrcNode getFacet(IWspSrc pSrcItem, String pIdSubItem, HTransformParams pParams) throws Exception {
        if (!this.hasRefUriToRename(pSrcItem)) {
            return pSrcItem;
        }
        return this.xExportItem(new UriReplacement(pSrcItem), pSrcItem, pParams);
    }

    public ISrcNode exportItem(IHRenamingPlan pRenamingPlan, IWspSrc pSrcItem, HTransformParams pParams) throws Exception {
        if (!this.hasRefUriToRename(pSrcItem)) {
            return pSrcItem;
        }
        return new SrcNodeRenamedStreams(pSrcItem, pRenamingPlan);
    }

    protected boolean hasRefUriToRename(IWspSrc pSrcItem) throws Exception {
        if (SrcFeatureIds.getSrcId(pSrcItem) == null) {
            return false;
        }
        IHItem vItem = pSrcItem.getAspect(IWspSrc.ITEM_ASPECT_TYPE);
        if (vItem.hCountAttrs() > 0) {
            Iterator vIterator = vItem.hGetAttrs();
            while (vIterator.hasNext()) {
                IHAttr vAttr = (IHAttr)vIterator.next();
                if (vAttr.hGetTypeAttr() != "Link" && vAttr.hGetTypeAttr() != "Ref") continue;
                return true;
            }
        }
        return false;
    }

    protected ISrcNode xExportItem(IHRenamingPlan pRenamingPlan, ISrcNode pSrcNode, HTransformParams pParams) throws Exception {
        return new SrcNodeRenamedStreams(pSrcNode, pRenamingPlan);
    }

    public class SrcNodeRenamedStreams
    extends SrcNodeWrapper {
        protected IHRenamingPlan fRenamingPlan;
        protected IByteStream fStream;
        protected int fContentSize;

        public SrcNodeRenamedStreams(ISrcNode pSubSource, IHRenamingPlan pRenamingPlan) throws Exception {
            super(pSubSource);
            this.fStream = null;
            this.fContentSize = -3;
            this.fRenamingPlan = pRenamingPlan;
        }

        protected boolean isAspectFromSubSourceAllowed(ISrcAspectDef pDefinition) throws Exception {
            if (pDefinition.canReadContent()) {
                return false;
            }
            return super.isAspectFromSubSourceAllowed(pDefinition);
        }

        public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
            this.buildStream();
            if (this.fContentSize == -2) {
                return super.newInputStream(pEnsureBuffered);
            }
            if (this.fStream == null) {
                this.buildStream();
            }
            InputStream vIn = this.fStream.getInputStream(true);
            this.fStream = null;
            return vIn;
        }

        public int getContentSize() throws Exception {
            this.buildStream();
            if (this.fContentSize == -2) {
                return super.getContentSize();
            }
            if (this.fContentSize == -1) {
                this.fStream = this.fStream.transformAsBlob();
                this.fContentSize = ((IBlob)this.fStream).getLength();
            }
            return this.fContentSize;
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) throws Exception {
            return new SrcNodeRenamedStreams(pSubSource, this.fRenamingPlan);
        }

        protected void buildStream() throws Exception {
            IHModuleRename vRenameModule;
            if (this.fStream != null || this.fContentSize == -2) {
                return;
            }
            if ((this.fContentSize != -3 || this.getSubSrcNode().getContentStatus() == 1) && (vRenameModule = FacetExport.this.hGetItemType().hGetModuleRename()) != null) {
                this.fStream = vRenameModule.renameStream(this.fRenamingPlan, this.getSubSrcNode(), this.getSubSrcNode());
                if (this.fStream != null) {
                    if (this.fContentSize == -3) {
                        this.fContentSize = -1;
                    }
                    return;
                }
            }
            if (this.fContentSize == -3) {
                this.fContentSize = -2;
            }
        }
    }

    public static class UriReplacement
    extends HRenamingPlan {
        protected ISrcNode fSrcFrom = null;

        public UriReplacement(ISrcNode pSrcFrom) {
            this.fSrcFrom = pSrcFrom;
        }

        public String getNewRefUri(String pOldRefUri) {
            try {
                if (SrcFeatureIds.isSrcId(pOldRefUri)) {
                    return SrcFeatureIds.findUriById(this.fSrcFrom, pOldRefUri);
                }
                return pOldRefUri;
            }
            catch (Exception e) {
                LogMgr.publishException(e);
                return pOldRefUri;
            }
        }

        public boolean isInPlan(String pRefUri) {
            return false;
        }
    }
}

