/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.initapp;

import java.text.DecimalFormat;
import java.text.FieldPosition;

public class ScVersion
implements Comparable {
    public static final String MAJOR = "major";
    public static final String MEDIUM = "medium";
    public static final String MINOR = "minor";
    public static final ScVersion UNDEFINED_VERSION = new ScVersion("").lock();
    public static final int UNDEFINED_NUMBER = -1;
    private static final int NOTCALCULATED = -2;
    private static final DecimalFormat MINOR_FORMATTER = new DecimalFormat("000");
    private static final FieldPosition FORMATTER_FIELDPOS = new FieldPosition(0);
    protected int fMajorVersion = -1;
    protected int fMediumVersion = -1;
    protected int fMinorVersion = -1;
    protected String fVersion = "";
    protected boolean fLocked = false;

    public ScVersion() {
    }

    public ScVersion(String pVersion) {
        this.setVersion(pVersion);
    }

    public ScVersion(ScVersion pFrom) {
        this.setVersion(pFrom.getMajorVersion(), pFrom.getMediumVersion(), pFrom.getMinorVersion());
    }

    public void setVersionUndefined() {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMajorVersion = -1;
        this.fMediumVersion = -1;
        this.fMinorVersion = -1;
        this.fVersion = "";
    }

    public void setVersion(String pVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMajorVersion = -2;
        this.fVersion = pVersion != null ? pVersion : "";
    }

    public void setVersion(int pMajorVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMajorVersion = pMajorVersion > 0 ? pMajorVersion : 0;
        this.fMediumVersion = -1;
        this.fMinorVersion = -1;
        this.fVersion = null;
    }

    public void setVersion(int pMajorVersion, int pMediumVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMajorVersion = pMajorVersion > 0 ? pMajorVersion : 0;
        this.fMediumVersion = pMediumVersion > 0 ? pMediumVersion : 0;
        this.fMinorVersion = -1;
        this.fVersion = null;
    }

    public void setVersion(int pMajorVersion, int pMediumVersion, int pMinorVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMajorVersion = pMajorVersion > 0 ? pMajorVersion : 0;
        this.fMediumVersion = pMediumVersion > 0 ? pMediumVersion : 0;
        this.fMinorVersion = pMinorVersion > 0 ? pMinorVersion : 0;
        this.fVersion = null;
    }

    public ScVersion setZeroToUndefinedNumbers() {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        if (this.getMajorVersion() == -1) {
            this.fMajorVersion = 0;
            this.fMediumVersion = 0;
            this.fMinorVersion = 0;
            this.fVersion = null;
        } else if (this.getMediumVersion() == -1) {
            this.fMediumVersion = 0;
            this.fMinorVersion = 0;
            this.fVersion = null;
        } else if (this.getMinorVersion() == -1) {
            this.fMinorVersion = 0;
            this.fVersion = null;
        }
        return this;
    }

    public boolean isLocked() {
        return this.fLocked;
    }

    public ScVersion lock() {
        this.fLocked = true;
        return this;
    }

    public int compareTo(Object pVersion) {
        if (pVersion == null) {
            return 1;
        }
        ScVersion vOther = (ScVersion)pVersion;
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        if (vOther.fMajorVersion == -2) {
            vOther.parseVersion();
        }
        if (this == pVersion) {
            return 0;
        }
        if (this.fMajorVersion == -1 && vOther.fMajorVersion >= 0) {
            return 1;
        }
        if (this.fMajorVersion >= 0 && vOther.fMajorVersion == -1) {
            return -1;
        }
        if (this.fMajorVersion > vOther.fMajorVersion) {
            return 1;
        }
        if (this.fMajorVersion < vOther.fMajorVersion) {
            return -1;
        }
        if (this.fMediumVersion == -1 && vOther.fMediumVersion >= 0) {
            return 1;
        }
        if (this.fMediumVersion >= 0 && vOther.fMediumVersion == -1) {
            return -1;
        }
        if (this.fMediumVersion > vOther.fMediumVersion) {
            return 1;
        }
        if (this.fMediumVersion < vOther.fMediumVersion) {
            return -1;
        }
        if (this.fMinorVersion == -1 && vOther.fMinorVersion >= 0) {
            return 1;
        }
        if (this.fMinorVersion >= 0 && vOther.fMinorVersion == -1) {
            return -1;
        }
        if (this.fMinorVersion > vOther.fMinorVersion) {
            return 1;
        }
        if (this.fMinorVersion < vOther.fMinorVersion) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object pVersion) {
        if (pVersion == null) {
            return false;
        }
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        ScVersion vOther = (ScVersion)pVersion;
        if (vOther.fMajorVersion == -2) {
            vOther.parseVersion();
        }
        return this.fMajorVersion == vOther.fMajorVersion && this.fMediumVersion == vOther.fMediumVersion && this.fMinorVersion == vOther.fMinorVersion;
    }

    public boolean isUndefined() {
        return this.getMajorVersion() == -1;
    }

    public boolean isPartiallyUndefined() {
        return this.getMinorVersion() == -1;
    }

    public boolean isPrefixOf(ScVersion pVersion) {
        if (pVersion == null) {
            return false;
        }
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        if (pVersion.fMajorVersion == -2) {
            pVersion.parseVersion();
        }
        if (this.fMajorVersion == -1) {
            return true;
        }
        if (this.fMajorVersion != pVersion.fMajorVersion) {
            return false;
        }
        if (this.fMediumVersion == -1) {
            return true;
        }
        if (this.fMediumVersion != pVersion.fMediumVersion) {
            return false;
        }
        if (this.fMediumVersion == -1) {
            return true;
        }
        if (this.fMediumVersion != pVersion.fMediumVersion) {
            return false;
        }
        if (this.fMinorVersion == -1) {
            return true;
        }
        return this.fMinorVersion == pVersion.fMinorVersion;
    }

    public boolean isContainedIn(ScVersion pMaxVersion, ScVersion pMinVersion) {
        if (pMaxVersion == pMinVersion) {
            if (pMaxVersion == null) {
                return true;
            }
            return pMaxVersion.isPrefixOf(this);
        }
        if (pMaxVersion != null && pMaxVersion.compareTo(this) < 0) {
            return false;
        }
        if (pMinVersion != null) {
            if (pMinVersion.isPrefixOf(this)) {
                return true;
            }
            return pMinVersion.compareTo(this) <= 0;
        }
        return true;
    }

    public int getMajorVersion() {
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        return this.fMajorVersion;
    }

    public void setMajorVersion(int pMajorVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMajorVersion = pMajorVersion;
        this.fVersion = null;
    }

    public int getMediumVersion() {
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        return this.fMediumVersion;
    }

    public void setMediumVersion(int pMediumVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMediumVersion = pMediumVersion;
        if (this.fMajorVersion == -1 || this.fMajorVersion == -2) {
            this.fMajorVersion = 0;
        }
        this.fVersion = null;
    }

    public int getMinorVersion() {
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        return this.fMinorVersion;
    }

    public void setMinorVersion(int pMinorVersion) {
        if (this.fLocked) {
            throw new UnsupportedOperationException("This UpdtVersion is Locked.");
        }
        this.fMinorVersion = pMinorVersion;
        if (this.fMajorVersion == -1 || this.fMajorVersion == -2) {
            this.fMajorVersion = 0;
        }
        if (this.fMediumVersion == -1) {
            this.fMediumVersion = 0;
        }
        this.fVersion = null;
    }

    protected void parseVersion() {
        this.fMajorVersion = -1;
        this.fMediumVersion = -1;
        this.fMinorVersion = -1;
        if (this.fVersion == null || this.fVersion.length() == 0) {
            this.fVersion = "";
            return;
        }
        int vIdx = this.fVersion.indexOf(46);
        if (vIdx < 0) {
            try {
                this.fMajorVersion = Integer.parseInt(this.fVersion);
            }
            catch (NumberFormatException e) {
                this.fVersion = null;
            }
        } else {
            try {
                this.fMajorVersion = Integer.parseInt(this.fVersion.substring(0, vIdx));
            }
            catch (NumberFormatException e) {
                this.fVersion = null;
            }
            int vIdx2 = this.fVersion.indexOf(46, ++vIdx);
            if (vIdx2 < 0) {
                try {
                    this.fMediumVersion = Integer.parseInt(this.fVersion.substring(vIdx));
                }
                catch (NumberFormatException e) {
                    this.fVersion = null;
                }
            } else {
                try {
                    this.fMediumVersion = Integer.parseInt(this.fVersion.substring(vIdx, vIdx2));
                }
                catch (NumberFormatException e) {
                    this.fVersion = null;
                }
                try {
                    this.fMinorVersion = Integer.parseInt(this.fVersion.substring(vIdx2 + 1));
                }
                catch (NumberFormatException e) {
                    this.fVersion = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.fVersion == null) {
            StringBuffer vBuff = new StringBuffer(8);
            if (this.fMajorVersion != -1) {
                vBuff.append(this.fMajorVersion);
                if (this.fMediumVersion != -1) {
                    vBuff.append('.');
                    vBuff.append(this.fMediumVersion);
                    if (this.fMinorVersion != -1) {
                        vBuff.append('.');
                        DecimalFormat decimalFormat = MINOR_FORMATTER;
                        synchronized (decimalFormat) {
                            MINOR_FORMATTER.format((long)this.fMinorVersion, vBuff, FORMATTER_FIELDPOS);
                        }
                    }
                }
            }
            this.fVersion = vBuff.toString();
        }
        return this.fVersion;
    }

    public String toLocalPath(String pPrefix, String pSuffix) {
        if (this.fMajorVersion == -2) {
            this.parseVersion();
        }
        StringBuffer vBuff = new StringBuffer((pPrefix != null ? pPrefix.length() : 0) + 8 + (pSuffix != null ? pSuffix.length() : 0));
        if (pPrefix != null) {
            vBuff.append(pPrefix);
            vBuff.append('/');
        }
        if (this.fMajorVersion != -1) {
            vBuff.append(this.fMajorVersion);
        }
        if (this.fMediumVersion != -1) {
            vBuff.append('/');
            vBuff.append(this.fMediumVersion);
        }
        if (this.fMinorVersion != -1) {
            vBuff.append('/');
            vBuff.append(this.fMinorVersion);
        }
        if (pSuffix != null) {
            vBuff.append('/');
            vBuff.append(pSuffix);
        }
        return vBuff.toString();
    }

    public ScVersion restrictForMax(ScVersion pVers) {
        return this.compareTo(pVers) > 0 ? pVers : this;
    }

    public ScVersion restrictForMin(ScVersion pVers) {
        if (pVers.isPrefixOf(this)) {
            return this;
        }
        return this.compareTo(pVers) < 0 ? pVers : this;
    }

    public ScVersion getNextVersion() {
        ScVersion vResult = new ScVersion();
        vResult.setVersion(Math.max(this.getMajorVersion(), 0), Math.max(this.getMediumVersion(), 0), Math.max(this.getMinorVersion() + 1, 1));
        return vResult;
    }

    public ScVersion getPreviousVersion() {
        ScVersion vResult = new ScVersion();
        if (this.getMajorVersion() == -1) {
            return vResult;
        }
        if (this.getMediumVersion() == -1) {
            vResult.setVersion(this.getMajorVersion() - 1);
            return vResult;
        }
        if (this.getMinorVersion() == -1) {
            vResult.setVersion(this.getMajorVersion(), this.getMediumVersion() - 1);
            return vResult;
        }
        if (this.getMinorVersion() == 0) {
            if (this.getMediumVersion() == 0) {
                if (this.getMajorVersion() == 0) {
                    return vResult;
                }
                vResult.setVersion(this.getMajorVersion() - 1, -1, -1);
                return vResult;
            }
            vResult.setVersion(this.getMajorVersion(), this.getMediumVersion() - 1, -1);
            return vResult;
        }
        vResult.setVersion(this.getMajorVersion(), this.getMediumVersion(), this.getMinorVersion() - 1);
        return vResult;
    }
}

