/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.log;

public class Chrono {
    protected int[] fMeasures = new int[3];
    protected int fCountMeasure = 0;
    protected long fBeginTime = 0L;
    protected int fCountErrors = 0;

    public Chrono begin() {
        if (this.fBeginTime != 0L) {
            ++this.fCountErrors;
        }
        this.fBeginTime = System.currentTimeMillis();
        return this;
    }

    public Chrono end() {
        if (this.fBeginTime != 0L) {
            int vEnd = (int)(System.currentTimeMillis() - this.fBeginTime);
            if (this.fCountMeasure >= this.fMeasures.length) {
                int[] vChronos = new int[this.fCountMeasure + 99];
                System.arraycopy(this.fMeasures, 0, vChronos, 0, this.fMeasures.length);
                this.fMeasures = vChronos;
            }
            this.fMeasures[this.fCountMeasure++] = vEnd;
        } else {
            ++this.fCountErrors;
        }
        this.fBeginTime = 0L;
        return this;
    }

    public Chrono abort() {
        this.fBeginTime = 0L;
        return this;
    }

    public ChronoResult computeResults() {
        ChronoResult vResult = new ChronoResult();
        vResult.fCountErrors = this.fCountErrors;
        vResult.fCountMeasure = this.fCountMeasure;
        if (this.fCountMeasure > 0) {
            int i;
            vResult.fMin = Integer.MAX_VALUE;
            for (i = 0; i < this.fCountMeasure; ++i) {
                if (this.fMeasures[i] < vResult.fMin) {
                    vResult.fMin = this.fMeasures[i];
                }
                if (this.fMeasures[i] > vResult.fMax) {
                    vResult.fMax = this.fMeasures[i];
                }
                vResult.fAverage += (double)this.fMeasures[i];
            }
            vResult.fAverage /= (double)this.fCountMeasure;
            for (i = 0; i < this.fCountMeasure; ++i) {
                vResult.fStdDeviation += ((double)this.fMeasures[i] - vResult.fAverage) * ((double)this.fMeasures[i] - vResult.fAverage);
            }
            vResult.fStdDeviation = Math.sqrt(vResult.fStdDeviation) / (double)this.fCountMeasure;
        }
        return vResult;
    }

    public Chrono reset() {
        this.fCountMeasure = 0;
        this.fCountErrors = 0;
        return this;
    }

    public static class ChronoResult {
        protected int fMin = 0;
        protected int fMax = 0;
        protected double fAverage = 0.0;
        protected double fStdDeviation = 0.0;
        protected int fCountMeasure = 0;
        protected int fCountErrors = 0;

        public int getMin() {
            return this.fMin;
        }

        public int getMax() {
            return this.fMax;
        }

        public double getAverage() {
            return this.fAverage;
        }

        public double getStdDeviation() {
            return this.fStdDeviation;
        }

        public int getCountMeasure() {
            return this.fCountMeasure;
        }

        public int getCountErrors() {
            return this.fCountErrors;
        }

        public String toString() {
            if (this.fCountMeasure > 1) {
                return Math.round(this.getAverage()) + "ms on " + this.fCountMeasure + " measures (" + this.getMin() + ", " + this.getMax() + ", " + Math.round(this.getStdDeviation()) + ").";
            }
            if (this.fCountMeasure == 1) {
                return Math.round(this.getAverage()) + " on 1 measure.";
            }
            return "No measure.";
        }
    }
}

