/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.log;

import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.ILogMsgHandlerAsObject;
import eu.scenari.fw.log.ILogMsgHandlerAsString;
import eu.scenari.fw.log.LogMsg;
import eu.scenari.fw.util.lang.TunneledException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class LogMgr {
    protected static Map<Throwable, ILogMsg> sExceptions = new HashMap<Throwable, ILogMsg>();
    protected static LogDispatcher sDefaultLogDispatcher = new LogDispatcher();
    protected static InheritableThreadLocal<LogDispatcher> sThreadLogDispatcher = new InheritableThreadLocal();

    public static Throwable addMessage(Throwable pException, ILogMsg pLogMsg) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        LogMgr.xPush(pException, pLogMsg, false);
        return pException;
    }

    public static Throwable addMessage(Throwable pException, String pDescription, String ... pVariables) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        LogMsg vLogMsg = new LogMsg(pDescription, pVariables);
        LogMgr.xPush(pException, vLogMsg, true);
        return pException;
    }

    public static Throwable addMessage(Throwable pException, String pDescription, ILogMsg.LogType pType, String ... pVariables) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        LogMsg vLogMsg = new LogMsg(pDescription, pType, pVariables);
        LogMgr.xPush(pException, vLogMsg, true);
        return pException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogMsg getMessage(Throwable pException) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        ILogMsg vLogMsg = null;
        Map<Throwable, ILogMsg> map = sExceptions;
        synchronized (map) {
            vLogMsg = sExceptions.remove(pException);
            if (vLogMsg == null) {
                vLogMsg = new LogMsg(pException);
            }
        }
        return vLogMsg;
    }

    public static Exception newException(ILogMsg pMessage) {
        Exception vExc = new Exception();
        LogMgr.addMessage(vExc, pMessage);
        return vExc;
    }

    public static Exception newException(String pDescription, String ... pVariables) {
        Exception vExc = new Exception();
        LogMgr.addMessage((Throwable)vExc, pDescription, pVariables);
        return vExc;
    }

    public static Exception newException(String pDescription, ILogMsg.LogType pType, String ... pVariables) {
        Exception vExc = new Exception();
        LogMgr.addMessage((Throwable)vExc, pDescription, pType, pVariables);
        return vExc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeException(Throwable pException) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        Map<Throwable, ILogMsg> map = sExceptions;
        synchronized (map) {
            sExceptions.remove(pException);
        }
    }

    public static void publishException(String pDescription, String ... pVariables) {
        LogMgr.publishException(LogMgr.newException(pDescription, pVariables));
    }

    public static void publishException(String pDescription, ILogMsg.LogType pType, String ... pVariables) {
        LogMgr.publishException(LogMgr.newException(pDescription, pType, pVariables));
    }

    public static void publishException(Throwable pException) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        ILogMsg vLogMsg = LogMgr.getMessage(pException);
        LogMgr.xPublish(vLogMsg);
    }

    public static void publishException(Throwable pException, String pDescription, String ... pVariables) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        LogMgr.addMessage(pException, pDescription, pVariables);
        LogMgr.publishException(pException);
    }

    public static void publishException(Throwable pException, String pDescription, ILogMsg.LogType pType, String ... pVariables) {
        while (pException.getClass() == TunneledException.class) {
            pException = pException.getCause();
        }
        LogMgr.addMessage(pException, pDescription, pType, pVariables);
        LogMgr.publishException(pException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishExceptionsAll() {
        Map<Throwable, ILogMsg> map = sExceptions;
        synchronized (map) {
            for (ILogMsg vMsg : sExceptions.values()) {
                LogMgr.xPublish(vMsg);
            }
        }
    }

    public static void publishMessage(ILogMsg pMessage) {
        if (pMessage != null) {
            LogMgr.xPublish(pMessage);
        }
    }

    public static void publishTrace(String pDescription, String ... pVariables) {
        LogMsg vMess = new LogMsg(pDescription, ILogMsg.LogType.Info, pVariables);
        LogMgr.xPublish(vMess);
    }

    public static void publishTrace(String pDescription, ILogMsg.LogType pType, String ... pVariables) {
        LogMsg vMess = new LogMsg(pDescription, pType, pVariables);
        LogMgr.xPublish(vMess);
    }

    public static void subscribeAsObject(ILogMsgHandlerAsObject pHandler, boolean pCurrentThreadOnly) {
        if (pCurrentThreadOnly) {
            LogMgr.xGetOrCreateCurrentThreadLogDisp().subscribeAsObject(pHandler);
        } else {
            sDefaultLogDispatcher.subscribeAsObject(pHandler);
        }
    }

    public static void subscribeAsObject(ObjectOutputStream pStream, boolean pCurrentThreadOnly) {
        if (pCurrentThreadOnly) {
            LogMgr.xGetOrCreateCurrentThreadLogDisp().subscribeAsObject(pStream);
        } else {
            sDefaultLogDispatcher.subscribeAsObject(pStream);
        }
    }

    public static void subscribeAsString(ILogMsgHandlerAsString pHandler, boolean pCurrentThreadOnly) {
        if (pCurrentThreadOnly) {
            LogMgr.xGetOrCreateCurrentThreadLogDisp().subscribeAsString(pHandler);
        } else {
            sDefaultLogDispatcher.subscribeAsString(pHandler);
        }
    }

    public static void subscribeAsString(PrintStream pStream, boolean pCurrentThreadOnly) {
        if (pCurrentThreadOnly) {
            LogMgr.xGetOrCreateCurrentThreadLogDisp().subscribeAsString(pStream);
        } else {
            sDefaultLogDispatcher.subscribeAsString(pStream);
        }
    }

    public static void subscribeAsString(PrintWriter pStream, boolean pCurrentThreadOnly) {
        if (pCurrentThreadOnly) {
            LogMgr.xGetOrCreateCurrentThreadLogDisp().subscribeAsString(pStream);
        } else {
            sDefaultLogDispatcher.subscribeAsString(pStream);
        }
    }

    public static boolean unsubscribeAsObject(ILogMsgHandlerAsObject pHandler, boolean pCurrentThreadOnly) {
        boolean vResult = false;
        if (pCurrentThreadOnly) {
            LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
            if (vDisp != null) {
                vResult = vDisp.unsubscribeAsObject(pHandler);
                if (vDisp.isDispatcherEmpty()) {
                    sThreadLogDispatcher.set(null);
                }
            }
        } else {
            vResult = sDefaultLogDispatcher.unsubscribeAsObject(pHandler);
        }
        return vResult;
    }

    public static boolean unsubscribeAsObject(ObjectOutputStream pStream, boolean pCurrentThreadOnly) {
        boolean vResult = false;
        if (pCurrentThreadOnly) {
            LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
            if (vDisp != null) {
                vResult = vDisp.unsubscribeAsObject(pStream);
                if (vDisp.isDispatcherEmpty()) {
                    sThreadLogDispatcher.set(null);
                }
            }
        } else {
            vResult = sDefaultLogDispatcher.unsubscribeAsObject(pStream);
        }
        return vResult;
    }

    public static boolean unsubscribeAsString(ILogMsgHandlerAsString pHandler, boolean pCurrentThreadOnly) {
        boolean vResult = false;
        if (pCurrentThreadOnly) {
            LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
            if (vDisp != null) {
                vResult = vDisp.unsubscribeAsString(pHandler);
                if (vDisp.isDispatcherEmpty()) {
                    sThreadLogDispatcher.set(null);
                }
            }
        } else {
            vResult = sDefaultLogDispatcher.unsubscribeAsString(pHandler);
        }
        return vResult;
    }

    public static boolean unsubscribeAsString(PrintStream pStream, boolean pCurrentThreadOnly) {
        boolean vResult = false;
        if (pCurrentThreadOnly) {
            LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
            if (vDisp != null) {
                vResult = vDisp.unsubscribeAsString(pStream);
                if (vDisp.isDispatcherEmpty()) {
                    sThreadLogDispatcher.set(null);
                }
            }
        } else {
            vResult = sDefaultLogDispatcher.unsubscribeAsString(pStream);
        }
        return vResult;
    }

    public static boolean unsubscribeAsString(PrintWriter pStream, boolean pCurrentThreadOnly) {
        boolean vResult = false;
        if (pCurrentThreadOnly) {
            LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
            if (vDisp != null) {
                vResult = vDisp.unsubscribeAsString(pStream);
                if (vDisp.isDispatcherEmpty()) {
                    sThreadLogDispatcher.set(null);
                }
            }
        } else {
            vResult = sDefaultLogDispatcher.unsubscribeAsString(pStream);
        }
        return vResult;
    }

    protected static void xPublish(ILogMsg pLogMsg) {
        sDefaultLogDispatcher.publishMessage(pLogMsg);
        LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
        if (vDisp != null) {
            vDisp.publishMessage(pLogMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void xPush(Throwable pException, ILogMsg pLogMsg, boolean pAddExceptionMessage) {
        Map<Throwable, ILogMsg> map = sExceptions;
        synchronized (map) {
            ILogMsg vLogMsg = sExceptions.get(pException);
            if (vLogMsg != null) {
                pLogMsg.getFirstAncestorMsg().setParentMsg(vLogMsg);
            } else if (pAddExceptionMessage) {
                pLogMsg.getFirstAncestorMsg().setParentMsg(new LogMsg(pException));
            }
            if (sExceptions.size() > 100) {
                try {
                    LogMgr.publishMessage(new LogMsg("Too many exceptions tracked by LogMgr. Alls exceptions tracked will be published and removed.", ILogMsg.LogType.Error, new String[0]));
                    for (ILogMsg vMsg : sExceptions.values()) {
                        LogMgr.xPublish(vMsg);
                    }
                    sExceptions.clear();
                }
                catch (Exception e) {
                    sExceptions.clear();
                    LogMgr.publishException((Throwable)e, "Publishing all tracked exception failed.", new String[0]);
                }
            }
            sExceptions.put(pException, pLogMsg);
        }
    }

    protected static LogDispatcher xGetOrCreateCurrentThreadLogDisp() {
        LogDispatcher vDisp = (LogDispatcher)sThreadLogDispatcher.get();
        if (vDisp == null) {
            vDisp = new LogDispatcher();
            sThreadLogDispatcher.set(vDisp);
        }
        return vDisp;
    }

    protected static class LogDispatcher {
        protected List<Object> fSubscribersAsObject = new ArrayList<Object>();
        protected List<Object> fSubscribersAsString = new ArrayList<Object>();

        protected LogDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeAsObject(ILogMsgHandlerAsObject pHandler) {
            List<Object> list = this.fSubscribersAsObject;
            synchronized (list) {
                if (!this.fSubscribersAsObject.contains(pHandler)) {
                    this.fSubscribersAsObject.add(pHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeAsObject(ObjectOutputStream pStream) {
            List<Object> list = this.fSubscribersAsObject;
            synchronized (list) {
                if (!this.fSubscribersAsObject.contains(pStream)) {
                    this.fSubscribersAsObject.add(pStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeAsString(ILogMsgHandlerAsString pHandler) {
            List<Object> list = this.fSubscribersAsString;
            synchronized (list) {
                if (!this.fSubscribersAsString.contains(pHandler)) {
                    this.fSubscribersAsString.add(pHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeAsString(PrintStream pStream) {
            List<Object> list = this.fSubscribersAsString;
            synchronized (list) {
                if (!this.fSubscribersAsString.contains(pStream)) {
                    this.fSubscribersAsString.add(pStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeAsString(PrintWriter pStream) {
            List<Object> list = this.fSubscribersAsString;
            synchronized (list) {
                if (!this.fSubscribersAsString.contains(pStream)) {
                    this.fSubscribersAsString.add(pStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unsubscribeAsObject(ILogMsgHandlerAsObject pHandler) {
            List<Object> list = this.fSubscribersAsObject;
            synchronized (list) {
                return this.fSubscribersAsObject.remove(pHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unsubscribeAsObject(ObjectOutputStream pStream) {
            List<Object> list = this.fSubscribersAsObject;
            synchronized (list) {
                return this.fSubscribersAsObject.remove(pStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unsubscribeAsString(ILogMsgHandlerAsString pHandler) {
            List<Object> list = this.fSubscribersAsString;
            synchronized (list) {
                return this.fSubscribersAsString.remove(pHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unsubscribeAsString(PrintStream pStream) {
            List<Object> list = this.fSubscribersAsString;
            synchronized (list) {
                return this.fSubscribersAsString.remove(pStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unsubscribeAsString(PrintWriter pStream) {
            List<Object> list = this.fSubscribersAsString;
            synchronized (list) {
                return this.fSubscribersAsString.remove(pStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publishMessage(ILogMsg pLogMsg) {
            List<Object> list = this.fSubscribersAsObject;
            synchronized (list) {
                for (Object vSubscriber : this.fSubscribersAsObject) {
                    if (vSubscriber instanceof ObjectOutputStream) {
                        try {
                            ((ObjectOutputStream)vSubscriber).writeObject(pLogMsg);
                        }
                        catch (IOException e) {}
                        continue;
                    }
                    if (!(vSubscriber instanceof ILogMsgHandlerAsObject)) continue;
                    ((ILogMsgHandlerAsObject)vSubscriber).handleLogMsgAsObject(pLogMsg);
                }
            }
            list = this.fSubscribersAsString;
            synchronized (list) {
                if (this.fSubscribersAsString.size() > 0) {
                    String vMessage = pLogMsg.readAsTextFormat(true);
                    for (Object vSubscriber : this.fSubscribersAsString) {
                        if (vSubscriber instanceof PrintStream) {
                            PrintStream vPrintStream = (PrintStream)vSubscriber;
                            vPrintStream.print(vMessage);
                            vPrintStream.flush();
                            if (!vPrintStream.checkError()) continue;
                            this.unsubscribeAsString(vPrintStream);
                            continue;
                        }
                        if (vSubscriber instanceof PrintWriter) {
                            PrintWriter vPrintWriter = (PrintWriter)vSubscriber;
                            vPrintWriter.println(vMessage);
                            vPrintWriter.flush();
                            if (!vPrintWriter.checkError()) continue;
                            this.unsubscribeAsString(vPrintWriter);
                            continue;
                        }
                        if (!(vSubscriber instanceof ILogMsgHandlerAsString)) continue;
                        ((ILogMsgHandlerAsString)vSubscriber).handleLogMsgAsString(vMessage);
                    }
                }
            }
        }

        public boolean isDispatcherEmpty() {
            return this.fSubscribersAsObject.size() == 0 && this.fSubscribersAsString.size() == 0;
        }
    }
}

