/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.log;

import com.scenari.serializer.simple.IXmlWriter;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.syntax.json.JsonSerializer;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Formatter;

public class LogMsg
implements ILogMsg {
    protected static String sLineSeparator = System.getProperty("line.separator");
    protected static final String[] NAME_VARS = new String[]{"var1", "var2", "var3", "var4", "var5", "var6", "var7", "var8"};
    protected ILogMsg.LogType fMsgType = null;
    protected ILogMsg fParentMsg = null;
    protected String fDescription = null;
    protected String[] fVariables = null;
    protected String fDetails = null;
    protected String fThreadName = null;
    protected Date fTimeStamp = null;

    public LogMsg(String pText, String ... pVariables) {
        this(pText, ILogMsg.LogType.Error, pVariables);
    }

    public LogMsg(String pText, ILogMsg.LogType pType, String ... pVariables) {
        this.xInit();
        this.fDescription = pText;
        ILogMsg.LogType logType = this.fMsgType = pType == null ? ILogMsg.LogType.Error : pType;
        if (pVariables != null && pVariables.length > 0) {
            this.fVariables = pVariables;
        }
    }

    public LogMsg(Throwable pException) {
        this(pException.getMessage(), ILogMsg.LogType.Exception, new String[0]);
        this.setDetails(this.xReadStackTrace(pException));
    }

    public ILogMsg getFirstAncestorMsg() {
        ILogMsg vResultat = this;
        if (this.fParentMsg != null) {
            vResultat = this.fParentMsg.getFirstAncestorMsg();
        }
        return vResultat;
    }

    public ILogMsg.LogType getMsgType() {
        return this.fMsgType;
    }

    public ILogMsg getParentMsg() {
        return this.fParentMsg;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getDetails() {
        return this.fDetails;
    }

    public String[] getVariables() {
        return this.fVariables;
    }

    public String getThreadName() {
        return this.fThreadName;
    }

    public Date getTimeStamp() {
        return this.fTimeStamp;
    }

    public void setParentMsg(ILogMsg pParent) {
        this.fParentMsg = pParent;
    }

    public void setDescription(String pText) {
        this.fDescription = pText;
    }

    public void setDetails(String pDetails) {
        this.fDetails = pDetails;
    }

    public void setVariables(String[] pVariables) {
        this.fVariables = pVariables;
    }

    public String readAsTextFormat(boolean pWithAncestors) {
        StringBuilder vResult = new StringBuilder(256);
        this.writeAsTextFormat(vResult, pWithAncestors);
        return vResult.toString();
    }

    public void writeAsTextFormat(StringBuilder pBuf, boolean pWithAncestors) {
        if (pWithAncestors) {
            int vHierarchie = 0;
            for (ILogMsg vLogMsg = this; vLogMsg != null; vLogMsg = vLogMsg.getParentMsg()) {
                pBuf.append(++vHierarchie);
                vLogMsg.writeAsTextFormat(pBuf, false);
                pBuf.append(sLineSeparator);
            }
        } else {
            pBuf.append("--- ");
            if (this.fMsgType != null) {
                pBuf.append((Object)this.fMsgType);
                pBuf.append(" : ");
            }
            pBuf.append(this.fTimeStamp.toString());
            pBuf.append(" (");
            pBuf.append(this.fThreadName);
            pBuf.append(") ---");
            pBuf.append(sLineSeparator);
            if (this.fDescription != null) {
                if (this.fVariables != null) {
                    try {
                        new Formatter(pBuf).format(this.fDescription, this.fVariables);
                    }
                    catch (Exception e) {
                        LogMgr.publishException((Throwable)e, "Malformed message description : %s", this.fDescription);
                    }
                } else {
                    pBuf.append(this.fDescription);
                }
                pBuf.append(sLineSeparator);
            }
            if (this.fDetails != null) {
                pBuf.append(this.fDetails);
                pBuf.append(sLineSeparator);
            }
        }
    }

    public void writeAsXmlFormat(IXmlWriter pWriter, boolean pWithAncestors) throws Exception {
        pWriter.writeStartTag("message");
        pWriter.writeAttribute("type", this.fMsgType.name());
        pWriter.writeAttribute("thread", this.fThreadName);
        pWriter.writeAttribute("ts", Long.toString(this.fTimeStamp.getTime()));
        if (this.fDescription != null) {
            pWriter.writeAttribute("desc", this.fDescription);
            if (this.fVariables != null) {
                int i;
                int vLen = Math.min(NAME_VARS.length, this.fVariables.length);
                for (i = 0; i < vLen; ++i) {
                    pWriter.writeAttribute(NAME_VARS[i], this.fVariables[i]);
                }
                for (i = NAME_VARS.length; i < this.fVariables.length; ++i) {
                    pWriter.writeAttribute("var".concat(Integer.toString(i + 1)), this.fVariables[i]);
                }
            }
        }
        if (pWithAncestors && this.fParentMsg != null) {
            pWriter.writeEndOpenTag();
            if (this.fDetails != null) {
                pWriter.writeOpenTag("details");
                pWriter.writeText(this.fDetails);
                pWriter.writeCloseTag("details");
            }
            this.fParentMsg.writeAsXmlFormat(pWriter, true);
            pWriter.writeCloseTag("message");
        } else if (this.fDetails != null) {
            pWriter.writeEndOpenTag();
            pWriter.writeOpenTag("details");
            pWriter.writeText(this.fDetails);
            pWriter.writeCloseTag("details");
            pWriter.writeCloseTag("message");
        } else {
            pWriter.writeEndEmptyTag();
        }
    }

    public void writeJson(JsonSerializer pJson) throws Exception {
        pJson.startObject();
        pJson.key("type").valString(this.fMsgType.name());
        pJson.key("thread").valString(this.fThreadName);
        pJson.key("ts").valNumber(this.fTimeStamp.getTime());
        if (this.fDescription != null) {
            pJson.key("desc").valString(this.fDescription);
        }
        if (this.fDetails != null) {
            pJson.key("details").valString(this.fDetails);
        }
        if (this.fVariables != null) {
            pJson.key("vars").startArray();
            for (int i = 0; i < this.fVariables.length; ++i) {
                pJson.valString(this.fVariables[i]);
            }
            pJson.endArray();
        }
        if (this.fParentMsg != null) {
            pJson.key("parent");
            this.fParentMsg.writeJson(pJson);
        }
        pJson.endObject();
    }

    protected void xInit() {
        this.fTimeStamp = new Date();
        this.fThreadName = Thread.currentThread().getName();
    }

    protected String xReadStackTrace(Throwable pThrowable) {
        CharArrayWriter vArray = new CharArrayWriter();
        try {
            PrintWriter vPrintWriter = new PrintWriter(vArray);
            pThrowable.printStackTrace(vPrintWriter);
            vPrintWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vArray.toString();
    }
}

