/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.log;

import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TracePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TraceMgr {
    protected static HashMap<String, TracePoint> sTraces = new HashMap();
    protected static InheritableThreadLocal<String> sThreadTrace = new InheritableThreadLocal();
    protected static boolean sThreadSelective = false;

    public static final TracePoint getTrace(String pCode) {
        return sTraces.get(pCode);
    }

    public static final List<TracePoint> listTraces() {
        return new ArrayList<TracePoint>(sTraces.values());
    }

    public static final boolean isCurrentThreadTracesEnabled() {
        return !sThreadSelective || sThreadTrace.get() != null;
    }

    public static final synchronized TracePoint register(String pCode) {
        return TraceMgr.register(pCode, null);
    }

    public static final synchronized TracePoint register(String pCode, String pDisplayName) {
        TracePoint vTrace = sTraces.get(pCode);
        if (vTrace == null) {
            vTrace = new TracePoint(pCode, pDisplayName);
            sTraces.put(pCode, vTrace);
        } else if (pDisplayName != null) {
            vTrace.setDisplayName(pDisplayName);
        }
        return vTrace;
    }

    public static final synchronized TracePoint register(String pCode, String pDisplayName, boolean pIsStaticActive) {
        TracePoint vTrace = TraceMgr.register(pCode, pDisplayName);
        vTrace.setStatus(pIsStaticActive);
        return vTrace;
    }

    public static final void enableTrace(String pCodeTrace, boolean pTrace) {
        try {
            TracePoint vTrace = TraceMgr.register(pCodeTrace);
            vTrace.setStatus(pTrace);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }

    public static final void setCurrentThreadTraces(boolean pTrace) {
        if (sThreadSelective) {
            sThreadTrace.set(pTrace ? "ThreadActiveTrace" : null);
        }
    }

    public static final boolean isThreadSelectiveMode() {
        return sThreadSelective;
    }

    public static final void setThreadSelectiveMode(boolean pMode) {
        sThreadSelective = pMode;
    }
}

