/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.log;

import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;

public class TracePoint
implements Comparable {
    protected String fCode = null;
    protected String fDisplayName = null;
    protected boolean fStatus = false;

    TracePoint(String pCode, String pDisplayName) {
        this.fCode = pCode;
        this.fDisplayName = pDisplayName == null ? pCode : pDisplayName;
    }

    public String getCode() {
        return this.fCode;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public boolean getStatus() {
        return this.fStatus;
    }

    public boolean isEnabled() {
        return this.fStatus && TraceMgr.isCurrentThreadTracesEnabled();
    }

    public void publishDebug(String pText, String ... pVariables) {
        LogMgr.publishTrace(pText, ILogMsg.LogType.Info, pVariables);
    }

    public void publishError(String pText, String ... pVariables) {
        LogMgr.publishTrace(pText, ILogMsg.LogType.Error, pVariables);
    }

    public void publishFatalError(String pText, String ... pVariables) {
        LogMgr.publishTrace(pText, ILogMsg.LogType.FatalError, pVariables);
    }

    public void publishWarning(String pText, String ... pVariables) {
        LogMgr.publishTrace(pText, ILogMsg.LogType.Warning, pVariables);
    }

    public void setDisplayName(String newDisplayName) {
        this.fDisplayName = newDisplayName;
    }

    public void setStatus(boolean pActive) {
        this.fStatus = pActive;
    }

    public int compareTo(Object pObject) {
        return this.fCode.compareTo(((TracePoint)pObject).fCode);
    }

    public boolean equals(Object pObject) {
        if (pObject == null || !(pObject instanceof TracePoint)) {
            return false;
        }
        return this.fCode.equals(((TracePoint)pObject).fCode);
    }
}

