/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.main;

import com.scenari.s.fw.properties.loaders.xml.HInitAppSaxHandler;
import eu.scenari.fw.initapp.SystemProps;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletBase
extends HttpServlet {
    public static final String PARAM_INIT_APP_URL = "InitApplicationURL";
    public static final String SYSTEMPROP_WEBINF_PATH = "scenari.webapp.WEB-INF.path";
    public static final String SYSTEMPROP_WEBINF_URL = "scenari.webapp.WEB-INF.url";
    public static TracePoint sTrace = TraceMgr.register(ServletBase.class.getName(), "Servlet request log");
    public static ArrayList sListInitApp = new ArrayList();
    protected ServletConfig fConfig = null;

    public static void setHeaderNoCache(HttpServletResponse pHttpResp) {
        pHttpResp.addHeader("Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
        pHttpResp.addHeader("Expires", "0");
        pHttpResp.addHeader("Pragma", "no-cache");
    }

    public void init(ServletConfig pConfig) throws ServletException {
        this.fConfig = pConfig;
        try {
            this.initAppIfFirstCall(this.getInitAppUrl());
        }
        catch (Throwable e) {
            LogMgr.subscribeAsString(System.out, false);
            LogMgr.publishException(e);
        }
    }

    public final void service(HttpServletRequest pRequest, HttpServletResponse pResponse) throws ServletException, IOException {
        try {
            this.xService(pRequest, pResponse);
            if (sTrace.isEnabled()) {
                sTrace.publishDebug(this.logServletRequest(pRequest), new String[0]);
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
            try {
                pResponse.setStatus(500);
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    public void reloadInitApp() throws Exception {
        String vParamInitApp = this.getInitAppUrl();
        try {
            this.initApp(vParamInitApp);
        }
        catch (Exception e) {
            LogMgr.addMessage((Throwable)e, "Reloading InitApplication '" + vParamInitApp + "' failed.", new String[0]);
            throw e;
        }
    }

    protected String getInitAppUrl() throws Exception {
        return this.fConfig.getInitParameter(PARAM_INIT_APP_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAppIfFirstCall(String pInitAppURL) {
        if (pInitAppURL == null) {
            return;
        }
        ArrayList arrayList = sListInitApp;
        synchronized (arrayList) {
            if (!sListInitApp.contains(pInitAppURL)) {
                try {
                    this.initApp(pInitAppURL);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Loading InitApplication from URL '" + pInitAppURL + "' failed.", new String[0]);
                }
                sListInitApp.add(pInitAppURL);
            }
        }
    }

    protected void initApp(String pParamInitApp) throws Exception {
        TraceMgr.setThreadSelectiveMode(false);
        LogMgr.subscribeAsString(System.out, false);
        if (pParamInitApp == null) {
            return;
        }
        String vUrl = pParamInitApp;
        Class vSaxHandlerClass = HInitAppSaxHandler.class;
        int vOffset = pParamInitApp.indexOf(63);
        if (vOffset >= 0) {
            vUrl = pParamInitApp.substring(0, vOffset);
            if ((vOffset = pParamInitApp.indexOf("SaxHandler=", vOffset)) >= 0) {
                String vClassName = pParamInitApp.substring(vOffset + 11);
                if ((vOffset = vClassName.indexOf(38)) >= 0) {
                    vClassName = vClassName.substring(0, vOffset);
                }
                vSaxHandlerClass = Class.forName(vClassName);
            }
        }
        File vWebInfRootFile = new File(this.fConfig.getServletContext().getRealPath("WEB-INF")).getCanonicalFile();
        URL vWebInfRootUrl = vWebInfRootFile.toURI().toURL();
        SystemProps.setLocalProperty(SYSTEMPROP_WEBINF_PATH, vWebInfRootFile.getPath());
        SystemProps.setLocalProperty(SYSTEMPROP_WEBINF_URL, vWebInfRootUrl.toExternalForm());
        URL vUrlInit = new URL(vWebInfRootUrl, vUrl);
        HInitAppSaxHandler vHandler = (HInitAppSaxHandler)vSaxHandlerClass.newInstance();
        vHandler.hSetSource(vUrlInit);
        vHandler.initApplication();
    }

    protected abstract void xService(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected String logServletRequest(HttpServletRequest pRequest) {
        StringBuilder vBuf = new StringBuilder(256);
        vBuf.append("Encoding : ");
        vBuf.append(pRequest.getCharacterEncoding());
        vBuf.append("\nLength : ");
        vBuf.append(pRequest.getContentLength());
        vBuf.append("\nType : ");
        vBuf.append(pRequest.getContentType());
        vBuf.append("\n\nParameters");
        Enumeration parameters = pRequest.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String[] values = pRequest.getParameterValues(paramName);
            vBuf.append("\n");
            vBuf.append(paramName);
            vBuf.append(" : ");
            for (int i = 0; i < values.length; ++i) {
                vBuf.append(values[i]);
                vBuf.append(", ");
            }
        }
        vBuf.append("\n\nProtocol : ");
        vBuf.append(pRequest.getProtocol());
        vBuf.append("\nAddress : ");
        vBuf.append(pRequest.getRemoteAddr());
        vBuf.append("\nHost : ");
        vBuf.append(pRequest.getRemoteHost());
        vBuf.append("\nScheme : ");
        vBuf.append(pRequest.getScheme());
        vBuf.append("\nServer Name : ");
        vBuf.append(pRequest.getServerName());
        vBuf.append("\nServer Port : ");
        vBuf.append(pRequest.getServerPort());
        vBuf.append("\n\nHTTP Header Info\n");
        vBuf.append("\nAuthentication Type : ");
        vBuf.append(pRequest.getAuthType());
        vBuf.append("\nHTTP Method : ");
        vBuf.append(pRequest.getMethod());
        vBuf.append("\nQuery string : ");
        vBuf.append(pRequest.getQueryString());
        Enumeration headers = pRequest.getHeaderNames();
        if (headers.hasMoreElements()) {
            vBuf.append("\n\nHeaders : ");
            while (headers.hasMoreElements()) {
                String headerName = (String)headers.nextElement();
                vBuf.append("\n");
                vBuf.append(headerName);
                vBuf.append(" : ");
                vBuf.append(pRequest.getHeader(headerName));
            }
        }
        return vBuf.toString();
    }
}

