/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.mem;

import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.mem.IMemoryOwner;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class MemoryMgr
extends Thread {
    public static TracePoint sTrace = TraceMgr.register(MemoryMgr.class.getName(), null, true);
    public static int sMaxBytesToRemoveByCycle = 20000000;
    public static int sMinBytesToRemoveByCycle = 1000000;
    public static int sThresholdFreeMemPriority1 = 50000000;
    public static int sThresholdFreeMemPriority10 = 1000000;
    public static int sMinTotalMem = 30000000;
    public static int sPercentBytesToRemoveByCycle = 5;
    protected static MemoryMgr sSingleton = new MemoryMgr();
    protected static IMemoryOwner[] sMemoryOwners = new IMemoryOwner[6];
    protected static int sNbMemoryOwners = 0;
    protected ReferenceQueue<Object> fQueue = new ReferenceQueue();
    protected SoftReference<Object> fRef = new SoftReference<Object>(new Object(), this.fQueue);

    public MemoryMgr() {
        super("ScenariMemoryMgr");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            try {
                this.fQueue.remove();
            }
            catch (Exception e) {
                continue;
            }
            try {
                long vTotalMem = Runtime.getRuntime().totalMemory();
                if (vTotalMem > (long)sMinTotalMem) {
                    long vMemObjective;
                    long vTs = sTrace.isEnabled() ? System.currentTimeMillis() : 0L;
                    int vPriority = 1;
                    long vObjective = vMemObjective = Math.min(Math.max((long)sMinBytesToRemoveByCycle, vTotalMem * (long)sPercentBytesToRemoveByCycle / 100L), (long)sMaxBytesToRemoveByCycle);
                    if (vMemObjective > 0L) {
                        int vMaxPriority = 10;
                        long vFreeMem = Runtime.getRuntime().freeMemory();
                        if (vFreeMem > (long)sThresholdFreeMemPriority1) {
                            vMaxPriority = 0;
                        } else if (vFreeMem <= (long)sThresholdFreeMemPriority10) {
                            vMaxPriority = 10;
                        } else {
                            vMaxPriority = 10 - Math.round((vFreeMem - (long)sThresholdFreeMemPriority10) * 9L / (long)(sThresholdFreeMemPriority1 - sThresholdFreeMemPriority10));
                            if (vMaxPriority < 1) {
                                vMaxPriority = 1;
                            }
                            if (vMaxPriority > 10) {
                                vMaxPriority = 10;
                            }
                        }
                        if (vMaxPriority > 0) {
                            do {
                                Class<MemoryMgr> clazz = MemoryMgr.class;
                                // MONITORENTER : eu.scenari.fw.mem.MemoryMgr.class
                                IMemoryOwner[] vOwners = (IMemoryOwner[])sMemoryOwners.clone();
                                // MONITOREXIT : clazz
                                for (IMemoryOwner vMem : vOwners) {
                                    if (vMem == null) continue;
                                    vObjective -= vMem.freeMemory(vPriority);
                                }
                            } while (vObjective > 0L && ++vPriority <= vMaxPriority);
                            if (vTs > 0L) {
                                vTs = System.currentTimeMillis() - vTs;
                                StringBuilder vBuf = new StringBuilder(255);
                                vBuf.append("Garbage memory");
                                vBuf.append("\nTarget : ");
                                vBuf.append(vMemObjective);
                                vBuf.append("\nRealized : ");
                                vBuf.append(vMemObjective - vObjective);
                                vBuf.append("\nPriority reached (1 to ");
                                vBuf.append(vMaxPriority);
                                vBuf.append(") : ");
                                vBuf.append(vPriority - 1);
                                vBuf.append("\nProcessing time (ms) : ");
                                vBuf.append(vTs);
                                sTrace.publishDebug(vBuf.toString(), new String[0]);
                            }
                        }
                    }
                }
                this.fRef = new SoftReference<Object>(new Object(), this.fQueue);
                continue;
            }
            catch (Throwable e) {
                LogMgr.publishException(e, "Echec lors d'une purge m\u00e9moire. ", new String[0]);
                continue;
            }
            break;
        }
    }

    public static synchronized void registerMemoryOwner(IMemoryOwner pMemOwner) {
        if (pMemOwner == null) {
            return;
        }
        for (int i = 0; i < sMemoryOwners.length; ++i) {
            if (sMemoryOwners[i] != null) continue;
            MemoryMgr.sMemoryOwners[i] = pMemOwner;
            ++sNbMemoryOwners;
            return;
        }
        IMemoryOwner[] vNew = new IMemoryOwner[sMemoryOwners.length * 2];
        System.arraycopy(sMemoryOwners, 0, vNew, 0, sMemoryOwners.length);
        vNew[MemoryMgr.sMemoryOwners.length] = pMemOwner;
        sMemoryOwners = vNew;
        ++sNbMemoryOwners;
    }

    public static synchronized void unregisterMemoryOwner(IMemoryOwner pMemOwner) {
        if (pMemOwner == null) {
            return;
        }
        for (int i = 0; i < sMemoryOwners.length; ++i) {
            if (sMemoryOwners[i] != pMemOwner) continue;
            MemoryMgr.sMemoryOwners[i] = null;
            --sNbMemoryOwners;
            return;
        }
    }
}

