/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.mime;

import java.util.ArrayList;

public class MimeMgr {
    protected static MimeMgr sDefaultMimeMgr = new MimeMgr().addDefaultEntries();
    protected ArrayList<String> fExt = new ArrayList();
    protected ArrayList<String> fMime = new ArrayList();

    public static MimeMgr getDefaultMimeMgr() {
        return sDefaultMimeMgr;
    }

    public static String extractCharsetFromContentType(String pContentType) {
        if (pContentType != null) {
            int vIdx = -1;
            vIdx = pContentType.indexOf("charset=");
            if (vIdx >= 0) {
                if (pContentType.regionMatches(true, vIdx += 8, "utf-8", 0, 5)) {
                    return "utf-8";
                }
                if (pContentType.regionMatches(true, vIdx, "iso-8859-1", 0, 10)) {
                    return "iso-8859-1";
                }
                if (pContentType.length() == vIdx) {
                    return null;
                }
                int vIdxEnd = pContentType.indexOf(" ", vIdx);
                if (vIdxEnd < 0) {
                    vIdxEnd = pContentType.indexOf(";", vIdx);
                }
                if (vIdxEnd < 0) {
                    return pContentType.substring(vIdx);
                }
                return pContentType.substring(vIdx, vIdxEnd);
            }
        }
        return null;
    }

    public static String extractMimeFromContentType(String pContentType) {
        if (pContentType != null) {
            int vIdx = -1;
            vIdx = pContentType.indexOf(";");
            if (vIdx >= 0) {
                return pContentType.substring(0, vIdx);
            }
        }
        return pContentType;
    }

    public static String extractLastExtFromUrl(String pUrl) {
        if (pUrl != null) {
            int vSlash;
            int vIdx;
            int vIdxQs = pUrl.indexOf(63);
            if (vIdxQs < 0) {
                vIdxQs = pUrl.length();
            }
            if ((vIdx = pUrl.lastIndexOf(46, vIdxQs)) >= 0 && (vSlash = pUrl.indexOf(47, vIdx + 1)) < 0) {
                return pUrl.substring(vIdx, vIdxQs);
            }
        }
        return null;
    }

    public static String extractLastExtFromUrlNoPoint(String pUrl) {
        if (pUrl != null) {
            int vSlash;
            int vIdx;
            int vIdxQs = pUrl.indexOf(63);
            if (vIdxQs < 0) {
                vIdxQs = pUrl.length();
            }
            if ((vIdx = pUrl.lastIndexOf(46, vIdxQs)) >= 0 && (vSlash = pUrl.indexOf(47, vIdx + 1)) < 0) {
                return pUrl.substring(vIdx + 1, vIdxQs);
            }
        }
        return null;
    }

    public static String buildContentType(String pMime, String pCharset) {
        if (pCharset == null || pCharset.length() == 0) {
            return pMime;
        }
        return pMime + "; charset=" + pCharset;
    }

    public String searchExtFromContentType(String pContentType) {
        String vMimeType = MimeMgr.extractMimeFromContentType(pContentType);
        for (int i = this.fMime.size() - 1; i >= 0; --i) {
            String vMime = this.fMime.get(i);
            if (!vMime.equalsIgnoreCase(vMimeType)) continue;
            return this.fExt.get(i);
        }
        return null;
    }

    public String searchExtFromMime(String pMimeType) {
        if (pMimeType != null) {
            String vMimeType = pMimeType.trim();
            for (int i = this.fMime.size() - 1; i >= 0; --i) {
                String vMime = this.fMime.get(i);
                if (!vMime.equalsIgnoreCase(vMimeType)) continue;
                return this.fExt.get(i);
            }
        }
        return null;
    }

    public String searchMimeFromExt(String pExt) {
        if (pExt == null || pExt.length() == 0) {
            return null;
        }
        int vOffset = 0;
        int vLenExt = pExt.length();
        if (pExt.charAt(0) == '.') {
            vOffset = 1;
            --vLenExt;
        }
        for (int i = this.fExt.size() - 1; i >= 0; --i) {
            String vExt = this.fExt.get(i);
            if (vLenExt != vExt.length() || !vExt.regionMatches(true, 0, pExt, vOffset, vExt.length())) continue;
            return this.fMime.get(i);
        }
        return null;
    }

    public String searchMimeFromUrl(String pUrl) {
        return this.searchMimeFromExt(MimeMgr.extractLastExtFromUrl(pUrl));
    }

    public void addEntry(String pExt, String pMime, boolean pIsDefaultAssociation) {
        if (pIsDefaultAssociation) {
            this.fExt.add(pExt);
            this.fMime.add(pMime);
        } else {
            int vOffset = this.fExt.size();
            for (int i = 0; i < this.fExt.size(); ++i) {
                String vExt = this.fExt.get(i);
                if (vExt.equalsIgnoreCase(vExt)) {
                    vOffset = i;
                    break;
                }
                String vMime = this.fMime.get(i);
                if (!vMime.equalsIgnoreCase(vMime)) continue;
                vOffset = i;
                break;
            }
            this.fExt.add(vOffset, pExt);
            this.fMime.add(vOffset, pMime);
        }
    }

    public MimeMgr addDefaultEntries() {
        this.addEntry("avi", "video/x-msvideo", true);
        this.addEntry("bin", "application/octet-stream", true);
        this.addEntry("bmp", "image/bmp", true);
        this.addEntry("cer", "application/x-x509-ca-cert", true);
        this.addEntry("class", "application/java", true);
        this.addEntry("css", "text/css", true);
        this.addEntry("dcr", "application/x-director", true);
        this.addEntry("doc", "application/msword", true);
        this.addEntry("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", true);
        this.addEntry("dtd", "text/plain", false);
        this.addEntry("dv", "video/x-dv", true);
        this.addEntry("dvi", "application/x-dvi", true);
        this.addEntry("eps", "application/postscript", true);
        this.addEntry("exe", "application/octet-stream", true);
        this.addEntry("gif", "image/gif", true);
        this.addEntry("htc", "text/x-component", true);
        this.addEntry("html", "text/html", true);
        this.addEntry("htm", "text/html", true);
        this.addEntry("jar", "application/java-archive", true);
        this.addEntry("java", "text/plain", false);
        this.addEntry("jnlp", "application/x-java-jnlp-file", true);
        this.addEntry("jpeg", "image/jpeg", true);
        this.addEntry("jpg", "image/jpeg", true);
        this.addEntry("ico", "image/x-icon", true);
        this.addEntry("js", "text/javascript", true);
        this.addEntry("latex", "application/x-latex", true);
        this.addEntry("mid", "audio/x-midi", true);
        this.addEntry("mov", "video/quicktime", true);
        this.addEntry("mp1", "audio/x-mpeg", true);
        this.addEntry("mp2", "audio/x-mpeg", true);
        this.addEntry("mp3", "audio/x-mpeg", true);
        this.addEntry("mpg", "audio/mpeg", true);
        this.addEntry("mpeg", "audio/mpeg", true);
        this.addEntry("mml", "text/mathml", true);
        this.addEntry("odt", "application/vnd.oasis.opendocument.text", true);
        this.addEntry("ods", "application/vnd.oasis.opendocument.spreadsheet", true);
        this.addEntry("odp", "application/vnd.oasis.opendocument.presentation", true);
        this.addEntry("odg", "application/vnd.oasis.opendocument.graphics", true);
        this.addEntry("odf", "application/vnd.oasis.opendocument.formula", true);
        this.addEntry("pdf", "application/pdf", true);
        this.addEntry("pic", "image/pict", true);
        this.addEntry("png", "image/png", true);
        this.addEntry("pps", "application/vnd.ms-powerpoint", false);
        this.addEntry("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", true);
        this.addEntry("ppt", "application/vnd.ms-powerpoint", true);
        this.addEntry("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation", true);
        this.addEntry("ps", "application/postscript", true);
        this.addEntry("qt", "video/quicktime", true);
        this.addEntry("qti", "image/x-quicktime", true);
        this.addEntry("rm", "application/vnd.rn-realmedia", true);
        this.addEntry("rtf", "application/rtf", true);
        this.addEntry("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide", true);
        this.addEntry("snd", "audio/basic", true);
        this.addEntry("svg", "image/svg+xml", true);
        this.addEntry("svgz", "image/svg+xml", false);
        this.addEntry("svm", "image/x-svm", true);
        this.addEntry("swf", "application/x-shockwave-flash", true);
        this.addEntry("tar", "application/x-tar", true);
        this.addEntry("tex", "application/x-tex", true);
        this.addEntry("txt", "text/plain", true);
        this.addEntry("wav", "audio/x-wav", true);
        this.addEntry("wmf", "image/x-wmf", true);
        this.addEntry("xhtml", "application/xhtml+xml", true);
        this.addEntry("xls", "application/vnd.ms-excel", true);
        this.addEntry("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", true);
        this.addEntry("xpi", "application/x-xpinstall", true);
        this.addEntry("xsl", "text/xml", false);
        this.addEntry("xbl", "text/xml", false);
        this.addEntry("xul", "text/xml", false);
        this.addEntry("xml", "text/xml", true);
        this.addEntry("zip", "application/zip", true);
        return this;
    }
}

