/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.pools;

import eu.scenari.fw.mem.IMemoryOwner;
import eu.scenari.fw.mem.MemoryMgr;
import java.io.StringWriter;
import java.util.ArrayList;

public class PoolBuffers
implements IMemoryOwner {
    public static int sMaxBuffersEntries = 10;
    public static int sStringBufferInitCapacity = 32768;
    public static int sStringBufferMaxCapacity = 66000;
    private static ArrayList<char[]> sChars4096 = new ArrayList(sMaxBuffersEntries);
    private static ArrayList<char[]> sChars64k = new ArrayList(sMaxBuffersEntries);
    private static ArrayList<byte[]> sBytes4096 = new ArrayList(sMaxBuffersEntries);
    private static ArrayList<byte[]> sBytes64k = new ArrayList(sMaxBuffersEntries);
    private static ArrayList<StringBuilder> sStringBuilders = new ArrayList(sMaxBuffersEntries);
    private static ArrayList<StringWriter> sStringWriters = new ArrayList(sMaxBuffersEntries);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] popBytes4096() {
        ArrayList<byte[]> arrayList = sBytes4096;
        synchronized (arrayList) {
            if (sBytes4096.size() > 0) {
                return sBytes4096.remove(sBytes4096.size() - 1);
            }
            return new byte[4096];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] popBytes64k() {
        ArrayList<byte[]> arrayList = sBytes64k;
        synchronized (arrayList) {
            if (sBytes64k.size() > 0) {
                return sBytes64k.remove(sBytes64k.size() - 1);
            }
            return new byte[65536];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] popChars4096() {
        ArrayList<char[]> arrayList = sChars4096;
        synchronized (arrayList) {
            if (sChars4096.size() > 0) {
                return sChars4096.remove(sChars4096.size() - 1);
            }
            return new char[4096];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] popChars64k() {
        ArrayList<char[]> arrayList = sChars64k;
        synchronized (arrayList) {
            if (sChars64k.size() > 0) {
                return sChars64k.remove(sChars64k.size() - 1);
            }
            return new char[65536];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StringBuilder popStringBuilder() {
        StringBuilder vResult;
        ArrayList<StringBuilder> arrayList = sStringBuilders;
        synchronized (arrayList) {
            vResult = sStringBuilders.size() > 0 ? sStringBuilders.remove(sStringBuilders.size() - 1) : new StringBuilder(sStringBufferInitCapacity);
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StringWriter popStringWriter() {
        StringWriter vResult;
        ArrayList<StringWriter> arrayList = sStringWriters;
        synchronized (arrayList) {
            vResult = sStringWriters.size() > 0 ? sStringWriters.remove(sStringWriters.size() - 1) : new StringWriter(sStringBufferInitCapacity);
        }
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void freeBytes(byte[] pBytes) {
        if (pBytes == null) {
            return;
        }
        switch (pBytes.length) {
            case 4096: {
                ArrayList<byte[]> arrayList = sBytes4096;
                synchronized (arrayList) {
                    if (sBytes4096.size() < sMaxBuffersEntries) {
                        sBytes4096.add(pBytes);
                    }
                    break;
                }
            }
            case 65536: {
                ArrayList<byte[]> arrayList = sBytes64k;
                synchronized (arrayList) {
                    if (sBytes64k.size() < sMaxBuffersEntries) {
                        sBytes64k.add(pBytes);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void freeChars(char[] pChars) {
        if (pChars == null) {
            return;
        }
        switch (pChars.length) {
            case 4096: {
                ArrayList<char[]> arrayList = sChars4096;
                synchronized (arrayList) {
                    if (sChars4096.size() < sMaxBuffersEntries) {
                        sChars4096.add(pChars);
                    }
                    break;
                }
            }
            case 65536: {
                ArrayList<char[]> arrayList = sChars64k;
                synchronized (arrayList) {
                    if (sChars64k.size() < sMaxBuffersEntries) {
                        sChars64k.add(pChars);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void freeStringBuilder(StringBuilder pStringBuilder) {
        if (pStringBuilder == null) {
            return;
        }
        if (pStringBuilder.capacity() < sStringBufferMaxCapacity) {
            pStringBuilder.setLength(0);
            ArrayList<StringBuilder> arrayList = sStringBuilders;
            synchronized (arrayList) {
                if (sStringBuilders.size() < sMaxBuffersEntries) {
                    sStringBuilders.add(pStringBuilder);
                }
            }
        }
    }

    public static final String getStringAndFreeStringBuilder(StringBuilder pStringBuilder) {
        String vResult = pStringBuilder.toString();
        PoolBuffers.freeStringBuilder(pStringBuilder);
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void freeStringWriter(StringWriter pStringWriter) {
        if (pStringWriter == null) {
            return;
        }
        if (pStringWriter.getBuffer().capacity() < sStringBufferMaxCapacity) {
            pStringWriter.flush();
            pStringWriter.getBuffer().setLength(0);
            ArrayList<StringWriter> arrayList = sStringWriters;
            synchronized (arrayList) {
                if (sStringWriters.size() < sMaxBuffersEntries) {
                    sStringWriters.add(pStringWriter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long freeMemory(int pPriority) throws Exception {
        int i;
        int vBuffersInPool = 10 - pPriority;
        long vResult = 0L;
        ArrayList<Object> arrayList = sBytes4096;
        synchronized (arrayList) {
            for (i = sBytes4096.size() - 1; i >= vBuffersInPool; --i) {
                sBytes4096.remove(i);
                vResult += 4111L;
            }
        }
        arrayList = sChars4096;
        synchronized (arrayList) {
            for (i = sChars4096.size() - 1; i >= vBuffersInPool; --i) {
                sChars4096.remove(i);
                vResult += 4111L;
            }
        }
        arrayList = sStringBuilders;
        synchronized (arrayList) {
            for (i = sStringBuilders.size() - 1; i >= vBuffersInPool; --i) {
                vResult += (long)(30 + sStringBuilders.remove(i).capacity() * 2);
            }
        }
        arrayList = sStringWriters;
        synchronized (arrayList) {
            for (i = sStringWriters.size() - 1; i >= vBuffersInPool; --i) {
                vResult += (long)(45 + sStringWriters.remove(i).getBuffer().capacity() * 2);
            }
        }
        return vResult;
    }

    static {
        MemoryMgr.registerMemoryOwner(new PoolBuffers());
    }
}

