/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.stream;

import eu.scenari.fw.pools.PoolBuffers;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String buildString(Reader pReader) throws Exception {
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        char[] vChars = PoolBuffers.popChars64k();
        try {
            int vNbRead = 0;
            while (vNbRead >= 0) {
                vNbRead = pReader.read(vChars);
                if (vNbRead <= 0) continue;
                vBuf.append(vChars, 0, vNbRead);
            }
            String string = vBuf.toString();
            return string;
        }
        finally {
            pReader.close();
            PoolBuffers.freeChars(vChars);
            PoolBuffers.freeStringBuilder(vBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String buildString(Reader pReader, int pNbChars) throws Exception {
        StringBuilder vBuf = new StringBuilder(pNbChars);
        char[] vChars = PoolBuffers.popChars64k();
        try {
            int vNbRead = 0;
            while (vNbRead >= 0) {
                vNbRead = pReader.read(vChars);
                if (vNbRead <= 0) continue;
                vBuf.append(vChars, 0, vNbRead);
            }
        }
        finally {
            pReader.close();
            PoolBuffers.freeChars(vChars);
        }
        return vBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(InputStream pInputStream, OutputStream pOutputStream) throws Exception {
        byte[] vBuf = PoolBuffers.popBytes64k();
        try {
            int vOffset = 0;
            while (vOffset >= 0) {
                vOffset = pInputStream.read(vBuf);
                if (vOffset <= 0) continue;
                pOutputStream.write(vBuf, 0, vOffset);
            }
        }
        finally {
            pInputStream.close();
            PoolBuffers.freeBytes(vBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(Reader pReader, Writer pWriter) throws Exception {
        char[] vBuf = PoolBuffers.popChars64k();
        try {
            int vOffset = 0;
            while (vOffset >= 0) {
                vOffset = pReader.read(vBuf);
                if (vOffset <= 0) continue;
                pWriter.write(vBuf, 0, vOffset);
            }
        }
        finally {
            pReader.close();
            PoolBuffers.freeChars(vBuf);
        }
    }
}

