/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.stream.bytes;

import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FullBufferedInputStream
extends FilterInputStream {
    protected byte[][] fBuf = new byte[10][];
    protected int fCountBuf = -1;
    protected int fCount = 0;
    protected int fPosBuf = this.fCountBuf;
    protected int fPos = this.fCount;
    protected int fMarkBuf = 0;
    protected int fMark = 0;
    protected boolean fLastRead = false;

    public FullBufferedInputStream(InputStream pIn) {
        super(pIn);
        this.xGetNextBuf();
    }

    public int available() throws IOException {
        int vRes = 0;
        for (int i = this.fPosBuf; i < this.fCountBuf; ++i) {
            vRes += this.fBuf[i].length;
        }
        return vRes + this.fCount - this.fPos + (this.in != null ? this.in.available() : 0);
    }

    public void close() throws IOException {
        if (this.fLastRead) {
            this.destroy();
        } else if (this.in != null) {
            this.read();
        }
    }

    public void mark(int readlimit) {
        this.fMarkBuf = this.fPosBuf;
        this.fMark = this.fPos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        byte vRes;
        if (this.fPosBuf < this.fCountBuf) {
            vRes = this.fBuf[this.fPosBuf][this.fPos];
            ++this.fPos;
            if (this.fPos >= this.fBuf[this.fPosBuf].length) {
                ++this.fPosBuf;
                this.fPos = 0;
            }
        } else if (this.fPos < this.fCount) {
            vRes = this.fBuf[this.fPosBuf][this.fPos];
            ++this.fPos;
        } else if (this.in != null) {
            int vRead = this.in.read();
            if (vRead == -1) {
                this.in.close();
                this.in = null;
                return -1;
            }
            vRes = (byte)vRead;
            this.fBuf[this.fPosBuf][this.fCount++] = vRes;
            if (this.fCount >= this.fBuf[this.fPosBuf].length) {
                this.xGetNextBuf();
            }
            this.fPos = this.fCount;
        } else {
            return -1;
        }
        return vRes & 0xFF;
    }

    public int read(byte[] pB, int pOff, int pLen) throws IOException {
        int vDispo;
        if ((pOff | pLen | pOff + pLen | pB.length - (pOff + pLen)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pLen == 0) {
            return 0;
        }
        int vNbRead = 0;
        int vOff = pOff;
        int vLen = pLen;
        while (this.fPosBuf < this.fCountBuf) {
            vDispo = this.fBuf[this.fPosBuf].length - this.fPos;
            if (vDispo > vLen) {
                System.arraycopy(this.fBuf[this.fPosBuf], this.fPos, pB, vOff, vLen);
                this.fPos += vLen;
                return vNbRead += vLen;
            }
            System.arraycopy(this.fBuf[this.fPosBuf], this.fPos, pB, vOff, vDispo);
            vNbRead += vDispo;
            ++this.fPosBuf;
            this.fPos = 0;
            if (vLen == vDispo) {
                return vNbRead;
            }
            vOff += vDispo;
            vLen -= vDispo;
        }
        if (this.fPosBuf == this.fCountBuf && this.fCount > this.fPos) {
            vDispo = this.fCount - this.fPos;
            if (vDispo > vLen) {
                System.arraycopy(this.fBuf[this.fPosBuf], this.fPos, pB, vOff, vLen);
                this.fPos += vLen;
                return vNbRead += vLen;
            }
            System.arraycopy(this.fBuf[this.fPosBuf], this.fPos, pB, vOff, vDispo);
            this.fPos += vDispo;
            vNbRead += vDispo;
            if (vLen == vDispo) {
                return vNbRead;
            }
            vOff += vDispo;
            vLen -= vDispo;
        }
        if (this.in != null) {
            int vRead = this.in.read(pB, vOff, vLen);
            if (vRead == -1) {
                this.in.close();
                this.in = null;
                return vNbRead > 0 ? vNbRead : -1;
            }
            if (vRead < vLen) {
                Thread.yield();
                if (vRead == 0) {
                    return vNbRead;
                }
                vLen = vRead;
            }
            vNbRead += vRead;
            int vDispo2 = this.fBuf[this.fCountBuf].length - this.fCount;
            while (vLen >= vDispo2) {
                System.arraycopy(pB, vOff, this.fBuf[this.fCountBuf], this.fCount, vDispo2);
                this.xGetNextBuf();
                if (vLen == vDispo2) {
                    return vNbRead;
                }
                vOff += vDispo2;
                vLen -= vDispo2;
                vDispo2 = this.fBuf[this.fCountBuf].length;
            }
            System.arraycopy(pB, vOff, this.fBuf[this.fCountBuf], this.fCount, vLen);
            this.fCount += vLen;
        } else {
            return vNbRead > 0 ? vNbRead : -1;
        }
        this.fPos = this.fCount;
        return vNbRead;
    }

    public void reset() throws IOException {
        this.fPosBuf = this.fMarkBuf;
        this.fPos = this.fMark;
    }

    public long skip(long pLen) throws IOException {
        int vDispo;
        if (pLen == 0L) {
            return 0L;
        }
        long vLen = pLen;
        long vNbRead = 0L;
        while (this.fPosBuf < this.fCountBuf) {
            vDispo = this.fBuf[this.fPosBuf].length - this.fPos;
            if ((long)vDispo > vLen) {
                this.fPos = (int)((long)this.fPos + vLen);
                return vNbRead += vLen;
            }
            vNbRead += (long)vDispo;
            ++this.fPosBuf;
            this.fPos = 0;
            if (vLen == (long)vDispo) {
                return vNbRead;
            }
            vLen -= (long)vDispo;
        }
        if (this.fPosBuf == this.fCountBuf && this.fCount > this.fPos) {
            vDispo = this.fCount - this.fPos;
            if ((long)vDispo > vLen) {
                this.fPos = (int)((long)this.fPos + vLen);
                return vNbRead += vLen;
            }
            this.fPos += vDispo;
            vNbRead += (long)vDispo;
            if (vLen == (long)vDispo) {
                return vNbRead;
            }
            vLen -= (long)vDispo;
        }
        if (this.in != null) {
            while (vLen > 0L) {
                int vRead;
                vDispo = this.fBuf[this.fCountBuf].length - this.fCount;
                while (vLen > 0L && vLen >= (long)vDispo) {
                    vRead = this.in.read(this.fBuf[this.fCountBuf], this.fCount, vDispo);
                    if (vRead == -1) {
                        this.in.close();
                        this.in = null;
                        return vNbRead > 0L ? vNbRead : -1L;
                    }
                    if (vRead < vDispo) {
                        Thread.yield();
                        if (vRead == 0) {
                            return vNbRead;
                        }
                        this.fCount += vRead;
                        this.fPos = this.fCount;
                    } else {
                        this.xGetNextBuf();
                    }
                    vNbRead += (long)vRead;
                    vLen -= (long)vRead;
                    vDispo = this.fBuf[this.fCountBuf].length - this.fCount;
                }
                if (vLen <= 0L) continue;
                vRead = this.in.read(this.fBuf[this.fCountBuf], this.fCount, (int)vLen);
                if (vRead == -1) {
                    this.in.close();
                    this.in = null;
                    return vNbRead > 0L ? vNbRead : -1L;
                }
                if ((long)vRead < vLen) {
                    Thread.yield();
                    if (vRead == 0) {
                        return vNbRead;
                    }
                }
                vNbRead += (long)vRead;
                vLen -= (long)vRead;
                this.fCount += vRead;
                this.fPos = this.fCount;
            }
        } else {
            return vNbRead > 0L ? vNbRead : -1L;
        }
        return vNbRead;
    }

    public void destroy() {
        for (int i = 0; i <= this.fCountBuf; ++i) {
            PoolBuffers.freeBytes(this.fBuf[i]);
            this.fBuf[i] = null;
        }
        this.fMark = 0;
        this.fMarkBuf = 0;
        this.fCountBuf = 0;
        this.fCount = 0;
        this.fPosBuf = 0;
        this.fPos = 0;
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            this.in = null;
        }
    }

    public void rewind() throws IOException {
        this.fMark = 0;
        this.fMarkBuf = 0;
        this.fPos = 0;
        this.fPosBuf = 0;
    }

    public void rewindForLastRead() throws IOException {
        this.rewind();
        this.fLastRead = true;
    }

    public InputStream disconnectSubInputStream() throws IOException {
        InputStream vIn = this.in;
        if (this.in != null) {
            int vRead = -1;
            try {
                vRead = this.in.read();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            if (vRead == -1) {
                this.in.close();
                this.in = null;
                vIn = null;
            } else {
                this.fBuf[this.fCountBuf][this.fCount++] = (byte)vRead;
                if (this.fCount >= this.fBuf[this.fCountBuf].length) {
                    this.xGetNextBuf();
                }
                this.in = null;
            }
        }
        return vIn;
    }

    protected final void xGetNextBuf() {
        ++this.fCountBuf;
        this.fPosBuf = this.fCountBuf;
        this.fCount = 0;
        this.fPos = 0;
        if (this.fBuf.length <= this.fCountBuf) {
            byte[][] vNew = new byte[this.fCountBuf * 2][];
            System.arraycopy(this.fBuf, 0, vNew, 0, this.fCountBuf);
            this.fBuf = vNew;
        }
        this.fBuf[this.fCountBuf] = PoolBuffers.popBytes64k();
    }
}

