/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.stream.bytes;

import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.IBlob;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamByteStream
implements IByteStream {
    protected InputStream fInputSrc = null;

    public InputStreamByteStream(InputStream pInput) {
        if (pInput == null) {
            throw new NullPointerException("Null InputStream not allowed.");
        }
        this.fInputSrc = pInput;
    }

    public InputStream getInputStream(boolean pCloseWhenInputStreamIsClosed) throws Exception {
        return this.fInputSrc;
    }

    public void writeIn(OutputStream pStream) throws Exception {
        StreamUtils.write(this.fInputSrc, pStream);
    }

    public IBlob transformAsBlob() throws Exception {
        OutputStreamBlob vBlob = new OutputStreamBlob();
        StreamUtils.write(this.fInputSrc, vBlob);
        this.closeStream();
        return vBlob;
    }

    public void closeStream() {
        try {
            this.fInputSrc.close();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }
}

