/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.stream.bytes;

import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.bytes.IBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class OutputStreamBlob
extends OutputStream
implements IBlob {
    protected static final int sLengthBuf = 65536;
    protected byte[][] fBuf = new byte[12][];
    protected int fCountBuf = -1;
    protected int fCount = 0;
    protected String fContentType = null;

    public OutputStreamBlob() {
        this.xGetNextBuf();
    }

    public int getLength() {
        return this.fCountBuf * 65536 + this.fCount;
    }

    public InputStream getInputStream(boolean pCloseWhenInputStreamIsClosed) throws Exception {
        return new XBufferInputStream(pCloseWhenInputStreamIsClosed);
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(byte[] pBytes, int pOff, int pLen) throws IOException {
        if (pOff < 0 || pOff > pBytes.length || pLen < 0 || pOff + pLen > pBytes.length || pOff + pLen < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (pLen > 0) {
            if (this.fCount >= 65536) {
                this.xGetNextBuf();
            }
            int vLen = Math.min(pLen, 65536 - this.fCount);
            System.arraycopy(pBytes, pOff, this.fBuf[this.fCountBuf], this.fCount, vLen);
            this.fCount += vLen;
            pOff += vLen;
            pLen -= vLen;
        }
    }

    public void write(byte[] pBytes) throws IOException {
        this.write(pBytes, 0, pBytes.length);
    }

    public void write(int pByte) throws IOException {
        if (this.fCount >= 65536) {
            this.xGetNextBuf();
        }
        this.fBuf[this.fCountBuf][this.fCount++] = (byte)pByte;
    }

    protected final void xGetNextBuf() {
        ++this.fCountBuf;
        this.fCount = 0;
        if (this.fBuf.length <= this.fCountBuf) {
            byte[][] vNew = new byte[this.fCountBuf * 2][];
            System.arraycopy(this.fBuf, 0, vNew, 0, this.fCountBuf);
            this.fBuf = vNew;
        }
        this.fBuf[this.fCountBuf] = PoolBuffers.popBytes64k();
    }

    public String toString() {
        byte[] vBytes = new byte[this.getLength()];
        for (int i = 0; i < this.fCountBuf; ++i) {
            System.arraycopy(this.fBuf[i], 0, vBytes, 0, 65536);
        }
        System.arraycopy(this.fBuf[this.fCountBuf], 0, vBytes, 0, this.fCount);
        return new String(vBytes);
    }

    public String toString(String pEncoding) throws Exception {
        byte[] vBytes = new byte[this.getLength()];
        for (int i = 0; i < this.fCountBuf; ++i) {
            System.arraycopy(this.fBuf[i], 0, vBytes, 0, 65536);
        }
        System.arraycopy(this.fBuf[this.fCountBuf], 0, vBytes, 0, this.fCount);
        return new String(vBytes, pEncoding);
    }

    public void writeIn(OutputStream pStream) throws Exception {
        for (int i = 0; i < this.fCountBuf; ++i) {
            pStream.write(this.fBuf[i], 0, 65536);
        }
        if (this.fCount > 0) {
            pStream.write(this.fBuf[this.fCountBuf], 0, this.fCount);
        }
    }

    public IBlob transformAsBlob() throws Exception {
        return this;
    }

    public void computeCheckSum(Checksum pCheckSum) throws Exception {
        for (int i = 0; i < this.fCountBuf; ++i) {
            pCheckSum.update(this.fBuf[i], 0, 65536);
        }
        if (this.fCount > 0) {
            pCheckSum.update(this.fBuf[this.fCountBuf], 0, this.fCount);
        }
    }

    public void closeStream() {
        byte[][] vBytes = this.fBuf;
        for (int i = 1; i <= this.fCountBuf; ++i) {
            PoolBuffers.freeBytes(vBytes[i]);
            vBytes[i] = null;
        }
        this.fCountBuf = 0;
        this.fCount = 0;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public void setContentType(String pContentType) {
        this.fContentType = pContentType;
    }

    public class XBufferInputStream
    extends InputStream {
        protected int fPosBuf = 0;
        protected int fPos = 0;
        protected int fMarkBuf = 0;
        protected int fMark = 0;
        boolean fCloseBufferStream = false;

        public XBufferInputStream(boolean pCloseBufferStream) {
            this.fCloseBufferStream = pCloseBufferStream;
        }

        public int available() throws IOException {
            int vRest = this.fPosBuf < OutputStreamBlob.this.fCountBuf ? 65536 - this.fPos : OutputStreamBlob.this.fCount - this.fPos;
            for (int i = this.fPosBuf + 1; i < OutputStreamBlob.this.fCountBuf; ++i) {
                vRest += 65536;
            }
            if (OutputStreamBlob.this.fCountBuf > this.fPosBuf) {
                vRest += OutputStreamBlob.this.fCount;
            }
            return vRest;
        }

        public int read() throws IOException {
            if (this.fPosBuf < OutputStreamBlob.this.fCountBuf) {
                if (this.fPos < 65536) {
                    return OutputStreamBlob.this.fBuf[this.fPosBuf][this.fPos++];
                }
                ++this.fPosBuf;
                this.fPos = 0;
                if (this.fPosBuf < OutputStreamBlob.this.fCountBuf) {
                    return OutputStreamBlob.this.fBuf[this.fPosBuf][this.fPos++];
                }
            }
            if (this.fPos < OutputStreamBlob.this.fCount) {
                return OutputStreamBlob.this.fBuf[this.fPosBuf][this.fPos++];
            }
            return -1;
        }

        public int read(byte[] pBytes, int pOff, int pLen) throws IOException {
            int vLen;
            int vRead = 0;
            while (this.fPosBuf < OutputStreamBlob.this.fCountBuf) {
                if (this.fPos < 65536) {
                    vLen = Math.min(pLen, 65536 - this.fPos);
                    System.arraycopy(OutputStreamBlob.this.fBuf[this.fPosBuf], this.fPos, pBytes, pOff, vLen);
                    this.fPos += vLen;
                    vRead += vLen;
                    if (vLen == pLen) {
                        return vRead;
                    }
                    pOff += vLen;
                    pLen -= vLen;
                }
                ++this.fPosBuf;
                this.fPos = 0;
            }
            if (this.fPos < OutputStreamBlob.this.fCount) {
                vLen = Math.min(pLen, OutputStreamBlob.this.fCount - this.fPos);
                System.arraycopy(OutputStreamBlob.this.fBuf[this.fPosBuf], this.fPos, pBytes, pOff, vLen);
                this.fPos += vLen;
                return vRead + vLen;
            }
            return vRead == 0 ? -1 : vRead;
        }

        public long skip(long n) throws IOException {
            return super.skip(n);
        }

        public void mark(int readlimit) {
            this.fMarkBuf = this.fPosBuf;
            this.fMark = this.fPos;
        }

        public boolean markSupported() {
            return true;
        }

        public void reset() throws IOException {
            this.fPosBuf = this.fMarkBuf;
            this.fPos = this.fMark;
        }

        public void close() throws IOException {
            if (this.fCloseBufferStream) {
                OutputStreamBlob.this.closeStream();
            }
        }
    }
}

