/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.stream.bytes;

import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.IBlob;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class OutputStreamByteStream
implements IByteStream,
Runnable {
    protected static ExecutorService fExecutor = Executors.newCachedThreadPool();
    protected InputStream fInputSrc = null;
    protected PipedOutputStream fOutPut = null;

    protected OutputStreamByteStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.writeIn(this.fOutPut);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        finally {
            try {
                this.fOutPut.close();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }

    public InputStream getInputStream(boolean pCloseWhenInputStreamIsClosed) throws Exception {
        if (this.fInputSrc == null) {
            this.fInputSrc = new PipedInputStream();
            this.fOutPut = new PipedOutputStream((PipedInputStream)this.fInputSrc);
            fExecutor.execute(this);
        }
        return this.fInputSrc;
    }

    public IBlob transformAsBlob() throws Exception {
        OutputStreamBlob vBlob = new OutputStreamBlob();
        this.writeIn(vBlob);
        this.closeStream();
        return vBlob;
    }

    public void closeStream() {
        if (this.fInputSrc != null) {
            try {
                this.fInputSrc.close();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
        if (this.fOutPut != null) {
            try {
                this.fOutPut.close();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }
}

