/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.stream.chars;

import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.chars.IClob;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.xml.sax.ContentHandler;

public class WriterClob
extends Writer
implements IClob {
    protected static final int sLengthBuf = 4096;
    protected PoolBuffers fPoolBuf = null;
    protected char[][] fBuf = new char[12][];
    protected int fCountBuf = -1;
    protected int fCount = 0;
    protected String fContentType = null;

    public WriterClob() {
        this.xGetNextBuf();
    }

    public int length() {
        return this.fCountBuf * 4096 + this.fCount;
    }

    public char charAt(int pIndex) {
        int vIdxBuf = pIndex / 4096;
        int vOffset = pIndex % 4096;
        if (vIdxBuf > this.fCountBuf) {
            throw new IndexOutOfBoundsException();
        }
        if (vIdxBuf == this.fCountBuf && vOffset >= this.fCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.fBuf[vIdxBuf][vOffset];
    }

    public CharSequence subSequence(int pStart, int pEnd) {
        return this.toString().subSequence(pStart, pEnd);
    }

    public Reader getReader(boolean pCloseWhenInputStreamIsClosed) throws Exception {
        return new XBufferReader(pCloseWhenInputStreamIsClosed);
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(char[] pChars, int pOff, int pLen) throws IOException {
        if (pOff < 0 || pOff > pChars.length || pLen < 0 || pOff + pLen > pChars.length || pOff + pLen < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (pLen > 0) {
            if (this.fCount >= 4096) {
                this.xGetNextBuf();
            }
            int vLen = Math.min(pLen, 4096 - this.fCount);
            System.arraycopy(pChars, pOff, this.fBuf[this.fCountBuf], this.fCount, vLen);
            this.fCount += vLen;
            pOff += vLen;
            pLen -= vLen;
        }
    }

    public void write(char[] pChars) throws IOException {
        this.write(pChars, 0, pChars.length);
    }

    public void write(int pChar) throws IOException {
        if (this.fCount >= 4096) {
            this.xGetNextBuf();
        }
        this.fBuf[this.fCountBuf][this.fCount++] = (char)pChar;
    }

    protected final void xGetNextBuf() {
        ++this.fCountBuf;
        this.fCount = 0;
        if (this.fBuf.length <= this.fCountBuf) {
            char[][] vNew = new char[this.fCountBuf * 2][];
            System.arraycopy(this.fBuf, 0, vNew, 0, this.fCountBuf);
            this.fBuf = vNew;
        }
        this.fBuf[this.fCountBuf] = PoolBuffers.popChars4096();
    }

    public String toString() {
        StringBuilder vBuf = new StringBuilder(this.length());
        for (int i = 0; i < this.fCountBuf; ++i) {
            vBuf.append(this.fBuf[i], 0, 4096);
        }
        if (this.fCount > 0) {
            vBuf.append(this.fBuf[this.fCountBuf], 0, this.fCount);
        }
        return vBuf.toString();
    }

    public void writeIn(Writer pStream) throws Exception {
        for (int i = 0; i < this.fCountBuf; ++i) {
            pStream.write(this.fBuf[i], 0, 4096);
        }
        if (this.fCount > 0) {
            pStream.write(this.fBuf[this.fCountBuf], 0, this.fCount);
        }
    }

    public void writeToSaxHandler(ContentHandler pContentHandler) throws Exception {
        for (int i = 0; i < this.fCountBuf; ++i) {
            pContentHandler.characters(this.fBuf[i], 0, 4096);
        }
        if (this.fCount > 0) {
            pContentHandler.characters(this.fBuf[this.fCountBuf], 0, this.fCount);
        }
    }

    public IClob transformAsClob() throws Exception {
        return this;
    }

    public void closeStream() {
        char[][] vChars = this.fBuf;
        for (int i = 1; i <= this.fCountBuf; ++i) {
            PoolBuffers.freeChars(vChars[i]);
            vChars[i] = null;
        }
        this.fCountBuf = 0;
        this.fCount = 0;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public void setContentType(String pContentType) {
        this.fContentType = pContentType;
    }

    public class XBufferReader
    extends Reader {
        protected int fPosBuf = 0;
        protected int fPos = 0;
        protected int fMarkBuf = 0;
        protected int fMark = 0;
        protected boolean fCloseBufferStream = false;

        public XBufferReader(boolean pCloseBufferStream) {
            this.fCloseBufferStream = pCloseBufferStream;
        }

        public int read() throws IOException {
            if (this.fPosBuf < WriterClob.this.fCountBuf) {
                if (this.fPos < 4096) {
                    return WriterClob.this.fBuf[this.fPosBuf][this.fPos++];
                }
                ++this.fPosBuf;
                this.fPos = 0;
                if (this.fPosBuf < WriterClob.this.fCountBuf) {
                    return WriterClob.this.fBuf[this.fPosBuf][this.fPos++];
                }
            }
            if (this.fPos < WriterClob.this.fCount) {
                return WriterClob.this.fBuf[this.fPosBuf][this.fPos++];
            }
            return -1;
        }

        public int read(char[] pChars, int pOff, int pLen) throws IOException {
            int vLen;
            int vRead = 0;
            while (this.fPosBuf < WriterClob.this.fCountBuf) {
                if (this.fPos < 4096) {
                    vLen = Math.min(pLen, 4096 - this.fPos);
                    System.arraycopy(WriterClob.this.fBuf[this.fPosBuf], this.fPos, pChars, pOff, vLen);
                    this.fPos += vLen;
                    vRead += vLen;
                    if (vLen == pLen) {
                        return vRead;
                    }
                    pOff += vLen;
                    pLen -= vLen;
                }
                ++this.fPosBuf;
                this.fPos = 0;
            }
            if (this.fPos < WriterClob.this.fCount) {
                vLen = Math.min(pLen, WriterClob.this.fCount - this.fPos);
                System.arraycopy(WriterClob.this.fBuf[this.fPosBuf], this.fPos, pChars, pOff, vLen);
                this.fPos += vLen;
                return vRead + vLen;
            }
            return vRead == 0 ? -1 : vRead;
        }

        public boolean ready() throws IOException {
            return true;
        }

        public long skip(long n) throws IOException {
            return super.skip(n);
        }

        public void mark(int readlimit) {
            this.fMarkBuf = this.fPosBuf;
            this.fMark = this.fPos;
        }

        public boolean markSupported() {
            return true;
        }

        public void reset() throws IOException {
            this.fPosBuf = this.fMarkBuf;
            this.fPos = this.fMark;
        }

        public void close() throws IOException {
            if (this.fCloseBufferStream) {
                WriterClob.this.closeStream();
            }
        }
    }
}

