/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.syntax.cdm;

import eu.scenari.fw.syntax.cdm.CdmParser;
import eu.scenari.fw.syntax.cdm.ICdmHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdmObjectBuilder
implements ICdmHandler {
    protected Object fCurrentObject = null;
    protected List<Object> fStack = new ArrayList<Object>();

    public static Object parseCdm(CharSequence pCdm) throws Exception {
        CdmParser vParser = CdmParser.getPooledParser();
        CdmObjectBuilder vObjBuilder = new CdmObjectBuilder();
        vParser.parse(pCdm, vObjBuilder);
        CdmParser.freePooledParser(vParser);
        return vObjBuilder.getBuildedObject();
    }

    public Object getBuildedObject() {
        return this.fCurrentObject;
    }

    public void reset() {
        this.fCurrentObject = null;
        this.fStack.clear();
    }

    @Override
    public void property(CharSequence pName, CharSequence pValue) throws Exception {
        if (this.fCurrentObject == null) {
            this.fCurrentObject = pName.length() == 0 ? this.createArray() : this.createObject();
        }
        this.addObj(pName, ((Object)pValue).toString());
    }

    @Override
    public void startObject(CharSequence pName) throws Exception {
        if (this.fCurrentObject != null) {
            this.fStack.add(this.fCurrentObject);
            Map<String, Object> vNewObj = this.createObject();
            this.addObj(pName, vNewObj);
            this.fCurrentObject = vNewObj;
        } else if (pName.length() == 0) {
            this.fCurrentObject = this.createObject();
        } else {
            this.fCurrentObject = this.createObject();
            this.startObject(pName);
        }
    }

    @Override
    public void endObject(CharSequence pName) throws Exception {
        if (this.fStack.size() == 0) {
            return;
        }
        this.fCurrentObject = this.fStack.remove(this.fStack.size() - 1);
    }

    @Override
    public void startArray(CharSequence pName) throws Exception {
        if (this.fCurrentObject != null) {
            this.fStack.add(this.fCurrentObject);
            List<Object> vNewArray = this.createArray();
            this.addObj(pName, vNewArray);
            this.fCurrentObject = vNewArray;
        } else if (pName.length() == 0) {
            this.fCurrentObject = this.createArray();
        } else {
            this.fCurrentObject = this.createObject();
            this.startArray(pName);
        }
    }

    @Override
    public void endArray(CharSequence pName) throws Exception {
        if (this.fStack.size() == 0) {
            return;
        }
        this.fCurrentObject = this.fStack.remove(this.fStack.size() - 1);
    }

    protected void addObj(CharSequence pName, Object pNewObj) {
        if (this.fCurrentObject instanceof Map) {
            ((Map)this.fCurrentObject).put(((Object)pName).toString(), pNewObj);
        } else {
            ((List)this.fCurrentObject).add(pNewObj);
        }
    }

    protected Map<String, Object> createObject() {
        return new LinkedHashMap<String, Object>();
    }

    protected List<Object> createArray() {
        return new ArrayList<Object>();
    }
}

