/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.syntax.cdm;

import com.scenari.s.fw.utils.CharSeqSegment;
import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.s.fw.utils.HIntArrayList;
import eu.scenari.fw.syntax.cdm.ICdmHandler;
import eu.scenari.fw.syntax.cdm.ICdmParser;
import java.util.ArrayList;

public class CdmParser
implements ICdmParser {
    protected static ArrayList<CdmParser> sPool = new ArrayList();
    protected Name fCurrName = new Name();
    protected Value fValueParser = new Value();
    protected int fCurrStatus = 1;
    protected CharSequence fCurrValue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CdmParser getPooledParser() {
        ArrayList<CdmParser> arrayList = sPool;
        synchronized (arrayList) {
            int vL = sPool.size();
            if (vL > 0) {
                return sPool.remove(vL - 1);
            }
        }
        return new CdmParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freePooledParser(CdmParser pParser) {
        ArrayList<CdmParser> arrayList = sPool;
        synchronized (arrayList) {
            pParser.setSource(null);
            sPool.add(pParser);
        }
    }

    public void parse(CharSequence pSeq, ICdmHandler pHandler) throws Exception {
        this.fCurrName.reset(pSeq, 0, 0);
        this.fValueParser.reset(pSeq, 0, 0);
        try {
            block13: while (true) {
                switch (this.fCurrName.searchNextName()) {
                    case 4: {
                        pHandler.startObject(this.fCurrName);
                        this.fCurrName.setStart(this.fCurrName.fNextWord);
                        continue block13;
                    }
                    case 64: {
                        pHandler.startArray(this.fCurrName);
                        this.fCurrName.setStart(this.fCurrName.fNextWord);
                        continue block13;
                    }
                    case 16: {
                        CharSequence vVal = this.fValueParser.parseValue(this.fCurrName.fNextWord);
                        if (vVal == null) {
                            throw new Exception("Parsing CDM failed : " + pSeq);
                        }
                        pHandler.property(this.fCurrName, vVal);
                        this.fCurrName.setStart(this.fValueParser.fNextWord);
                        continue block13;
                    }
                    case 8: {
                        pHandler.endArray(this.fCurrName);
                        this.fCurrName.setStart(this.fCurrName.fNextWord);
                        continue block13;
                    }
                    case 128: {
                        pHandler.endObject(this.fCurrName);
                        this.fCurrName.setStart(this.fCurrName.fNextWord);
                        continue block13;
                    }
                    case 2: {
                        return;
                    }
                    case 32: {
                        throw new Exception("Parsing CDM failed : " + pSeq);
                    }
                }
            }
        }
        finally {
            this.fCurrName.reset(null, 0, 0);
            this.fValueParser.reset(null, 0, 0);
        }
    }

    public void setSource(CharSequence pSeq) {
        this.fCurrName.reset(pSeq, 0, 0);
        this.fValueParser.reset(pSeq, 0, 0);
        this.fCurrStatus = 1;
        this.fCurrValue = null;
    }

    public int gotoNextSiblingData() throws Exception {
        try {
            switch (this.fCurrStatus) {
                case 4: {
                    int vEnd = this.seekEndObject(this.fCurrName.fNextWord);
                    this.nextData(vEnd);
                    break;
                }
                case 64: {
                    int vEnd = this.seekEndArray(this.fCurrName.fNextWord);
                    this.nextData(vEnd);
                    break;
                }
                case 8: 
                case 128: {
                    this.nextData(this.fCurrName.fNextWord);
                    break;
                }
                case 16: {
                    this.nextData(this.fValueParser.fNextWord);
                }
                default: {
                    throw new Exception("CDM parser : gotoNextSiblingData() not allowed in this context.");
                }
            }
            return this.fCurrStatus;
        }
        catch (Exception e) {
            this.fCurrStatus = 32;
            throw e;
        }
    }

    public int gotoFirstChildData() throws Exception {
        try {
            switch (this.fCurrStatus) {
                case 4: 
                case 64: {
                    this.nextData(this.fCurrName.fNextWord);
                    return this.fCurrStatus;
                }
                case 1: {
                    this.nextData(0);
                    return this.fCurrStatus;
                }
            }
            throw new Exception("CDM parser : gotoFirstChildData() not allowed in this context.");
        }
        catch (Exception e) {
            this.fCurrStatus = 32;
            throw e;
        }
    }

    public int gotoNextData() throws Exception {
        try {
            switch (this.fCurrStatus) {
                case 4: 
                case 8: 
                case 64: 
                case 128: {
                    this.nextData(this.fCurrName.fNextWord);
                    break;
                }
                case 16: {
                    this.nextData(this.fValueParser.fNextWord);
                    break;
                }
                case 1: {
                    this.nextData(0);
                    break;
                }
                default: {
                    throw new Exception("CDM parser : no more data.");
                }
            }
            return this.fCurrStatus;
        }
        catch (Exception e) {
            this.fCurrStatus = 32;
            throw e;
        }
    }

    public int gotoEnd() throws Exception {
        try {
            int vEnd;
            int vStackLen = this.fCurrName.fObjectStack.size();
            if (vStackLen == 0) {
                throw new Exception("CDM parser : gotoParentData() not allowed in root context.");
            }
            switch (this.fCurrStatus) {
                case 4: {
                    vEnd = this.seekEndObject(this.fCurrName.fNextWord);
                    break;
                }
                case 64: {
                    vEnd = this.seekEndArray(this.fCurrName.fNextWord);
                    break;
                }
                case 8: 
                case 128: {
                    vEnd = this.fCurrName.fNextWord;
                    break;
                }
                case 16: {
                    vEnd = this.seekEndObject(this.fValueParser.fNextWord);
                    break;
                }
                default: {
                    throw new Exception("CDM parser : gotoEnd() not allowed in this context.");
                }
            }
            this.fCurrName.fNextWord = vEnd;
            int vLen = this.fCurrName.fObjectStack.removeInt(--vStackLen);
            this.fCurrName.setSegment(this.fCurrName.fObjectStack.removeInt(--vStackLen), vLen);
            this.fCurrStatus = 8;
            return this.fCurrStatus;
        }
        catch (Exception e) {
            this.fCurrStatus = 32;
            throw e;
        }
    }

    public void rewindBeforeCurrentData() throws Exception {
        try {
            switch (this.fCurrStatus) {
                case 4: 
                case 64: {
                    this.fCurrName.rewindBeforeCurrName(true);
                    break;
                }
                case 16: {
                    this.fValueParser.fNextWord = this.fCurrName.getStart();
                    break;
                }
                default: {
                    throw new Exception("CDM parser : revertBeforeCurrentData not allowed.");
                }
            }
        }
        catch (Exception e) {
            this.fCurrStatus = 32;
            throw e;
        }
    }

    public CharSequence getCurrName() throws Exception {
        return this.fCurrName;
    }

    public int getCurrStatus() throws Exception {
        return this.fCurrStatus;
    }

    public CharSequence getCurrValue() throws Exception {
        return this.fCurrValue;
    }

    public int getCurrDepth() throws Exception {
        return this.fCurrName.fObjectStack.size() / 2;
    }

    public boolean currNameEquals(CharSequence pName) {
        return HCharSeqUtil.equals(this.fCurrName, pName);
    }

    protected static boolean isNameChar(char pChar) {
        return pChar > '/' && pChar < '{';
    }

    protected void nextData(int pOffset) throws Exception {
        this.fCurrName.setStart(pOffset);
        this.fCurrStatus = this.fCurrName.searchNextName();
        if (this.fCurrStatus == 16) {
            this.fCurrValue = this.fValueParser.parseValue(this.fCurrName.fNextWord);
        }
    }

    protected int seekEndObject(int pOffset) throws Exception {
        CharSequence vSeq = this.fCurrName.getSubCharSequence();
        int vLen = vSeq.length();
        int vDeep = 0;
        block5: for (int vOffset = pOffset; vOffset < vLen; ++vOffset) {
            char vC = vSeq.charAt(vOffset);
            switch (vC) {
                case ')': {
                    if (vDeep == 0) {
                        return vOffset + 1;
                    }
                    --vDeep;
                    continue block5;
                }
                case '(': {
                    ++vDeep;
                    continue block5;
                }
                case '\'': {
                    while (++vOffset < vLen && ((vC = vSeq.charAt(vOffset)) != '\'' || vOffset + 1 != vLen && vSeq.charAt(vOffset + 1) == '\'')) {
                    }
                    continue block5;
                }
            }
        }
        throw new Exception("Parsing CDM failed, end object not found: " + vSeq);
    }

    protected int seekEndArray(int pOffset) throws Exception {
        CharSequence vSeq = this.fCurrName.getSubCharSequence();
        int vLen = vSeq.length();
        int vDeep = 0;
        block5: for (int vOffset = pOffset; vOffset < vLen; ++vOffset) {
            char vC = vSeq.charAt(vOffset);
            switch (vC) {
                case '-': {
                    if (vDeep == 0) {
                        return vOffset + 1;
                    }
                    --vDeep;
                    continue block5;
                }
                case '*': {
                    ++vDeep;
                    continue block5;
                }
                case '\'': {
                    while (++vOffset < vLen && ((vC = vSeq.charAt(vOffset)) != '\'' || vOffset + 1 != vLen && vSeq.charAt(vOffset + 1) == '\'')) {
                    }
                    continue block5;
                }
            }
        }
        throw new Exception("Parsing CDM failed, end array not found: " + vSeq);
    }

    public static class Value
    extends CharSeqSegment {
        protected int fNextWord = 0;
        protected StringBuilder fUnescapedValue = new StringBuilder();

        protected CharSequence parseValue(int pStart) {
            this.fStart = pStart;
            this.fLength = 0;
            int vLen = this.fSubCharSeq.length();
            boolean vUseUnescapedValue = false;
            for (int vEnd = this.fStart; vEnd < vLen; ++vEnd) {
                char vChar = this.fSubCharSeq.charAt(vEnd);
                switch (vChar) {
                    case '\'': {
                        if (vEnd + 1 < vLen && this.fSubCharSeq.charAt(vEnd + 1) == vChar) {
                            if (!vUseUnescapedValue) {
                                vUseUnescapedValue = true;
                                this.fUnescapedValue.setLength(0);
                                this.fUnescapedValue.append(this.fSubCharSeq, this.fStart, vEnd);
                            }
                            ++vEnd;
                            break;
                        }
                        this.fNextWord = vEnd + 1;
                        this.fLength = vEnd - this.fStart;
                        return vUseUnescapedValue ? this.fUnescapedValue : this;
                    }
                }
                if (!vUseUnescapedValue) continue;
                this.fUnescapedValue.append(vChar);
            }
            return null;
        }
    }

    public static class Name
    extends CharSeqSegment {
        protected int fNextWord = 0;
        protected HIntArrayList fObjectStack = new HIntArrayList(6);

        public void reset(CharSequence pSubCharSeq, int pStart, int pEnd) {
            super.reset(pSubCharSeq, pStart, pEnd);
            this.fObjectStack.clear();
        }

        protected int searchNextName() throws Exception {
            int vLen = this.fSubCharSeq.length();
            this.fLength = 0;
            while (this.fStart < vLen) {
                char vChar = this.fSubCharSeq.charAt(this.fStart);
                if (vChar == ')') {
                    this.fNextWord = this.fStart + 1;
                    int vStackLen = this.fObjectStack.size();
                    if (vStackLen == 0) {
                        throw new Exception("Parsing CDM failed, too many ) : " + this.fSubCharSeq);
                    }
                    this.fLength = this.fObjectStack.removeInt(--vStackLen);
                    this.fStart = this.fObjectStack.removeInt(--vStackLen);
                    return 8;
                }
                if (vChar == '(') {
                    this.fNextWord = this.fStart + 1;
                    this.fLength = 0;
                    this.fObjectStack.addInt(this.fStart);
                    this.fObjectStack.addInt(this.fLength);
                    return 4;
                }
                if (vChar == '\'') {
                    this.fNextWord = this.fStart + 1;
                    this.fLength = 0;
                    return 16;
                }
                if (vChar == '*') {
                    this.fNextWord = this.fStart + 1;
                    this.fLength = 0;
                    this.fObjectStack.addInt(this.fStart);
                    this.fObjectStack.addInt(this.fLength);
                    return 64;
                }
                if (vChar == '-') {
                    this.fNextWord = this.fStart + 1;
                    this.fLength = 0;
                    int vStackLen = this.fObjectStack.size();
                    if (vStackLen == 0) {
                        throw new Exception("Parsing CDM failed, too many - : " + this.fSubCharSeq);
                    }
                    this.fLength = this.fObjectStack.removeInt(--vStackLen);
                    this.fStart = this.fObjectStack.removeInt(--vStackLen);
                    return 128;
                }
                if (CdmParser.isNameChar(vChar)) break;
                ++this.fStart;
            }
            if (this.fStart < vLen) {
                int vEnd;
                for (vEnd = this.fStart + 1; vEnd < vLen && CdmParser.isNameChar(this.fSubCharSeq.charAt(vEnd)); ++vEnd) {
                }
                this.fLength = vEnd - this.fStart;
                if (this.fStart < vLen) {
                    this.fNextWord = vEnd;
                    while (this.fNextWord < vLen) {
                        char vChar = this.fSubCharSeq.charAt(this.fNextWord);
                        if (vChar == '(') {
                            ++this.fNextWord;
                            this.fObjectStack.addInt(this.fStart);
                            this.fObjectStack.addInt(this.fLength);
                            return 4;
                        }
                        if (vChar == '*') {
                            ++this.fNextWord;
                            this.fObjectStack.addInt(this.fStart);
                            this.fObjectStack.addInt(this.fLength);
                            return 64;
                        }
                        if (vChar == '\'') {
                            ++this.fNextWord;
                            return 16;
                        }
                        if (CdmParser.isNameChar(vChar)) {
                            throw new Exception("Character '" + vChar + "' not allowed at offset " + this.fNextWord + " : " + this.fSubCharSeq);
                        }
                        ++this.fNextWord;
                    }
                }
                throw new Exception("Characters not allowed at the end : " + this.fSubCharSeq);
            }
            if (this.fObjectStack.size() != 0) {
                throw new Exception("Parsing CDM failed, not enough ): " + this.fSubCharSeq);
            }
            return 2;
        }

        protected void rewindBeforeCurrName(boolean pIsObject) throws Exception {
            if (pIsObject) {
                int vSize = this.fObjectStack.size() - 1;
                this.fObjectStack.removeInt(vSize--);
                this.fObjectStack.removeInt(vSize);
            }
            this.fNextWord = this.getStart();
        }
    }
}

