/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.syntax.cdm;

import eu.scenari.fw.syntax.cdm.ICdmHandler;
import java.util.List;
import java.util.Map;

public class CdmSerializer
implements ICdmHandler {
    protected Appendable fAppendable;
    protected boolean fPreviousIsCoat = false;

    public static void serializeCdmObject(Object pSource, Appendable pAppendable) throws Exception {
        CdmSerializer.serializeCdmObject(pSource, "", new CdmSerializer(pAppendable));
    }

    protected static void serializeCdmObject(Object pSource, CharSequence pPropertyHolderName, CdmSerializer pSerializer) throws Exception {
        if (pSource == null) {
            return;
        }
        if (pSource instanceof CharSequence) {
            pSerializer.property(pPropertyHolderName, (CharSequence)pSource);
        } else if (pSource instanceof Map) {
            pSerializer.startObject(pPropertyHolderName);
            for (Map.Entry vEntry : ((Map)pSource).entrySet()) {
                CdmSerializer.serializeCdmObject(vEntry.getValue(), vEntry.getKey().toString(), pSerializer);
            }
            pSerializer.endObject(pPropertyHolderName);
        } else if (pSource instanceof List) {
            pSerializer.startArray(pPropertyHolderName);
            for (Object vChild : (List)pSource) {
                CdmSerializer.serializeCdmObject(vChild, "", pSerializer);
            }
            pSerializer.endArray(pPropertyHolderName);
        } else {
            pSerializer.property(pPropertyHolderName, pSource.toString());
        }
    }

    public CdmSerializer() {
        this.fAppendable = new StringBuilder();
    }

    public CdmSerializer(Appendable pAppendable) {
        this.fAppendable = pAppendable == null ? new StringBuilder() : pAppendable;
    }

    public Appendable getAppendable() {
        return this.fAppendable;
    }

    public void property(CharSequence pName, CharSequence pValue) throws Exception {
        if (pName.length() == 0) {
            if (this.fPreviousIsCoat) {
                this.fAppendable.append('.');
            }
        } else {
            this.fAppendable.append(pName);
        }
        this.fAppendable.append('\'');
        int l = pValue.length();
        for (int i = 0; i < l; ++i) {
            char vC = pValue.charAt(i);
            if (vC == '\'') {
                this.fAppendable.append('\'');
            }
            this.fAppendable.append(vC);
        }
        this.fAppendable.append('\'');
        this.fPreviousIsCoat = true;
    }

    public void startObject(CharSequence pName) throws Exception {
        this.fAppendable.append(pName);
        this.fAppendable.append('(');
        this.fPreviousIsCoat = false;
    }

    public void endObject(CharSequence pName) throws Exception {
        this.fAppendable.append(')');
        this.fPreviousIsCoat = false;
    }

    public void startArray(CharSequence pName) throws Exception {
        this.fAppendable.append(pName);
        this.fAppendable.append('*');
        this.fPreviousIsCoat = false;
    }

    public void endArray(CharSequence pName) throws Exception {
        this.fAppendable.append('-');
        this.fPreviousIsCoat = false;
    }
}

