/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.syntax.json;

import eu.scenari.fw.syntax.json.IJsonisable;
import java.io.IOException;

public class JsonSerializer {
    protected Appendable fAppendable;
    protected SerialStatus fCurrentStatus = SerialStatus.start;
    protected SerialStatus[] fStackStatus = new SerialStatus[10];
    protected int fStackStatusOffset = 0;
    protected boolean fNeedComma = false;

    public static void writeJsChar(char pChar, Appendable pAppendable) throws IOException {
        switch (pChar) {
            case '\"': {
                pAppendable.append("\\\"");
                break;
            }
            case '\\': {
                pAppendable.append("\\\\");
                break;
            }
            case '\n': {
                pAppendable.append("\\n");
                break;
            }
            case '\r': {
                break;
            }
            case '\t': {
                pAppendable.append("\\t");
                break;
            }
            default: {
                pAppendable.append(pChar);
            }
        }
    }

    public static boolean isEscapingNeeded(char pChar) throws IOException {
        switch (pChar) {
            case '\t': 
            case '\n': 
            case '\r': 
            case '\"': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    public static void writeJsString(CharSequence pChars, Appendable pAppendable) throws IOException {
        for (int i = 0; i < pChars.length(); ++i) {
            JsonSerializer.writeJsChar(pChars.charAt(i), pAppendable);
        }
    }

    public static void writeQuotedJsString(CharSequence pChars, Appendable pAppendable) throws IOException {
        pAppendable.append('\"');
        for (int i = 0; i < pChars.length(); ++i) {
            JsonSerializer.writeJsChar(pChars.charAt(i), pAppendable);
        }
        pAppendable.append('\"');
    }

    public static void writeJsKey(CharSequence pChars, Appendable pAppendable) throws IOException {
        JsonSerializer.writeQuotedJsString(pChars, pAppendable);
    }

    public JsonSerializer(Appendable pappendable) {
        this.fAppendable = pappendable;
    }

    public JsonSerializer startObject() throws Exception {
        switch (this.fCurrentStatus) {
            case key: 
            case array: {
                if (this.fNeedComma) {
                    this.fAppendable.append(',');
                    this.fNeedComma = false;
                }
            }
            case start: {
                this.fAppendable.append('{');
                break;
            }
            case object: {
                throw new Exception("JsonAppendable need key before.");
            }
            case closed: {
                throw new Exception("JsonAppendable closed");
            }
        }
        this.pushStatus(SerialStatus.object);
        return this;
    }

    public JsonSerializer startArray() throws Exception {
        switch (this.fCurrentStatus) {
            case array: {
                if (this.fNeedComma) {
                    this.fAppendable.append(',');
                }
            }
            case key: {
                this.fAppendable.append('[');
                break;
            }
            case start: {
                this.fAppendable.append('[');
                break;
            }
            case object: {
                throw new Exception("JsonAppendable need key before.");
            }
            case closed: {
                throw new Exception("JsonAppendable closed");
            }
        }
        this.pushStatus(SerialStatus.array);
        return this;
    }

    public JsonSerializer endObject() throws Exception {
        switch (this.fCurrentStatus) {
            case object: {
                break;
            }
            case start: {
                throw new Exception("JsonAppendable can't close object just after start.");
            }
            case array: {
                throw new Exception("JsonAppendable can't close object in current array.");
            }
            case key: {
                throw new Exception("JsonAppendable need value after key.");
            }
            case closed: {
                throw new Exception("JsonAppendable closed");
            }
        }
        this.fAppendable.append('}');
        this.popStatus();
        return this;
    }

    public JsonSerializer endArray() throws Exception {
        switch (this.fCurrentStatus) {
            case array: {
                break;
            }
            case start: {
                throw new Exception("JsonAppendable can't close array just after start.");
            }
            case object: {
                throw new Exception("JsonAppendable can't close array in current object.");
            }
            case key: {
                throw new Exception("JsonAppendable need value after key.");
            }
            case closed: {
                throw new Exception("JsonAppendable closed");
            }
        }
        this.fAppendable.append(']');
        this.popStatus();
        return this;
    }

    public JsonSerializer key(CharSequence pKey) throws Exception {
        switch (this.fCurrentStatus) {
            case object: {
                break;
            }
            case start: {
                throw new Exception("JsonAppendable can't write key just after start.");
            }
            case array: {
                throw new Exception("JsonAppendable can't write key in an array.");
            }
            case key: {
                throw new Exception("JsonAppendable can't write key after key.");
            }
            case closed: {
                throw new Exception("JsonAppendable closed");
            }
        }
        if (this.fNeedComma) {
            this.fAppendable.append(',');
            this.fNeedComma = false;
        }
        JsonSerializer.writeJsKey(pKey, this.fAppendable);
        this.fAppendable.append(':');
        this.fCurrentStatus = SerialStatus.key;
        return this;
    }

    public JsonSerializer valString(Object pValue) throws Exception {
        this.setContextForVal();
        if (pValue == null) {
            this.fAppendable.append("\"\"");
        } else {
            JsonSerializer.writeQuotedJsString(pValue.toString(), this.fAppendable);
        }
        return this;
    }

    public JsonSerializer valStringOrNull(Object pValue) throws Exception {
        this.setContextForVal();
        if (pValue == null) {
            this.fAppendable.append("null");
        } else {
            JsonSerializer.writeQuotedJsString(pValue.toString(), this.fAppendable);
        }
        return this;
    }

    public JsonSerializer valNull() throws Exception {
        this.setContextForVal();
        this.fAppendable.append("null");
        return this;
    }

    public JsonSerializer valBoolean(boolean pBoolean) throws Exception {
        this.setContextForVal();
        this.fAppendable.append(pBoolean ? "true" : "false");
        return this;
    }

    public JsonSerializer valNumber(double pDouble) throws Exception {
        this.setContextForVal();
        this.fAppendable.append(Double.toString(pDouble));
        return this;
    }

    public JsonSerializer valNumber(int pInt) throws Exception {
        this.setContextForVal();
        this.fAppendable.append(Integer.toString(pInt));
        return this;
    }

    public JsonSerializer valNumber(Number pNumber) throws Exception {
        this.setContextForVal();
        this.fAppendable.append(pNumber.toString());
        return this;
    }

    public JsonSerializer val(Object pObject) throws Exception {
        if (pObject == null) {
            this.valNull();
        } else if (pObject instanceof IJsonisable) {
            ((IJsonisable)pObject).writeJson(this);
        } else if (pObject instanceof Boolean) {
            this.valBoolean((Boolean)pObject);
        } else if (pObject instanceof Number) {
            this.valNumber((Number)pObject);
        } else {
            this.valString(pObject);
        }
        return this;
    }

    protected void setContextForVal() throws Exception {
        switch (this.fCurrentStatus) {
            case array: {
                if (this.fNeedComma) {
                    this.fAppendable.append(',');
                    break;
                }
                this.fNeedComma = true;
                break;
            }
            case key: {
                this.fCurrentStatus = this.fStackStatus[this.fStackStatusOffset];
                if (this.fNeedComma) break;
                this.fNeedComma = true;
                break;
            }
            case object: {
                throw new Exception("JsonAppendable can't write value before key object.");
            }
            case start: {
                throw new Exception("JsonAppendable can't write value just after start.");
            }
            case closed: {
                throw new Exception("JsonAppendable closed");
            }
        }
    }

    protected void popStatus() throws Exception {
        --this.fStackStatusOffset;
        if (this.fStackStatusOffset <= 0) {
            this.fCurrentStatus = SerialStatus.closed;
        } else {
            this.fCurrentStatus = this.fStackStatus[this.fStackStatusOffset];
            this.fNeedComma = true;
        }
    }

    protected void pushStatus(SerialStatus pStatus) throws Exception {
        ++this.fStackStatusOffset;
        if (this.fStackStatus.length == this.fStackStatusOffset) {
            SerialStatus[] vNew = new SerialStatus[this.fStackStatusOffset * 2];
            System.arraycopy(this.fStackStatus, 0, vNew, 0, this.fStackStatusOffset);
            this.fStackStatus = vNew;
        }
        this.fStackStatus[this.fStackStatusOffset] = pStatus;
        this.fCurrentStatus = pStatus;
        this.fNeedComma = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SerialStatus {
        start,
        key,
        object,
        array,
        closed;

    }
}

