/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.util.collections;

import eu.scenari.fw.util.collections.IteratorBufferedNextBase;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public static final Iterator emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static final <E> Iterator<E> newSingletonIterator(E pEntry) {
        return new SingletonIterator<E>(pEntry);
    }

    public static final <E> Iterator<E> newExcludeSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2, Comparator<E> pComparator) {
        return new ExcludeSortedIterator<E>(pIt1, pIt2, pComparator);
    }

    public static final <E> Iterator<E> newIntersectSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2, Comparator<E> pComparator) {
        return new IntersectSortedIterator<E>(pIt1, pIt2, pComparator);
    }

    public static final <E> Iterator<E> newUnionSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2, Comparator<E> pComparator) {
        return new UnionSortedIterator<E>(pIt1, pIt2, pComparator);
    }

    public static final <E> Iterator<E> newUnionSortedIterator(List<Iterator<E>> pIterators, Comparator<E> pComparator) {
        int vCountIt = pIterators.size();
        if (vCountIt > 2) {
            return new UnionSortedNIterator<E>(pIterators, pComparator);
        }
        if (vCountIt == 2) {
            return new UnionSortedIterator<E>(pIterators.get(0), pIterators.get(1), pComparator);
        }
        if (vCountIt == 1) {
            return pIterators.get(0);
        }
        return CollectionUtil.emptyIterator();
    }

    public static <E> int binarySearchWithHole(List<E> pList, E pKey) {
        int vHigh;
        int vLow = 0;
        for (vHigh = pList.size() - 1; vHigh >= vLow && pList.get(vHigh) == null; --vHigh) {
        }
        while (vHigh >= vLow && pList.get(vLow) == null) {
            ++vLow;
        }
        while (vLow <= vHigh) {
            int vMid;
            int vMidNotNull = vMid = vLow + vHigh >> 1;
            E vMidVal = pList.get(vMidNotNull);
            while (vMidVal == null) {
                if (vMidNotNull <= vHigh) {
                    vMidVal = pList.get(++vMidNotNull);
                    continue;
                }
                vHigh = vMid - 1;
                break;
            }
            if (vMidVal == null) continue;
            int cmp = ((Comparable)vMidVal).compareTo(pKey);
            if (cmp < 0) {
                vLow = vMidNotNull + 1;
                continue;
            }
            if (cmp > 0) {
                vHigh = vMid - 1;
                continue;
            }
            return vMidNotNull;
        }
        return -(vLow + 1);
    }

    public static <E> int binarySearchWithHole(List<E> pList, E pKey, Comparator<E> pComparator) {
        int vHigh;
        if (pComparator == null) {
            return CollectionUtil.binarySearchWithHole(pList, pKey);
        }
        int vLow = 0;
        for (vHigh = pList.size() - 1; vHigh >= vLow && pList.get(vHigh) == null; --vHigh) {
        }
        while (vHigh >= vLow && pList.get(vLow) == null) {
            ++vLow;
        }
        while (vLow <= vHigh) {
            int vMid;
            int vMidNotNull = vMid = vLow + vHigh >> 1;
            E vMidVal = pList.get(vMidNotNull);
            while (vMidVal == null) {
                if (vMidNotNull <= vHigh) {
                    vMidVal = pList.get(++vMidNotNull);
                    continue;
                }
                vHigh = vMid - 1;
                break;
            }
            if (vMidVal == null) continue;
            int cmp = pComparator.compare(vMidVal, pKey);
            if (cmp < 0) {
                vLow = vMidNotNull + 1;
                continue;
            }
            if (cmp > 0) {
                vHigh = vMid - 1;
                continue;
            }
            return vMidNotNull;
        }
        return -(vLow + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyIterator<E>
    extends IteratorBufferedNextBase<E> {
        @Override
        public boolean hasNext() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingletonIterator<E>
    extends IteratorBufferedNextBase<E> {
        public SingletonIterator(E pSingleton) {
            this.fNext = pSingleton;
        }

        @Override
        public boolean hasNext() {
            return this.fNext != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcludeSortedIterator<E>
    extends IteratorBufferedNextBase<E> {
        protected Comparator<E> fComparator = null;
        protected Iterator<E> fIt1 = null;
        protected Iterator<E> fIt2 = null;
        protected E fNextIt1 = null;
        protected E fNextIt2 = null;

        public ExcludeSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2) {
            this.fIt1 = pIt1;
            this.fIt2 = pIt2;
        }

        public ExcludeSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2, Comparator<E> pComparator) {
            this.fIt1 = pIt1;
            this.fIt2 = pIt2;
            this.fComparator = pComparator;
        }

        @Override
        public boolean hasNext() {
            if (this.fNext != null) {
                return true;
            }
            while (true) {
                if (this.fNextIt1 == null && this.fIt1.hasNext()) {
                    this.fNextIt1 = this.fIt1.next();
                }
                if (this.fNextIt2 == null && this.fIt2.hasNext()) {
                    this.fNextIt2 = this.fIt2.next();
                }
                if (this.fNextIt1 == null) {
                    return false;
                }
                if (this.fNextIt2 == null) {
                    this.fNext = this.fNextIt1;
                    this.fNextIt1 = null;
                    return true;
                }
                int vComp = this.fComparator != null ? this.fComparator.compare(this.fNextIt1, this.fNextIt2) : ((Comparable)this.fNextIt1).compareTo(this.fNextIt2);
                if (vComp == 0) {
                    this.fNextIt1 = null;
                    this.fNextIt2 = null;
                    continue;
                }
                if (vComp < 0) {
                    this.fNext = this.fNextIt1;
                    this.fNextIt1 = null;
                    return true;
                }
                this.fNextIt2 = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntersectSortedIterator<E>
    extends IteratorBufferedNextBase<E> {
        protected Comparator<E> fComparator = null;
        protected Iterator<E> fIt1 = null;
        protected Iterator<E> fIt2 = null;
        protected E fNextIt1 = null;
        protected E fNextIt2 = null;

        public IntersectSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2) {
            this.fIt1 = pIt1;
            this.fIt2 = pIt2;
        }

        public IntersectSortedIterator(Iterator<E> pIt1, Iterator<E> pIt2, Comparator<E> pComparator) {
            this.fIt1 = pIt1;
            this.fIt2 = pIt2;
            this.fComparator = pComparator;
        }

        @Override
        public boolean hasNext() {
            if (this.fNext != null) {
                return true;
            }
            while (true) {
                if (this.fNextIt1 == null && this.fIt1.hasNext()) {
                    this.fNextIt1 = this.fIt1.next();
                }
                if (this.fNextIt2 == null && this.fIt2.hasNext()) {
                    this.fNextIt2 = this.fIt2.next();
                }
                if (this.fNextIt1 == null || this.fNextIt2 == null) {
                    return false;
                }
                int vComp = this.fComparator != null ? this.fComparator.compare(this.fNextIt1, this.fNextIt2) : ((Comparable)this.fNextIt1).compareTo(this.fNextIt2);
                if (vComp == 0) {
                    this.fNext = this.fNextIt1;
                    this.fNextIt1 = null;
                    this.fNextIt2 = null;
                    return true;
                }
                if (vComp < 0) {
                    this.fNextIt1 = null;
                    continue;
                }
                this.fNextIt2 = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionSortedNIterator<E>
    extends IteratorBufferedNextBase<E> {
        protected Comparator fComparator = null;
        protected List<Iterator<E>> fIterators = null;
        protected E[] fNexts = null;
        protected boolean[] fResults = null;
        protected int fNextIdx = -1;

        public UnionSortedNIterator(List<Iterator<E>> pIterators) {
            this.fIterators = pIterators;
            this.fComparator = null;
        }

        public UnionSortedNIterator(List<Iterator<E>> pIterators, Comparator<E> pComparator) {
            this.fIterators = pIterators;
            this.fComparator = pComparator;
        }

        protected void xInit() {
            this.fNexts = new Object[this.fIterators.size()];
            this.fResults = new boolean[this.fNexts.length];
            this.fNext = null;
            if (this.fResults.length > 0) {
                int vCurrentNextIdx;
                for (int i = 0; i < this.fNexts.length; ++i) {
                    try {
                        this.fNexts[i] = this.fIterators.get(i).next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        this.fNexts[i] = null;
                    }
                }
                if (this.fNexts[0] != null) {
                    this.fResults[0] = true;
                    vCurrentNextIdx = 0;
                } else {
                    this.fResults[0] = false;
                    vCurrentNextIdx = -1;
                }
                for (int i = 1; i < this.fNexts.length; ++i) {
                    int vComp;
                    if (vCurrentNextIdx < 0 || this.fNexts[vCurrentNextIdx] == null) {
                        this.fResults[i] = this.fNexts[i] != null;
                        vCurrentNextIdx = i;
                        continue;
                    }
                    if (this.fNexts[i] == null) {
                        this.fResults[i] = false;
                        continue;
                    }
                    if (this.fComparator != null) {
                        vComp = this.fComparator.compare(this.fNexts[vCurrentNextIdx], this.fNexts[i]);
                        while (vComp == 0) {
                            try {
                                this.fNexts[i] = this.fIterators.get(i).next();
                                vComp = this.fComparator.compare(this.fNexts[vCurrentNextIdx], this.fNexts[i]);
                            }
                            catch (NoSuchElementException e) {
                                this.fNexts[i] = null;
                                vComp = -1;
                            }
                        }
                    } else {
                        vComp = ((Comparable)this.fNexts[vCurrentNextIdx]).compareTo(this.fNexts[i]);
                        while (vComp == 0) {
                            try {
                                this.fNexts[i] = this.fIterators.get(i).next();
                                vComp = ((Comparable)this.fNexts[vCurrentNextIdx]).compareTo(this.fNexts[i]);
                            }
                            catch (NoSuchElementException e) {
                                this.fNexts[i] = null;
                                vComp = -1;
                            }
                        }
                    }
                    boolean bl = this.fResults[i] = vComp >= 0;
                    if (!this.fResults[i]) continue;
                    vCurrentNextIdx = i;
                }
                if (vCurrentNextIdx >= 0) {
                    this.fNextIdx = vCurrentNextIdx;
                    this.fNext = this.fNexts[vCurrentNextIdx];
                } else {
                    this.fNext = null;
                }
                if (this.fNext == null) {
                    this.fNextIdx = -2;
                }
            }
        }

        @Override
        public boolean hasNext() {
            int vCurrentNextIdx;
            if (this.fNextIdx < 0) {
                if (this.fNextIdx == -1) {
                    this.xInit();
                }
                if (this.fNextIdx == -2) {
                    return false;
                }
            }
            if (this.fNext != null) {
                return true;
            }
            try {
                this.fNexts[this.fNextIdx] = this.fIterators.get(this.fNextIdx).next();
            }
            catch (NoSuchElementException e) {
                this.fNexts[this.fNextIdx] = null;
            }
            for (vCurrentNextIdx = this.fNextIdx - 1; vCurrentNextIdx >= 0 && !this.fResults[vCurrentNextIdx]; --vCurrentNextIdx) {
            }
            if (this.fNexts[this.fNextIdx] == null) {
                this.fResults[this.fNextIdx] = false;
            } else if (vCurrentNextIdx < 0) {
                this.fResults[this.fNextIdx] = true;
                vCurrentNextIdx = this.fNextIdx;
            } else {
                int vComp;
                if (this.fComparator != null) {
                    vComp = this.fComparator.compare(this.fNexts[vCurrentNextIdx], this.fNexts[this.fNextIdx]);
                    while (vComp == 0) {
                        try {
                            this.fNexts[this.fNextIdx] = this.fIterators.get(this.fNextIdx).next();
                            vComp = this.fComparator.compare(this.fNexts[vCurrentNextIdx], this.fNexts[this.fNextIdx]);
                        }
                        catch (NoSuchElementException e) {
                            this.fNexts[this.fNextIdx] = null;
                            vComp = -1;
                        }
                    }
                } else {
                    vComp = ((Comparable)this.fNexts[vCurrentNextIdx]).compareTo(this.fNexts[this.fNextIdx]);
                    while (vComp == 0) {
                        try {
                            this.fNexts[this.fNextIdx] = this.fIterators.get(this.fNextIdx).next();
                            vComp = ((Comparable)this.fNexts[vCurrentNextIdx]).compareTo(this.fNexts[this.fNextIdx]);
                        }
                        catch (NoSuchElementException e) {
                            this.fNexts[this.fNextIdx] = null;
                            vComp = -1;
                        }
                    }
                }
                boolean bl = this.fResults[this.fNextIdx] = vComp >= 0;
                if (this.fResults[this.fNextIdx]) {
                    vCurrentNextIdx = this.fNextIdx;
                }
            }
            for (int i = this.fNextIdx + 1; i < this.fNexts.length; ++i) {
                int vComp;
                if (vCurrentNextIdx < 0 || this.fNexts[vCurrentNextIdx] == null) {
                    this.fResults[i] = this.fNexts[i] != null;
                    vCurrentNextIdx = i;
                    continue;
                }
                if (this.fNexts[i] == null) {
                    this.fResults[i] = false;
                    continue;
                }
                if (this.fComparator != null) {
                    vComp = this.fComparator.compare(this.fNexts[vCurrentNextIdx], this.fNexts[i]);
                    while (vComp == 0) {
                        try {
                            this.fNexts[i] = this.fIterators.get(i).next();
                            vComp = this.fComparator.compare(this.fNexts[vCurrentNextIdx], this.fNexts[i]);
                        }
                        catch (NoSuchElementException e) {
                            this.fNexts[i] = null;
                            vComp = -1;
                        }
                    }
                } else {
                    vComp = ((Comparable)this.fNexts[vCurrentNextIdx]).compareTo(this.fNexts[i]);
                    while (vComp == 0) {
                        try {
                            this.fNexts[i] = this.fIterators.get(i).next();
                            vComp = ((Comparable)this.fNexts[vCurrentNextIdx]).compareTo(this.fNexts[i]);
                        }
                        catch (NoSuchElementException e) {
                            this.fNexts[i] = null;
                            vComp = -1;
                        }
                    }
                }
                boolean bl = this.fResults[i] = vComp >= 0;
                if (!this.fResults[i]) continue;
                vCurrentNextIdx = i;
            }
            if (vCurrentNextIdx >= 0) {
                this.fNextIdx = vCurrentNextIdx;
                this.fNext = this.fNexts[vCurrentNextIdx];
            } else {
                this.fNext = null;
            }
            if (this.fNext == null) {
                this.fNextIdx = -2;
            }
            return this.fNext != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionSortedIterator<E>
    extends IteratorBufferedNextBase<E> {
        protected Comparator fComparator = null;
        protected Iterator<E> fIt1 = null;
        protected Iterator<E> fIt2 = null;
        protected E fNextIt1 = null;
        protected E fNextIt2 = null;

        public UnionSortedIterator(Iterator pIt1, Iterator pIt2) {
            this.fIt1 = pIt1;
            this.fIt2 = pIt2;
        }

        public UnionSortedIterator(Iterator pIt1, Iterator pIt2, Comparator<E> pComparator) {
            this.fIt1 = pIt1;
            this.fIt2 = pIt2;
            this.fComparator = pComparator;
        }

        @Override
        public boolean hasNext() {
            if (this.fNext != null) {
                return true;
            }
            if (this.fNextIt1 == null && this.fIt1.hasNext()) {
                this.fNextIt1 = this.fIt1.next();
            }
            if (this.fNextIt2 == null && this.fIt2.hasNext()) {
                this.fNextIt2 = this.fIt2.next();
            }
            if (this.fNextIt1 == null) {
                if (this.fNextIt2 == null) {
                    return false;
                }
                this.fNext = this.fNextIt2;
                this.fNextIt2 = null;
            } else if (this.fNextIt2 == null) {
                this.fNext = this.fNextIt1;
                this.fNextIt1 = null;
            } else {
                int vComp;
                int n = vComp = this.fComparator != null ? this.fComparator.compare(this.fNextIt1, this.fNextIt2) : ((Comparable)this.fNextIt1).compareTo(this.fNextIt2);
                if (vComp == 0) {
                    this.fNext = this.fNextIt1;
                    this.fNextIt1 = null;
                    this.fNextIt2 = null;
                } else if (vComp < 0) {
                    this.fNext = this.fNextIt1;
                    this.fNextIt1 = null;
                } else {
                    this.fNext = this.fNextIt2;
                    this.fNextIt2 = null;
                }
            }
            return true;
        }
    }
}

