/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.util.collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouplesIntObject<V> {
    protected int[] fKeys = null;
    protected V[] fValues = null;
    protected int fNbElem = 0;

    public CouplesIntObject() {
        this(32);
    }

    public CouplesIntObject(int pCapacity) {
        this.fKeys = new int[pCapacity];
        this.fValues = new Object[pCapacity];
    }

    public void addCouple(int pKey, V pValue) {
        int vPos = this.xFindIndexInsert(pKey);
        this.xAdd(vPos, pKey, pValue);
    }

    public boolean addCoupleIfNotExist(int pKey, V pValue) {
        int vIdx;
        for (int vNext = vIdx = this.xFindIndexInsert(pKey); vNext > 0 && vNext < this.fNbElem && this.fKeys[vNext] == pKey; ++vNext) {
            V vVal = this.fValues[vNext];
            if (vVal != pValue && (vVal == null || !vVal.equals(pValue))) continue;
            return false;
        }
        for (int vPrev = vIdx - 1; vPrev > 0 && vPrev < this.fNbElem && this.fKeys[vPrev] == pKey; --vPrev) {
            V vVal = this.fValues[vPrev];
            if (vVal != pValue && (vVal == null || !vVal.equals(pValue))) continue;
            return false;
        }
        this.xAdd(vIdx, pKey, pValue);
        return true;
    }

    protected void xAdd(int pIndex, int pKey, V pValue) {
        if (this.fNbElem == this.fKeys.length) {
            int vNewSize = this.fKeys.length * 2;
            int[] vNewKeys = new int[vNewSize];
            Object[] vNewValues = new Object[vNewSize];
            if (pIndex > 0) {
                System.arraycopy(this.fKeys, 0, vNewKeys, 0, pIndex);
                System.arraycopy(this.fValues, 0, vNewValues, 0, pIndex);
            }
            vNewKeys[pIndex] = pKey;
            vNewValues[pIndex] = pValue;
            int vLen = this.fNbElem - pIndex;
            if (vLen > 0) {
                System.arraycopy(this.fKeys, pIndex, vNewKeys, pIndex + 1, vLen);
                System.arraycopy(this.fValues, pIndex, vNewValues, pIndex + 1, vLen);
            }
            this.fKeys = vNewKeys;
            this.fValues = vNewValues;
        } else {
            int vLen = this.fNbElem - pIndex;
            if (vLen > 0) {
                System.arraycopy(this.fKeys, pIndex, this.fKeys, pIndex + 1, vLen);
                System.arraycopy(this.fValues, pIndex, this.fValues, pIndex + 1, vLen);
            }
            this.fKeys[pIndex] = pKey;
            this.fValues[pIndex] = pValue;
        }
        ++this.fNbElem;
    }

    public boolean removeByIndex(int pIndex) {
        if (pIndex < 0 || pIndex >= this.fNbElem) {
            return false;
        }
        int vLen = this.fNbElem - pIndex - 1;
        if (vLen > 0) {
            System.arraycopy(this.fKeys, pIndex + 1, this.fKeys, pIndex, vLen);
            System.arraycopy(this.fValues, pIndex + 1, this.fValues, pIndex, vLen);
        }
        --this.fNbElem;
        this.fKeys[this.fNbElem] = 0;
        this.fValues[this.fNbElem] = null;
        return true;
    }

    public int removeByKeyAndValue(int pKey, V pValue) {
        int vIndex = this.getFirstIndexOfKey(pKey);
        int vNbRemove = 0;
        while (vIndex >= 0) {
            V vObj = this.fValues[vIndex];
            if (vObj == pValue || vObj != null && vObj.equals(pValue)) {
                int vLen = this.fNbElem - vIndex - 1;
                if (vLen > 0) {
                    System.arraycopy(this.fKeys, vIndex + 1, this.fKeys, vIndex, vLen);
                    System.arraycopy(this.fValues, vIndex + 1, this.fValues, vIndex, vLen);
                }
                --this.fNbElem;
                this.fKeys[this.fNbElem] = 0;
                this.fValues[this.fNbElem] = null;
                ++vNbRemove;
            } else {
                ++vIndex;
            }
            if (vIndex < this.fNbElem && this.fKeys[vIndex] == pKey) continue;
            break;
        }
        return vNbRemove;
    }

    public V getValueByKey(int pKey) {
        int vMin = 0;
        int vMax = this.fNbElem - 1;
        while (vMin <= vMax) {
            int vMid = vMin + vMax >> 1;
            int vMidVal = this.fKeys[vMid];
            if (vMidVal < pKey) {
                vMin = vMid + 1;
                continue;
            }
            if (vMidVal > pKey) {
                vMax = vMid - 1;
                continue;
            }
            return this.fValues[vMid];
        }
        return null;
    }

    public Object[] getValuesByKey(int pKey) {
        int vIndexFirst = 0;
        int vIndexLast = 0;
        int vMin = 0;
        int vMax = this.fNbElem - 1;
        while (vMin <= vMax) {
            int vMid = vMin + vMax >> 1;
            int vMidVal = this.fKeys[vMid];
            if (vMidVal < pKey) {
                vMin = vMid + 1;
                continue;
            }
            if (vMidVal > pKey) {
                vMax = vMid - 1;
                continue;
            }
            for (vIndexFirst = vMid; vIndexFirst > 0 && this.fKeys[vIndexFirst - 1] == pKey; --vIndexFirst) {
            }
            vMax = this.fNbElem - 1;
            for (vIndexLast = vMid; vIndexLast < vMax && this.fKeys[vIndexLast + 1] == pKey; ++vIndexLast) {
            }
            vMax = vIndexLast - vIndexFirst + 1;
            Object[] vResult = new Object[vMax];
            System.arraycopy(this.fValues, vIndexFirst, vResult, 0, vMax);
            return vResult;
        }
        return null;
    }

    public int getFirstIndexOfKey(int pKey) {
        int vMin = 0;
        int vMax = this.fNbElem - 1;
        while (vMin <= vMax) {
            int vMid = vMin + vMax >> 1;
            int vMidVal = this.fKeys[vMid];
            if (vMidVal < pKey) {
                vMin = vMid + 1;
                continue;
            }
            if (vMidVal > pKey) {
                vMax = vMid - 1;
                continue;
            }
            while (vMid > 0 && this.fKeys[vMid - 1] == pKey) {
                --vMid;
            }
            return vMid;
        }
        return -1;
    }

    public V getValueByIndex(int pIndex) {
        if (pIndex < 0 || pIndex >= this.fNbElem) {
            return null;
        }
        return this.fValues[pIndex];
    }

    public int getKeyByIndex(int pIndex) {
        if (pIndex < 0 || pIndex >= this.fNbElem) {
            return -1;
        }
        return this.fKeys[pIndex];
    }

    public V getValueByIndexIfKeyMatch(int pIndex, int pKey) {
        if (pIndex < 0 || pIndex >= this.fNbElem) {
            return null;
        }
        return this.fKeys[pIndex] == pKey ? (V)this.fValues[pIndex] : null;
    }

    protected int xFindIndexInsert(int pKey) {
        int vMin = 0;
        int vMax = this.fNbElem - 1;
        while (vMin <= vMax) {
            int vMid = vMin + vMax >> 1;
            int vMidVal = this.fKeys[vMid];
            if (vMidVal < pKey) {
                vMin = vMid + 1;
                continue;
            }
            if (vMidVal > pKey) {
                vMax = vMid - 1;
                continue;
            }
            return vMid;
        }
        return vMin;
    }
}

