/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.util.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredBag<E> {
    protected volatile FrozenList<E> fEntries = null;

    public synchronized void add(E pEntry) {
        Object[] vNewArray;
        FrozenList<E> vOldEntries = this.fEntries;
        if (vOldEntries != null) {
            int vOldLen = vOldEntries.size();
            vNewArray = new Object[vOldLen + 1];
            System.arraycopy(vOldEntries.fArray, 0, vNewArray, 0, vOldLen);
            vNewArray[vOldLen] = pEntry;
        } else {
            vNewArray = new Object[]{pEntry};
        }
        this.fEntries = new FrozenList<Object>(vNewArray);
    }

    public synchronized boolean remove(E pEntry) {
        FrozenList<E> vOldEntries = this.fEntries;
        if (vOldEntries == null) {
            return false;
        }
        E[] vOldArray = vOldEntries.fArray;
        for (int i = 0; i < vOldArray.length; ++i) {
            if (!vOldArray[i].equals(pEntry)) continue;
            int vNewLen = vOldArray.length - 1;
            Object[] vNewArray = new Object[vNewLen];
            if (i > 0) {
                System.arraycopy(vOldArray, 0, vNewArray, 0, i);
            }
            if (i < vNewLen) {
                System.arraycopy(vOldArray, i + 1, vNewArray, 1, vNewLen - i);
            }
            this.fEntries = new FrozenList<Object>(vNewArray);
            return true;
        }
        return false;
    }

    public List<E> asFrozenList() {
        FrozenList<E> vEntries = this.fEntries;
        if (vEntries != null) {
            return vEntries;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FrozenList<E>
    extends AbstractList<E>
    implements RandomAccess {
        protected final E[] fArray;

        protected FrozenList(E[] pArray) {
            if (pArray == null) {
                throw new NullPointerException();
            }
            this.fArray = pArray;
        }

        @Override
        public int size() {
            return this.fArray.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.fArray.clone();
        }

        @Override
        public <T> T[] toArray(T[] pArray) {
            int size = this.size();
            if (pArray.length < size) {
                pArray = (Object[])Array.newInstance(pArray.getClass().getComponentType(), size);
            }
            System.arraycopy(this.fArray, 0, pArray, 0, size);
            if (pArray.length > size) {
                pArray[size] = null;
            }
            return pArray;
        }

        @Override
        public E get(int pIndex) {
            return this.fArray[pIndex];
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.fArray.length; ++i) {
                    if (this.fArray[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.fArray.length; ++i) {
                    if (!o.equals(this.fArray[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }
}

