/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.fw.util.net;

import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class IpServerBase
implements Runnable {
    private volatile int fStop = 0;
    private int fPort = 0;
    private int fBackLog = 0;
    private InetAddress fHost = null;
    private Thread fThread = null;
    public static TracePoint sTrace = TraceMgr.register(IpServerBase.class.getName(), "");

    public IpServerBase() {
    }

    public IpServerBase(int pPort) {
        this.fPort = pPort;
        try {
            this.fHost = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        this.startServer(true);
    }

    public IpServerBase(String pHost, int pPort) {
        try {
            this.fHost = InetAddress.getByName(pHost);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        this.fPort = pPort;
        this.startServer(true);
    }

    public String getHost() {
        return this.fHost.toString();
    }

    public int getPort() {
        return this.fPort;
    }

    public void setPort(int pPort) throws Exception {
        if (this.fThread != null && this.fStop == 0) {
            throw LogMgr.newException("Impossible de modifier le port lorsque le serveur est lanc\u00e9.", new String[0]);
        }
        this.fPort = pPort;
    }

    public void setHost(String pHost) throws Exception {
        if (this.fThread != null && this.fStop == 0) {
            throw LogMgr.newException("Impossible de modifier le port lorsque le serveur est lanc\u00e9.", new String[0]);
        }
        this.fHost = InetAddress.getByName(pHost);
    }

    public void stopServer() {
        this.fStop = 1;
    }

    public void startServer(boolean pDaemonMode) {
        while (this.fThread != null && this.fThread.isAlive()) {
            this.fStop = 1;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fStop = 0;
        this.fThread = new Thread(this);
        this.fThread.setDaemon(pDaemonMode);
        this.fThread.start();
    }

    public void startServerInCurrentThread() {
        while (this.fThread != null && this.fThread.isAlive()) {
            this.fStop = 1;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fStop = 0;
        this.fThread = Thread.currentThread();
        this.run();
    }

    public void run() {
        ServerSocket vServerSocket = null;
        Socket vClientSocket = null;
        try {
            vServerSocket = new ServerSocket(this.fPort, this.fBackLog, this.fHost);
            vServerSocket.setSoTimeout(3000);
            if (sTrace.isEnabled()) {
                LogMgr.publishTrace("SERVER " + this.fHost + ":" + this.fPort + ": waiting for connection", new String[0]);
            }
            while (this.fStop == 0) {
                try {
                    vClientSocket = vServerSocket.accept();
                    if (sTrace.isEnabled()) {
                        LogMgr.publishTrace("SERVER " + this.fHost + ":" + this.fPort + ": got a connection...", new String[0]);
                    }
                    this.xTreatConnection(vClientSocket);
                }
                catch (InterruptedIOException e) {}
            }
            vServerSocket.close();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }

    protected abstract void xTreatConnection(Socket var1);
}

