/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.dataformprim;

import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateFormatter {
    protected static DatatypeFactory sDataTypeFactory = null;

    public static String formatDate(String pDate, String pFormat, String pLocale, String pResultIfNull, String pResultIfWrong) {
        if (pDate == null || pDate.length() == 0) {
            return pResultIfNull;
        }
        try {
            Locale vLocale = DateFormatter.getLocale(pLocale);
            XMLGregorianCalendar vXmlDate = sDataTypeFactory.newXMLGregorianCalendar(pDate);
            Date vDate = vXmlDate.toGregorianCalendar(null, vLocale, null).getTime();
            SimpleDateFormat vFormatter = new SimpleDateFormat(pFormat, vLocale);
            return vFormatter.format(vDate);
        }
        catch (IllegalArgumentException e) {
            return pResultIfWrong;
        }
    }

    protected static Locale getLocale(String pDef) {
        if (pDef == null || pDef.length() == 0) {
            return Locale.getDefault();
        }
        try {
            String vLang = pDef;
            String vCountry = "";
            String vVariant = "";
            int vCountrySep = pDef.indexOf(45);
            if (vCountrySep > 0) {
                vCountry = vLang.substring(vCountrySep + 1);
                vLang = vLang.substring(0, vCountrySep);
                int vVariantSep = vCountry.indexOf(45);
                if (vVariantSep > 0) {
                    vVariant = vCountry.substring(vVariantSep + 1);
                    vCountry = vCountry.substring(0, vVariantSep);
                }
            }
            return new Locale(vLang, vCountry, vVariant);
        }
        catch (Exception e) {
            LogMgr.publishException((Throwable)e, "Parse Locale failed : " + pDef, ILogMsg.LogType.Info, new String[0]);
            return Locale.getDefault();
        }
    }

    static {
        try {
            sDataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }
}

