/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.odstyle;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.agent.IWAgentComputor;
import com.scenari.m.co.context.IHContextBuffers;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.ge.agent.IWADialogExport;
import com.scenari.m.ge.agent.pages.HDialogPages;
import com.scenari.m.ge.generator.IDynamicFile;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.m.ge.pages.BasePage;
import com.scenari.s.co.transform.oo.OdFile;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.s.fw.util.xml.HXmlParserAttributes;
import com.scenari.serializer.ISerializerHandler;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.Serializer;
import com.scenari.xerces.serialize.SerializerFactory;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.fw.stream.chars.WriterClob;
import eu.scenari.modeling.odstyle.OdStyle;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class OdBlenderPage
extends BasePage {
    public static final String PREFIX_SCOD = "scod";
    public static final String NS_SCOD = "scenari.eu:openDocumentExtension:1.0";
    protected String fPathOdStyle = null;
    protected OdBlenderContentHandler fOdContentHandler;

    public ContentHandler init(String pUrn, IGenerator pGenerator, Attributes pAttributes) throws Exception {
        super.init(pUrn, pGenerator, pAttributes);
        this.fPathOdStyle = pAttributes.getValue("odStylePath");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void producePage(IWADialogExport pDialogPage) throws Exception {
        if (!(pDialogPage instanceof HDialogPages)) {
            return;
        }
        IDynamicFile vPageToBuild = pDialogPage.getResultFile();
        HDialogPages vDialogPage = (HDialogPages)pDialogPage;
        WriterClob vBuf = new WriterClob();
        ZipOutputStream vZipOutputStream = null;
        OutputStream vStream = null;
        OdBlenderContentHandler vHandler = new OdBlenderContentHandler(vDialogPage);
        try {
            this.fGenerator.wSetCurrentPubFile(null);
            this.fGenerator.wSetCurrentDestUri(vPageToBuild.getDestUri());
            this.fGenerator.wSetCurrentDialog(pDialogPage);
            IGenerator.IXxxUri vOdStyleUri = this.fGenerator.resolveXxxPath(this.fPathOdStyle, pDialogPage, pDialogPage.hGetAgent());
            ISrcNode vOdStyleSrc = this.fGenerator.getSourceFromXxxUri(vOdStyleUri, pDialogPage);
            vHandler.initOdStyle(vOdStyleSrc);
            XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            try {
                vXmlReader.setContentHandler(vHandler);
                vDialogPage.hGetPageCourante().hGetZone("mainZone").writeValue(vBuf, pDialogPage, pDialogPage.hGetAgent(), pDialogPage.hGetParam());
                vXmlReader.parse(new InputSource(vBuf.getReader(false)));
            }
            finally {
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            }
            vStream = vPageToBuild.getDestFile().newOutputStream(false);
            vZipOutputStream = new ZipOutputStream(vStream);
            vHandler.export(vZipOutputStream);
            vHandler.close();
        }
        finally {
            vBuf.closeStream();
            if (vZipOutputStream != null) {
                try {
                    vZipOutputStream.close();
                }
                catch (Exception e) {
                    vStream.close();
                    throw e;
                }
            }
            vHandler.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OdBlenderContentHandler
    extends DefaultHandler2
    implements ISerializerHandler {
        protected OdFile fOdFile = new OdFile();
        protected OdStyle fOdStyle = new OdStyle();
        protected HDialogPages fDialog;
        protected Element fRootStyles = null;
        protected Element fRootAutoStyleStyles = null;
        protected Element fRootMasterPages = null;
        protected Element fRootAutoStyleContent = null;
        protected Element fRootScriptsContent = null;
        protected Map<String, StyleEntry> fStyleEntries = new HashMap<String, StyleEntry>(128);
        protected Map<String, MasterPageEntry> fMasterPagesEntries = new HashMap<String, MasterPageEntry>(12);
        protected Map<String, ResEntry> fPicturesFromOdStyle = new HashMap<String, ResEntry>();
        protected Map<String, ResEntry> fPicturesFromDatas = new HashMap<String, ResEntry>();
        protected Map<String, IncludeOdEntry> fObjectsFromDatas = new HashMap<String, IncludeOdEntry>();
        protected HashSet<String> fReservedOdPaths = new HashSet();
        protected Element fCurrentParent = null;
        protected List<Element> fDomContextStack = new ArrayList<Element>(3);
        protected HXmlParserAttributes fTmpAtts = new HXmlParserAttributes(24);

        public OdBlenderContentHandler(HDialogPages pDialogPage) {
            this.fDialog = pDialogPage;
        }

        @Override
        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
            if (pUri == OdBlenderPage.NS_SCOD) {
                this.startElementScOd(pLocalName, pAttributes);
            } else if (pUri == "urn:oasis:names:tc:opendocument:xmlns:style:1.0" && (pLocalName == "style" || pLocalName == "page-layout")) {
                this.pushDomContext(this.createdElement(this.fRootAutoStyleContent, pUri, pLocalName, pQName, pAttributes));
                AutoStyleEntry vStyle = new AutoStyleEntry(this.fCurrentParent);
                if (this.fStyleEntries.put(vStyle.getName(), vStyle) != null) assert (Boolean.parseBoolean(pAttributes.getValue(OdBlenderPage.NS_SCOD, "onlyIfNecessay"))) : "Duplicated style definition : " + vStyle.getName();
            } else if (pUri == "urn:oasis:names:tc:opendocument:xmlns:style:1.0" && pLocalName == "master-page") {
                String vName = pAttributes.getValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name");
                MasterPageEntry vMasterPage = this.fMasterPagesEntries.get(vName);
                if (vMasterPage == null) {
                    this.pushDomContext(this.createdElement(this.fRootMasterPages, pUri, pLocalName, pQName, pAttributes));
                    vMasterPage = new MasterPageEntry(this.fCurrentParent);
                    this.fMasterPagesEntries.put(vMasterPage.getName(), vMasterPage);
                } else {
                    while (vMasterPage.fDef.hasChildNodes()) {
                        vMasterPage.fDef.removeChild(vMasterPage.fDef.getFirstChild());
                    }
                    this.pushDomContext(vMasterPage.fDef);
                    int vLen = pAttributes.getLength();
                    for (int i = 0; i < vLen; ++i) {
                        this.fCurrentParent.setAttributeNS(pAttributes.getURI(i), pAttributes.getQName(i), pAttributes.getValue(i));
                    }
                }
            } else if (pUri == "urn:oasis:names:tc:opendocument:xmlns:office:1.0" && pLocalName == "event-listeners") {
                this.pushDomContext(this.createdElement(this.fRootScriptsContent, pUri, pLocalName, pQName, pAttributes));
            } else {
                int vLen = pAttributes.getLength();
                for (int i = 0; i < vLen; ++i) {
                    if (pAttributes.getLocalName(i) != "style-name") continue;
                    this.addStyleInResult(pAttributes.getValue(i), this.isInStyles());
                }
                Attributes vAtts = pAttributes;
                if (pUri == "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0") {
                    if (pLocalName == "image") {
                        String vHref = pAttributes.getValue("http://www.w3.org/1999/xlink", "href");
                        if (vHref != null && vHref.length() > 0) {
                            String vTargetPath = this.addPictureFromOdStyle(vHref);
                            if (vTargetPath != null) {
                                if (vTargetPath != vHref) {
                                    vAtts = this.getWritableAtts(pAttributes);
                                    int vIdxHref = this.fTmpAtts.getIndex("http://www.w3.org/1999/xlink", "href");
                                    this.fTmpAtts.setValue(vIdxHref, vTargetPath);
                                }
                            } else {
                                vAtts = this.getWritableAtts(pAttributes);
                                int vIdxHref = this.fTmpAtts.getIndex("http://www.w3.org/1999/xlink", "href");
                                this.fTmpAtts.setValue(vIdxHref, null);
                            }
                        } else {
                            String vScPath = pAttributes.getValue(OdBlenderPage.NS_SCOD, "src");
                            if (vScPath != null) {
                                vAtts = this.getWritableAtts(pAttributes);
                                String vOdtPath = this.addPictureFromDatas(vScPath);
                                if (vOdtPath != null) {
                                    this.fTmpAtts.hAdd("http://www.w3.org/1999/xlink", "href", "xlink:href", vOdtPath);
                                }
                            }
                        }
                    } else if (pLocalName == "object") {
                        String vScPath = pAttributes.getValue(OdBlenderPage.NS_SCOD, "src");
                        String vRemoveSettings = pAttributes.getValue(OdBlenderPage.NS_SCOD, "removeSettings");
                        if (vScPath != null) {
                            vAtts = this.getWritableAtts(vAtts);
                            String vOdPath = this.addObjectsFromDatas(vScPath, Boolean.parseBoolean(vRemoveSettings));
                            if (vOdPath != null) {
                                if (vOdPath.endsWith("/")) {
                                    vOdPath = vOdPath.substring(0, vOdPath.length() - 1);
                                }
                                this.fTmpAtts.hAdd("http://www.w3.org/1999/xlink", "href", "xlink:href", vOdPath);
                            }
                        }
                    }
                }
                this.appendCurrentElement(pUri, pLocalName, pQName, vAtts);
            }
        }

        protected Attributes getWritableAtts(Attributes pAttributes) {
            if (pAttributes == this.fTmpAtts) {
                return this.fTmpAtts;
            }
            this.fTmpAtts.hReset();
            int vLen = pAttributes.getLength();
            for (int i = 0; i < vLen; ++i) {
                String vUri = pAttributes.getURI(i);
                if (vUri == OdBlenderPage.NS_SCOD) continue;
                this.fTmpAtts.hAdd(pAttributes.getURI(i), pAttributes.getLocalName(i), pAttributes.getQName(i), pAttributes.getValue(i));
            }
            return this.fTmpAtts;
        }

        protected void appendCurrentElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) {
            this.fCurrentParent = (Element)this.fCurrentParent.appendChild(this.createdElement(this.fCurrentParent, pUri, pLocalName, pQName, pAttributes));
        }

        protected Element createdElement(Element pContext, String pUri, String pLocalName, String pQName, Attributes pAttributes) {
            Element vElt = pContext.getOwnerDocument().createElementNS(pUri, pQName);
            int vLen = pAttributes.getLength();
            for (int i = 0; i < vLen; ++i) {
                vElt.setAttributeNS(pAttributes.getURI(i), pAttributes.getQName(i), pAttributes.getValue(i));
            }
            pContext.appendChild(vElt);
            return vElt;
        }

        protected void pushDomContext(Element pNewParent) {
            this.fDomContextStack.add(this.fCurrentParent);
            this.fCurrentParent = pNewParent;
        }

        protected void popDomContext() {
            this.fCurrentParent = this.fDomContextStack.remove(this.fDomContextStack.size() - 1);
        }

        protected boolean isInStyles() {
            return this.fCurrentParent.getOwnerDocument() == this.fOdStyle.getStyleDoc();
        }

        protected void startElementScOd(String pLocalName, Attributes pAttributes) throws SAXException {
            try {
                String vStyleName;
                if (pLocalName == "file") {
                    String vUrlSrc = pAttributes.getValue("src");
                    String vName = pAttributes.getValue("pathInOd");
                    String vMime = pAttributes.getValue("mime");
                    if (vUrlSrc != null) {
                        IGenerator vGenerator = this.fDialog.hGetGenerateur();
                        IGenerator.IXxxUri vXxxUri = vGenerator.resolveXxxPath(vUrlSrc, this.fDialog, this.fDialog.hGetAgent());
                        ISrcNode vSrc = vGenerator.getSourceFromXxxUri(vXxxUri, this.fDialog);
                        if (vXxxUri.getUri().length() > 0 && vSrc.getContentStatus() != -1) {
                            this.fOdFile.addFileOrFolder(vName, vSrc, vMime);
                        } else {
                            vGenerator.addTrace("La source " + vSrc + " ne peut \u00eatre incluse dans le document OD. status=" + vSrc.getContentStatus(), ILogMsg.LogType.Warning, new String[0]);
                        }
                    } else {
                        IWAgent vAgent;
                        HDialogPages vDialog;
                        String vPathAgent = pAttributes.getValue("agent");
                        String vPathDialog = pAttributes.getValue("dialog");
                        IHDialog iHDialog = vDialog = vPathDialog != null ? this.fDialog.hGoTo(vPathDialog) : this.fDialog;
                        if (vDialog == null) {
                            vDialog = this.fDialog;
                        }
                        IWAgent iWAgent = vAgent = vPathAgent != null ? this.fDialog.hGetAgent().hGetAgentParRef(vPathAgent) : ((IWADialog)vDialog).hGetAgent();
                        while (vAgent != null && !(vAgent instanceof IWAgentComputor)) {
                            vAgent = vAgent.hGetAgentPere();
                        }
                        if (vAgent != null) {
                            String vEncoding = pAttributes.getValue("encoding");
                            if (vEncoding == null || vEncoding.length() == 0) {
                                vEncoding = "UTF-8";
                            }
                            OutputStreamBlob vBuf = new OutputStreamBlob();
                            OutputStreamWriter vWriter = new OutputStreamWriter((OutputStream)vBuf, vEncoding);
                            ((IWAgentComputor)((Object)vAgent)).computeAsData(vDialog, pAttributes.getValue("arguments")).writeValue(vWriter);
                            ((Writer)vWriter).close();
                            this.fOdFile.addFile(vName, new SrcNodeOneShot(vBuf.getInputStream(true)));
                        }
                    }
                } else if (pLocalName != "odBlender" && pLocalName == "useStyle" && (vStyleName = pAttributes.getValue("name")) != "") {
                    this.addStyleInResult(vStyleName, this.isInStyles());
                }
            }
            catch (Exception e) {
                throw (SAXException)LogMgr.addMessage(new SAXException(e), LogMgr.getMessage(e));
            }
        }

        public void addStyleInResult(String pName, boolean pFromStylesDoc) throws SAXException {
            if (pName != null && pName.length() > 0) {
                StyleEntry vStyle = this.fStyleEntries.get(pName);
                if (vStyle != null) {
                    vStyle.setAsUsed(this, pFromStylesDoc);
                } else {
                    this.fDialog.hGetGenerateur().addTrace("Style used in content but not found : %s", ILogMsg.LogType.Warning, pName);
                }
            }
        }

        public void addMasterPageInResult(String pName) throws SAXException {
            MasterPageEntry vMasterPage;
            if (pName != null && pName.length() > 0 && (vMasterPage = this.fMasterPagesEntries.get(pName)) != null) {
                vMasterPage.setAsUsed(this);
            }
        }

        public void addPictureFromOdStyle(Element pElt) throws SAXException {
            String vHref = pElt.getAttributeNS("http://www.w3.org/1999/xlink", "href");
            if (vHref != null && vHref.length() > 0) {
                String vTargetName = this.addPictureFromOdStyle(vHref);
                if (vTargetName != null) {
                    if (vTargetName != vHref) {
                        pElt.setAttributeNS("http://www.w3.org/1999/xlink", "href", vTargetName);
                    }
                } else {
                    pElt.removeAttributeNS("http://www.w3.org/1999/xlink", "href");
                }
            }
        }

        public String addPictureFromOdStyle(String pHref) throws SAXException {
            if (pHref != null && pHref.length() > 0) {
                ISrcContent vContent;
                ResEntry vEntry = this.fPicturesFromOdStyle.get(pHref);
                String vTargetPath = pHref;
                if (vEntry == null && (vContent = this.fOdFile.getSourceEntry(pHref)) != null) {
                    if (!this.fReservedOdPaths.add(pHref)) {
                        throw new SAXException("Not implemented : rename Picture : " + pHref);
                    }
                    vEntry = new ResEntry(vContent, pHref, vTargetPath);
                    this.fPicturesFromOdStyle.put(pHref, vEntry);
                }
                if (vEntry != null) {
                    return vTargetPath;
                }
            }
            return null;
        }

        public String addPictureFromDatas(String pSrc) throws SAXException {
            try {
                IGenerator.IXxxUri vXxxUri = this.fDialog.hGetGenerateur().resolveXxxPath(pSrc, this.fDialog, this.fDialog.hGetAgent());
                ISrcNode vSrc = this.fDialog.hGetGenerateur().getSourceFromXxxUri(vXxxUri, this.fDialog);
                String vSrcUri = vSrc.getSrcUri();
                ResEntry vEntry = this.fPicturesFromDatas.get(vSrcUri);
                if (vEntry == null && vSrc.getContentStatus() == 1) {
                    String vOdPath = "Pictures/" + vSrc.getSrcName();
                    if (!this.fReservedOdPaths.add(vOdPath)) {
                        throw new SAXException("Not implemented : rename Picture : " + vOdPath);
                    }
                    vEntry = new ResEntry(vSrc, vSrcUri, vOdPath);
                    this.fPicturesFromDatas.put(vSrcUri, vEntry);
                }
                return vEntry != null ? vEntry.getTargetPath() : null;
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw (SAXException)LogMgr.addMessage(new SAXException(), LogMgr.getMessage(e));
            }
        }

        public String addObjectsFromDatas(String pSrc, boolean pRemoveSettings) throws SAXException {
            try {
                IGenerator.IXxxUri vXxxUri = this.fDialog.hGetGenerateur().resolveXxxPath(pSrc, this.fDialog, this.fDialog.hGetAgent());
                ISrcNode vSrc = this.fDialog.hGetGenerateur().getSourceFromXxxUri(vXxxUri, this.fDialog);
                String vSrcUri = vSrc.getSrcUri();
                IncludeOdEntry vEntry = this.fObjectsFromDatas.get(vSrcUri);
                if (vEntry == null && vSrc.getContentStatus() == 1) {
                    String vOdPath = "Object " + (this.fObjectsFromDatas.size() + 1) + "/";
                    if (!this.fReservedOdPaths.add(vOdPath)) {
                        throw new SAXException("Not implemented : rename Object : " + vOdPath);
                    }
                    vEntry = new IncludeOdEntry(vSrc, vSrcUri, vOdPath, pRemoveSettings);
                    this.fObjectsFromDatas.put(vSrcUri, vEntry);
                }
                return vEntry != null ? vEntry.getTargetPath() : null;
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw (SAXException)LogMgr.addMessage(new SAXException(), LogMgr.getMessage(e));
            }
        }

        @Override
        public void endElement(String pUri, String pLocalName, String pQName) throws SAXException {
            if (pUri == OdBlenderPage.NS_SCOD) {
                if (pLocalName == "odBlender") {
                    try {
                        for (StyleEntry vStyle : this.fStyleEntries.values()) {
                            Element vStyleNode = vStyle.getDef();
                            if (vStyleNode.getOwnerDocument() == this.fOdStyle.getStyleDoc()) {
                                if (!vStyle.isUsedInStyles()) {
                                    vStyleNode.getParentNode().removeChild(vStyleNode);
                                }
                                if (!vStyle.isUsedInContent()) continue;
                                this.fRootAutoStyleContent.appendChild(this.fRootAutoStyleContent.getOwnerDocument().importNode(vStyleNode, true));
                                continue;
                            }
                            if (!vStyle.isUsedInContent()) {
                                vStyleNode.getParentNode().removeChild(vStyleNode);
                            }
                            if (!vStyle.isUsedInStyles()) continue;
                            this.fRootAutoStyleStyles.appendChild(this.fRootAutoStyleStyles.getOwnerDocument().importNode(vStyleNode, true));
                        }
                        for (MasterPageEntry vMasterPage : this.fMasterPagesEntries.values()) {
                            Element vMasterPageNode;
                            if (vMasterPage.isUsed() || (vMasterPageNode = vMasterPage.getDef()).getParentNode() == null) continue;
                            vMasterPageNode.getParentNode().removeChild(vMasterPageNode);
                        }
                        this.fOdFile.removeFolder("Pictures/");
                        for (ResEntry vPicture : this.fPicturesFromOdStyle.values()) {
                            this.fOdFile.addFile(vPicture.getTargetPath(), vPicture.getSrcContent());
                        }
                        for (ResEntry vPicture : this.fPicturesFromDatas.values()) {
                            this.fOdFile.addFile(vPicture.getTargetPath(), vPicture.getSrcContent());
                        }
                        for (IncludeOdEntry vObject : this.fObjectsFromDatas.values()) {
                            this.fOdFile.includeOd(vObject.getTargetPath(), vObject.getSrcContent(), vObject.isRemoveSettings());
                        }
                        Serializer vSerializer = SerializerFactory.getSerializerFactory("xml").makeSerializer(new OutputFormat("xml", "UTF-8", false));
                        OutputStreamBlob vContent = new OutputStreamBlob();
                        vSerializer.setOutputByteStream(vContent);
                        vSerializer.asDOMSerializer().serialize(this.fOdStyle.getContentDoc());
                        this.fOdFile.addFile("content.xml", new SrcNodeOneShot(vContent.getInputStream(true), vContent.getLength(), -1L, "text/xml"));
                        OutputStreamBlob vStyle = new OutputStreamBlob();
                        vSerializer.setOutputByteStream(vStyle);
                        vSerializer.asDOMSerializer().serialize(this.fOdStyle.getStyleDoc());
                        this.fOdFile.addFile("styles.xml", new SrcNodeOneShot(vStyle.getInputStream(true), vStyle.getLength(), -1L, "text/xml"));
                    }
                    catch (Exception e) {
                        throw (SAXException)LogMgr.addMessage(new SAXException(e), LogMgr.getMessage(e));
                    }
                }
            } else if (pUri == "urn:oasis:names:tc:opendocument:xmlns:style:1.0" && (pLocalName == "style" || pLocalName == "page-layout")) {
                this.popDomContext();
            } else if (pUri == "urn:oasis:names:tc:opendocument:xmlns:style:1.0" && pLocalName == "master-page") {
                this.popDomContext();
            } else {
                this.fCurrentParent = (Element)this.fCurrentParent.getParentNode();
            }
        }

        @Override
        public void characters(char[] pCh, int pStart, int pLength) throws SAXException {
            this.fCurrentParent.appendChild(this.fCurrentParent.getOwnerDocument().createTextNode(new String(pCh, pStart, pLength)));
        }

        @Override
        public void characters(CharSequence pText) throws SAXException {
            this.fCurrentParent.appendChild(this.fCurrentParent.getOwnerDocument().createTextNode(((Object)pText).toString()));
        }

        @Override
        public void comment(CharSequence pText) throws SAXException {
        }

        public void initOdStyle(ISrcNode pSrc) throws Exception {
            this.fOdFile.initFromOdFile(pSrc);
            this.fOdStyle.initOdStyle(this.fOdFile);
            HashMap<String, Element> vContentAutoStyles = new HashMap<String, Element>();
            HashMap<String, Element> vStyleStyles = new HashMap<String, Element>();
            this.xCreateContentIndex(this.fOdStyle.getContentDoc().getDocumentElement(), vContentAutoStyles);
            this.xCreateStylesIndex(this.fOdStyle.getStyleDoc().getDocumentElement(), vStyleStyles);
            HashMap<String, Element> vMapBlockContents = new HashMap<String, Element>();
            for (Map.Entry<String, OdStyle.Block> vBlock : this.fOdStyle.getBlocks().entrySet()) {
                vMapBlockContents.put(vBlock.getKey(), vBlock.getValue().getBlockContent());
            }
            HashMap<String, Element> vMapSyleMasterPages = new HashMap<String, Element>();
            for (Map.Entry<String, MasterPageEntry> vPageEntry : this.fMasterPagesEntries.entrySet()) {
                vMapSyleMasterPages.put(vPageEntry.getKey(), vPageEntry.getValue().getDef());
            }
            ((IHContextBuffers)((Object)this.fDialog.hGetContext())).putBuffer("odStyleBlocks", vMapBlockContents);
            ((IHContextBuffers)((Object)this.fDialog.hGetContext())).putBuffer("odStylePagesEntries", vMapSyleMasterPages);
            ((IHContextBuffers)((Object)this.fDialog.hGetContext())).putBuffer("odContentAutoStyles", vContentAutoStyles);
            ((IHContextBuffers)((Object)this.fDialog.hGetContext())).putBuffer("odStyleStyles", vStyleStyles);
            while (this.fCurrentParent.hasChildNodes()) {
                this.fCurrentParent.removeChild(this.fCurrentParent.getLastChild());
            }
        }

        protected void xCreateContentIndex(Element pElt, Map<String, Element> pAutoStylesContent) throws Exception {
            boolean vTreatChildren = false;
            String vLocalName = pElt.getLocalName();
            String vNs = pElt.getNamespaceURI();
            if (vNs.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0")) {
                if (vLocalName.equals("style")) {
                    String vName = pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name");
                    if (this.fStyleEntries.put(vName, new AutoStyleEntry(pElt)) != null) {
                        throw new Exception("Duplicate entry style : " + pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"));
                    }
                    pAutoStylesContent.put(vName, pElt);
                }
            } else if (vNs.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) {
                if (vLocalName.equals("body")) {
                    this.fCurrentParent = pElt;
                } else if (vLocalName.equals("scripts")) {
                    this.fRootScriptsContent = pElt;
                } else if (vLocalName.equals("automatic-styles")) {
                    this.fRootAutoStyleContent = pElt;
                    vTreatChildren = true;
                } else if (vLocalName.equals("document-content")) {
                    vTreatChildren = true;
                }
            }
            if (vTreatChildren) {
                for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                    if (vNode.getNodeType() != 1) continue;
                    this.xCreateContentIndex((Element)vNode, pAutoStylesContent);
                }
            }
        }

        protected void xCreateStylesIndex(Element pElt, Map<String, Element> pStylesStyle) throws Exception {
            boolean vTreatChildren = false;
            String vLocalName = pElt.getLocalName();
            String vNs = pElt.getNamespaceURI();
            if (vNs.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0")) {
                String vName = pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name");
                if (vLocalName.equals("style") || vLocalName.equals("page-layout")) {
                    if (this.fStyleEntries.put(vName, new StyleEntry(pElt)) != null) {
                        throw new Exception("Duplicate entry style : " + pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"));
                    }
                    pStylesStyle.put(vName, pElt);
                } else if (vLocalName.equals("master-page") && this.fMasterPagesEntries.put(vName, new MasterPageEntry(pElt)) != null) {
                    throw new Exception("Duplicate entry MasterPage : " + pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"));
                }
            } else if (vNs.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) {
                if (vLocalName.equals("master-styles")) {
                    this.fRootMasterPages = pElt;
                    vTreatChildren = true;
                } else if (vLocalName.equals("styles")) {
                    this.fRootStyles = pElt;
                    vTreatChildren = true;
                } else if (vLocalName.equals("automatic-styles")) {
                    this.fRootAutoStyleStyles = pElt;
                    vTreatChildren = true;
                } else if (vLocalName.equals("document-styles")) {
                    vTreatChildren = true;
                }
            } else if (vNs.equals("urn:oasis:names:tc:opendocument:xmlns:text:1.0") && vLocalName.equals("list-style") && this.fStyleEntries.put(pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"), new StyleEntry(pElt)) != null) {
                throw new Exception("Duplicate entry style : " + pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"));
            }
            if (vTreatChildren) {
                for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                    if (vNode.getNodeType() != 1) continue;
                    this.xCreateStylesIndex((Element)vNode, pStylesStyle);
                }
            }
        }

        public void close() throws Exception {
            if (this.fOdFile != null) {
                this.fOdFile.close();
            }
        }

        public void export(ZipOutputStream pOut) throws Exception {
            this.fOdFile.export(pOut);
        }
    }

    public static class IncludeOdEntry
    extends ResEntry {
        protected boolean fRemoveSettings;

        public IncludeOdEntry(ISrcContent pSrcContent, String pOriginalPath, String pTargetPath, boolean pRemoveSettings) {
            super(pSrcContent, pOriginalPath, pTargetPath);
            this.fRemoveSettings = pRemoveSettings;
        }

        public boolean isRemoveSettings() {
            return this.fRemoveSettings;
        }
    }

    public static class ResEntry {
        protected ISrcContent fSrcContent;
        protected String fOriginalPath;
        protected String fTargetPath;

        public ResEntry(ISrcContent pSrcContent, String pOriginalPath, String pTargetPath) {
            this.fSrcContent = pSrcContent;
            this.fOriginalPath = pOriginalPath;
            this.fTargetPath = pTargetPath;
        }

        public ISrcContent getSrcContent() {
            return this.fSrcContent;
        }

        public String getOriginalPath() {
            return this.fOriginalPath;
        }

        public String getTargetPath() {
            return this.fTargetPath;
        }
    }

    protected static class MasterPageEntry {
        protected Element fDef = null;
        protected boolean fIsUsed = false;

        public MasterPageEntry(Element pDef) {
            this.fDef = pDef;
        }

        public String getName() {
            return this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name");
        }

        public void setAsUsed(OdBlenderContentHandler pOdBlenderContentHandler) throws SAXException {
            if (!this.fIsUsed) {
                this.fIsUsed = true;
                String vLayoutStyle = this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-layout-name");
                pOdBlenderContentHandler.addStyleInResult(vLayoutStyle, true);
                String vNextSyleName = this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "next-style-name");
                pOdBlenderContentHandler.addMasterPageInResult(vNextSyleName);
            }
        }

        public boolean isUsed() {
            return this.fIsUsed;
        }

        public Element getDef() {
            return this.fDef;
        }
    }

    protected static class AutoStyleEntry
    extends StyleEntry {
        protected boolean fIsUsedInStyles = false;
        protected boolean fIsUsedInContent = false;

        public AutoStyleEntry(Element pDef) {
            super(pDef);
        }

        public void setAsUsed(OdBlenderContentHandler pOdBlenderContentHandler, boolean pFromStylesDoc) throws SAXException {
            if (pFromStylesDoc && !this.fIsUsedInStyles) {
                this.fIsUsedInStyles = true;
            }
            if (!pFromStylesDoc && !this.fIsUsedInContent) {
                this.fIsUsedInContent = true;
            }
            super.setAsUsed(pOdBlenderContentHandler, pFromStylesDoc);
        }

        public boolean isUsedInContent() {
            return this.fIsUsedInContent;
        }

        public boolean isUsedInStyles() {
            return this.fIsUsedInStyles;
        }
    }

    protected static class StyleEntry {
        protected Element fDef = null;
        protected boolean fIsUsed = false;

        public StyleEntry(Element pDef) {
            this.fDef = pDef;
        }

        public String getName() {
            return this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name");
        }

        public void setAsUsed(OdBlenderContentHandler pOdBlenderContentHandler, boolean pFromStylesDoc) throws SAXException {
            if (!this.fIsUsed) {
                this.fIsUsed = true;
                pOdBlenderContentHandler.addStyleInResult(this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "parent-style-name"), pFromStylesDoc);
                if (this.fDef.getLocalName().equals("notes-configuration")) {
                    pOdBlenderContentHandler.addStyleInResult(this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "citation-style-name"), pFromStylesDoc);
                    pOdBlenderContentHandler.addStyleInResult(this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "citation-body-style-name"), pFromStylesDoc);
                }
                if (this.fDef.getLocalName().equals("linenumbering-configuration")) {
                    pOdBlenderContentHandler.addStyleInResult(this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name"), pFromStylesDoc);
                }
                pOdBlenderContentHandler.addMasterPageInResult(this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name"));
                this.xSetAsUsedInChildren(this.fDef, pOdBlenderContentHandler, pFromStylesDoc);
            }
        }

        protected void xSetAsUsedInChildren(Element pElt, OdBlenderContentHandler pOdBlenderContentHandler, boolean pFromStylesDoc) throws SAXException {
            pOdBlenderContentHandler.addStyleInResult(pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name"), pFromStylesDoc);
            if (pElt.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
                pOdBlenderContentHandler.addPictureFromOdStyle(pElt);
            }
            for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (vNode.getNodeType() != 1) continue;
                this.xSetAsUsedInChildren((Element)vNode, pOdBlenderContentHandler, pFromStylesDoc);
            }
        }

        public boolean isUsedInContent() {
            return false;
        }

        public boolean isUsedInStyles() {
            return this.fIsUsed;
        }

        public Element getDef() {
            return this.fDef;
        }
    }
}

