/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.odstyle;

import com.scenari.s.co.transform.oo.OdFile;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcContent;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XObject;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import eu.scenari.fw.log.TracePoint;
import eu.scenari.fw.util.lang.TunneledException;
import eu.scenari.modeling.odstyle.OdStyleMerger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdStyle {
    public static TracePoint sTrace = TraceMgr.register(OdStyle.class.getName());
    public static final String NS_DRAW = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    public static final String NS_TABLE = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    public static final String NS_TEXT = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final String NS_STYLE = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    public static final String NS_OFFICE = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    public static final String NS_XLINK = "http://www.w3.org/1999/xlink";
    protected static Map<String, String> OD_PREFIX_MAP = new HashMap<String, String>(24);
    public static final PrefixResolver OD_PREFIX_RESOLVER;
    public static XPath sContentBlocksXpath;
    public static XPath sStylesBlocksXpath;
    protected OdFile fOdFile = null;
    protected Map<String, Block> fBlocks = new HashMap<String, Block>();
    protected List<String> fOdStyleStyles = new ArrayList<String>();
    protected Document fContentDoc = null;
    protected Document fStyleDoc = null;
    protected XPathContext fXPathContext = new XPathContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOdStyle(ISrcContent pSrcOdStyle) throws Exception {
        OdFile vOdFile = null;
        try {
            vOdFile = new OdFile();
            vOdFile.initFromOdFile(pSrcOdStyle);
            this.initOdStyle(vOdFile);
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
        finally {
            if (vOdFile != null) {
                vOdFile.close();
            }
        }
    }

    public void initOdStyle(OdFile pOdStyleFile) throws Exception {
        this.fOdFile = pOdStyleFile;
        DocumentBuilderFactory vFactory = DocumentBuilderFactory.newInstance();
        vFactory.setNamespaceAware(true);
        vFactory.setIgnoringComments(true);
        DocumentBuilder vDocBuilder = vFactory.newDocumentBuilder();
        this.fContentDoc = vDocBuilder.parse(this.fOdFile.getSourceEntry("content.xml").newInputStream(false));
        this.fStyleDoc = vDocBuilder.parse(this.fOdFile.getSourceEntry("styles.xml").newInputStream(false));
        this.xInitBlocks();
    }

    public OdFile getOdFile() {
        return this.fOdFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xInitBlocks() throws Exception {
        ISrcContent vScDatas = this.fOdFile.getSourceEntry("Configurations2/scData.xml");
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            vXmlReader.setContentHandler(new ScDataContentHandler());
            vXmlReader.parse(new InputSource(vScDatas.newInputStream(false)));
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
        HashMap<String, Element> vAllBlocks = new HashMap<String, Element>();
        this.xFindBlocksInStyles(this.fStyleDoc.getDocumentElement(), vAllBlocks);
        this.xFindBlocksInContent(this.fContentDoc.getDocumentElement(), vAllBlocks);
        for (Block vBlock : this.fBlocks.values()) {
            if (vBlock.getRefOdName() == null) {
                vBlock.setBlockRoot(this.fContentDoc.getDocumentElement());
                continue;
            }
            vBlock.setBlockRoot((Element)vAllBlocks.get(vBlock.getRefOdName()));
        }
    }

    protected void xFindBlocksInContent(Element pElt, Map<String, Element> pAllBlocks) throws Exception {
        boolean vSearchInChildren = true;
        String vOdName = null;
        if (pElt.getLocalName().equals("frame")) {
            vOdName = pElt.getAttributeNS(NS_DRAW, "name");
        } else if (pElt.getLocalName().equals("table")) {
            vOdName = pElt.getAttributeNS(NS_TABLE, "name");
        } else if (pElt.getLocalName().equals("section")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "name");
        } else if (pElt.getLocalName().equals("p")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "style-name");
        } else if (pElt.getLocalName().equals("h")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "style-name");
        } else if (pElt.getLocalName().equals("span")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "style-name");
        } else if (pElt.getLocalName().equals("font-face-decls")) {
            vSearchInChildren = false;
        } else if (pElt.getLocalName().equals("automatic-styles")) {
            vSearchInChildren = false;
        } else if (pElt.getLocalName().equals("scripts")) {
            vSearchInChildren = false;
        }
        if (vOdName != null && vOdName != "") {
            Element vReplaced = pAllBlocks.put(vOdName, pElt);
            if (vReplaced != null && sTrace.isEnabled()) {
                sTrace.publishDebug("Doubloon block : " + vOdName, new String[0]);
            }
            vSearchInChildren = true;
        }
        if (vSearchInChildren && pElt.hasChildNodes()) {
            for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (vNode.getNodeType() != 1) continue;
                this.xFindBlocksInContent((Element)vNode, pAllBlocks);
            }
        }
    }

    protected void xFindBlocksInStyles(Element pElt, Map<String, Element> pAllBlocks) throws Exception {
        boolean vSearchInChildren = true;
        String vOdName = null;
        if (pElt.getLocalName().equals("frame")) {
            vOdName = pElt.getAttributeNS(NS_DRAW, "name");
        } else if (pElt.getLocalName().equals("p")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "style-name");
        } else if (pElt.getLocalName().equals("h")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "style-name");
        } else if (pElt.getLocalName().equals("span")) {
            vOdName = pElt.getAttributeNS(NS_TEXT, "style-name");
        } else if (pElt.getLocalName().equals("font-face-decls")) {
            vSearchInChildren = false;
        } else if (pElt.getLocalName().equals("styles")) {
            vSearchInChildren = false;
        } else if (pElt.getLocalName().equals("automatic-styles")) {
            vSearchInChildren = false;
        }
        if (vOdName != null && vOdName != "") {
            Element vReplaced = pAllBlocks.put(vOdName, pElt);
            if (vReplaced != null && sTrace.isEnabled()) {
                sTrace.publishDebug("Doubloon block : " + vOdName, new String[0]);
            }
            vSearchInChildren = true;
        }
        if (vSearchInChildren && pElt.hasChildNodes()) {
            for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (vNode.getNodeType() != 1) continue;
                this.xFindBlocksInStyles((Element)vNode, pAllBlocks);
            }
        }
    }

    public Block getBlock(String pCode) {
        return this.fBlocks.get(pCode);
    }

    public Map<String, Block> getBlocks() {
        return this.fBlocks;
    }

    public Element getBlockContent(String pCode) throws Exception {
        Block vBlock = this.fBlocks.get(pCode);
        return vBlock != null ? vBlock.getBlockContent() : null;
    }

    public Document getContentDoc() {
        return this.fContentDoc;
    }

    public Document getStyleDoc() {
        return this.fStyleDoc;
    }

    public List<String> getOdStyleStyles() {
        return this.fOdStyleStyles;
    }

    public XPathContext getXPathContext() {
        return this.fXPathContext;
    }

    static {
        OD_PREFIX_MAP.put("office", NS_OFFICE);
        OD_PREFIX_MAP.put("style", NS_STYLE);
        OD_PREFIX_MAP.put("text", NS_TEXT);
        OD_PREFIX_MAP.put("table", NS_TABLE);
        OD_PREFIX_MAP.put("draw", NS_DRAW);
        OD_PREFIX_MAP.put("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        OD_PREFIX_MAP.put("xlink", NS_XLINK);
        OD_PREFIX_MAP.put("dc", "http://purl.org/dc/elements/1.1/");
        OD_PREFIX_MAP.put("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        OD_PREFIX_MAP.put("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        OD_PREFIX_MAP.put("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        OD_PREFIX_MAP.put("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        OD_PREFIX_MAP.put("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        OD_PREFIX_MAP.put("math", "http://www.w3.org/1998/Math/MathML");
        OD_PREFIX_MAP.put("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        OD_PREFIX_MAP.put("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        OD_PREFIX_MAP.put("ooo", "http://openoffice.org/2004/office");
        OD_PREFIX_MAP.put("ooow", "http://openoffice.org/2004/writer");
        OD_PREFIX_MAP.put("oooc", "http://openoffice.org/2004/calc");
        OD_PREFIX_MAP.put("dom", "http://www.w3.org/2001/xml-events");
        OD_PREFIX_MAP.put("xforms", "http://www.w3.org/2002/xforms");
        OD_PREFIX_MAP.put("xsd", "http://www.w3.org/2001/XMLSchema");
        OD_PREFIX_MAP.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        OD_PREFIX_RESOLVER = new PrefixResolver(){

            public String getNamespaceForPrefix(String pPrefix) {
                return OD_PREFIX_MAP.get(pPrefix);
            }

            public String getNamespaceForPrefix(String pPrefix, Node pContext) {
                return this.getNamespaceForPrefix(pPrefix);
            }

            public String getBaseIdentifier() {
                return null;
            }
        };
        try {
            sContentBlocksXpath = XPath.createXPath("//*[@draw:name or @table:name]", null, OD_PREFIX_RESOLVER, 0);
            sStylesBlocksXpath = XPath.createXPath("//*[@draw:name]", null, OD_PREFIX_RESOLVER, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ScDataContentHandler
    extends DefaultHandler {
        protected Block fCurrentBlock = null;

        public void startElement(String pUri, String pLocalName, String pName, Attributes pAttributes) throws SAXException {
            try {
                String vXpath;
                if (pLocalName == "scData") {
                    String vOdStyleStyles = pAttributes.getValue("odStyleStyles");
                    if (vOdStyleStyles != null) {
                        StringTokenizer vTok = new StringTokenizer(vOdStyleStyles, ",");
                        while (vTok.hasMoreTokens()) {
                            String vStyle = vTok.nextToken();
                            if (vStyle.length() <= 0) continue;
                            OdStyle.this.fOdStyleStyles.add(vStyle);
                        }
                    }
                } else if (pLocalName == "block") {
                    this.fCurrentBlock = new Block();
                    this.fCurrentBlock.setCode(pAttributes.getValue("code"));
                    this.fCurrentBlock.setStructSgn(pAttributes.getValue("structSgn"));
                    this.fCurrentBlock.setRefOdName(pAttributes.getValue("refOdName"));
                    this.fCurrentBlock.setContentXPath(pAttributes.getValue("contentXPath"));
                    OdStyle.this.fBlocks.put(this.fCurrentBlock.getCode(), this.fCurrentBlock);
                } else if (pLocalName == "useStyle") {
                    boolean vOnlyInNewStruct;
                    String vXpath2 = pAttributes.getValue("xpath");
                    String vOnlyInNewStructStr = pAttributes.getValue("onlyInNewStruct");
                    boolean bl = vOnlyInNewStruct = vOnlyInNewStructStr != null && vOnlyInNewStructStr.equals("true");
                    if (vXpath2 != null) {
                        this.fCurrentBlock.addMergeRules(new UseStyleByXpath(vXpath2, vOnlyInNewStruct));
                    } else {
                        String vStyleName = pAttributes.getValue("name");
                        if (vStyleName != null) {
                            this.fCurrentBlock.addMergeRules(new UseStyleByName(vStyleName, vOnlyInNewStruct));
                        }
                    }
                } else if (pLocalName == "usePicture") {
                    String vXpath3 = pAttributes.getValue("xpath");
                    String vOnlyInNewStructStr = pAttributes.getValue("onlyInNewStruct");
                    boolean vOnlyInNewStruct = vOnlyInNewStructStr != null && vOnlyInNewStructStr.equals("true");
                    this.fCurrentBlock.addMergeRules(new UsePictureByXpath(vXpath3, vOnlyInNewStruct));
                } else if (pLocalName == "preserveAtt") {
                    String vRemoveIfNoneStr;
                    String vXpath4 = pAttributes.getValue("elements");
                    boolean vInclude = false;
                    String[] vAttrNames = null;
                    String vAttrNamesStr = pAttributes.getValue("exclude");
                    if (vAttrNamesStr == null) {
                        vAttrNamesStr = pAttributes.getValue("include");
                        vInclude = true;
                    }
                    if (vAttrNamesStr != null && vAttrNamesStr.length() > 0) {
                        StringTokenizer vTok = new StringTokenizer(vAttrNamesStr, ",");
                        vAttrNames = new String[vTok.countTokens()];
                        for (int i = 0; i < vAttrNames.length; ++i) {
                            vAttrNames[i] = vTok.nextToken();
                        }
                    } else {
                        vInclude = false;
                    }
                    boolean vRemoveIfNone = (vRemoveIfNoneStr = pAttributes.getValue("removeIfNone")) != null && vRemoveIfNoneStr.equals("true");
                    this.fCurrentBlock.addMergeRules(new PreserveAtt(vXpath4, vInclude, vAttrNames, vRemoveIfNone));
                } else if (pLocalName == "preserveElts" && (vXpath = pAttributes.getValue("xpath")) != null) {
                    String vRemoveIfNone = pAttributes.getValue("removeIfNone");
                    this.fCurrentBlock.addMergeRules(new PreserveElts(vXpath, vRemoveIfNone != null && vRemoveIfNone.equals("true")));
                }
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }
    }

    public static class PreserveElts
    extends MergeRule {
        protected String fSrcXpath;
        protected boolean fRemoveIfNone;
        protected XPath fXPath = null;

        public PreserveElts(String pXpath, boolean pRemoveIfNone) {
            this.fSrcXpath = pXpath;
            this.fRemoveIfNone = pRemoveIfNone;
        }

        public XPath getXPath() throws Exception {
            if (this.fXPath == null) {
                this.fXPath = XPath.createXPath(this.fSrcXpath, null, OD_PREFIX_RESOLVER, 0);
            }
            return this.fXPath;
        }

        public void applyMergeRule(Block pBlock, OdStyleMerger pMerger) throws Exception {
            XPathContext vCtx;
            XPath vXPath = this.getXPath();
            XObject vResult = vXPath.execute(vCtx = pBlock.getXPathContext(), pBlock.getBlockContent());
            if (vResult != null && vResult.getType() == 4) {
                XObject vStylesOldStyles;
                NodeIterator vItNewStruct = vResult.nodeset();
                Block vOldStylesBlock = pMerger.getBlockInOldStyles(pBlock);
                XObject xObject = vStylesOldStyles = vOldStylesBlock != null && vOldStylesBlock.getBlockContent() != null ? vXPath.execute(vCtx, vOldStylesBlock.getBlockContent()) : null;
                if (vStylesOldStyles != null && vStylesOldStyles.getType() == 4) {
                    NodeIterator vItOldStyles = vStylesOldStyles.nodeset();
                    Node vNodeNewStruct = vItNewStruct.nextNode();
                    Node vNodeOldStyles = vItOldStyles.nextNode();
                    while (vNodeNewStruct != null) {
                        Node vNextNewStruct = vItNewStruct.nextNode();
                        if (vNodeOldStyles != null) {
                            Node vNextOldStyles = vItOldStyles.nextNode();
                            if (vNodeNewStruct.getNodeType() == 1 && vNodeOldStyles.getNodeType() == 1) {
                                pMerger.replaceNode(vNodeOldStyles, vNodeNewStruct);
                            }
                            vNodeOldStyles = vNextOldStyles;
                        } else if (this.fRemoveIfNone) {
                            vNodeNewStruct.getParentNode().removeChild(vNodeNewStruct);
                        }
                        vNodeNewStruct = vNextNewStruct;
                    }
                }
            }
        }
    }

    public static class PreserveAtt
    extends MergeRule {
        protected String fSrcXpathElement;
        protected XPath fXPathElements = null;
        protected boolean fInclude;
        protected String[] fAttrNames;
        protected boolean fRemoveIfNone;

        public PreserveAtt(String pXpathElements, boolean pInclude, String[] pAttrNames, boolean pRemoveIfNone) {
            this.fSrcXpathElement = pXpathElements;
            this.fInclude = pInclude;
            this.fAttrNames = pAttrNames;
            this.fRemoveIfNone = pRemoveIfNone;
        }

        public XPath getXPathElements() throws Exception {
            if (this.fSrcXpathElement == null || this.fSrcXpathElement.equals(".")) {
                return null;
            }
            if (this.fXPathElements == null) {
                this.fXPathElements = XPath.createXPath(this.fSrcXpathElement, null, OD_PREFIX_RESOLVER, 0);
            }
            return this.fXPathElements;
        }

        public void applyMergeRule(Block pBlock, OdStyleMerger pMerger) throws Exception {
            Block vOldStylesBlock = pMerger.getBlockInOldStyles(pBlock);
            if (vOldStylesBlock == null) {
                return;
            }
            XPath vXPath = this.getXPathElements();
            if (vXPath == null) {
                this.applyOnElt(vOldStylesBlock.getBlockContent(), pBlock.getBlockContent());
            } else {
                XPathContext vCtx = pBlock.getXPathContext();
                XObject vResult = vXPath.execute(vCtx, pBlock.getBlockContent());
                if (vResult != null && vResult.getType() == 4) {
                    XObject vStylesOldStyles;
                    NodeIterator vItNewStruct = vResult.nodeset();
                    XObject xObject = vStylesOldStyles = vOldStylesBlock != null && vOldStylesBlock.getBlockContent() != null ? vXPath.execute(vCtx, vOldStylesBlock.getBlockContent()) : null;
                    if (vStylesOldStyles != null && vStylesOldStyles.getType() == 4) {
                        NodeIterator vItOldStyles = vStylesOldStyles.nodeset();
                        Node vNodeNewStruct = vItNewStruct.nextNode();
                        Node vNodeOldStyles = vItOldStyles.nextNode();
                        while (vNodeNewStruct != null && vNodeOldStyles != null) {
                            this.applyOnElt((Element)vNodeOldStyles, (Element)vNodeNewStruct);
                            vNodeOldStyles = vItOldStyles.nextNode();
                            vNodeNewStruct = vItNewStruct.nextNode();
                        }
                    }
                }
            }
        }

        protected void applyOnElt(Element pEltOldStyle, Element pEltNewStruct) {
            block11: {
                Attr vAttr;
                block10: {
                    if (pEltOldStyle == null || pEltNewStruct == null) {
                        return;
                    }
                    if (!this.fInclude) break block10;
                    if (this.fAttrNames == null) break block11;
                    for (String vAttrName : this.fAttrNames) {
                        Attr vOldStyleVal = pEltOldStyle.getAttributeNode(vAttrName);
                        if (vOldStyleVal == null) {
                            if (!this.fRemoveIfNone) continue;
                            pEltNewStruct.removeAttribute(vAttrName);
                            continue;
                        }
                        pEltNewStruct.setAttributeNS(vOldStyleVal.getNamespaceURI(), vOldStyleVal.getName(), vOldStyleVal.getValue());
                    }
                    break block11;
                }
                NamedNodeMap vOldStylesAttrs = pEltOldStyle.getAttributes();
                int vLen = vOldStylesAttrs.getLength();
                block1: for (int i = 0; i < vLen; ++i) {
                    vAttr = (Attr)vOldStylesAttrs.item(i);
                    if (this.fAttrNames != null) {
                        for (String vAttrExclude : this.fAttrNames) {
                            if (vAttrExclude.equals(vAttr.getName())) continue block1;
                        }
                    }
                    pEltNewStruct.setAttributeNS(vAttr.getNamespaceURI(), vAttr.getName(), vAttr.getValue());
                }
                if (this.fRemoveIfNone) {
                    NamedNodeMap vNewStructAttrs = pEltNewStruct.getAttributes();
                    block3: for (int i = 0; i < vNewStructAttrs.getLength(); ++i) {
                        vAttr = (Attr)vNewStructAttrs.item(i);
                        if (this.fAttrNames != null) {
                            for (String vAttrExclude : this.fAttrNames) {
                                if (vAttrExclude.equals(vAttr.getName())) continue block3;
                            }
                        }
                        if (vOldStylesAttrs.getNamedItem(vAttr.getName()) != null) continue;
                        vNewStructAttrs.removeNamedItem(vAttr.getName());
                        --i;
                    }
                }
            }
        }
    }

    public static class UsePictureByXpath
    extends UseStyleByXpath {
        public UsePictureByXpath(String pXpath, boolean pOnlyInNewStruct) {
            super(pXpath, pOnlyInNewStruct);
        }

        public void applyMergeRule(Block pBlock, OdStyleMerger pMerger) throws Exception {
            block7: {
                XObject vPicturesNewStruct;
                XPath vXPath = this.getXPath();
                XPathContext vCtx = pBlock.getXPathContext();
                XObject xObject = vPicturesNewStruct = pBlock.getBlockContent() != null ? vXPath.execute(vCtx, pBlock.getBlockContent()) : null;
                if (vPicturesNewStruct == null || vPicturesNewStruct.getType() != 4) break block7;
                Block vOldStylesBlock = pMerger.getBlockInOldStyles(pBlock);
                NodeIterator vItNewStruct = vPicturesNewStruct.nodeset();
                if (this.fOnlyInNewStruct || vOldStylesBlock == null || vOldStylesBlock.getBlockContent() == null) {
                    Node vImgNewStruct = vItNewStruct.nextNode();
                    while (vImgNewStruct != null) {
                        if (vImgNewStruct.getNodeType() == 1) {
                            pMerger.addPictureInResult((Element)vImgNewStruct, (Element)vImgNewStruct);
                        }
                        vImgNewStruct = vItNewStruct.nextNode();
                    }
                } else {
                    Node vNodeOldStyles;
                    XObject vStylesOldStyles = vOldStylesBlock != null && vOldStylesBlock.getBlockContent() != null ? vXPath.execute(vCtx, vOldStylesBlock.getBlockContent()) : null;
                    NodeIterator vItOldStyles = null;
                    if (vStylesOldStyles != null && vStylesOldStyles.getType() == 4) {
                        vItOldStyles = vStylesOldStyles.nodeset();
                    }
                    Node vNodeNewStruct = vItNewStruct.nextNode();
                    Node node = vNodeOldStyles = vItOldStyles != null ? vItOldStyles.nextNode() : null;
                    while (vNodeNewStruct != null) {
                        Node vImgFrom;
                        Node node2 = vImgFrom = vNodeOldStyles != null ? vNodeOldStyles : vNodeNewStruct;
                        if (vImgFrom.getNodeType() == 1) {
                            pMerger.addPictureInResult((Element)vImgFrom, (Element)vNodeNewStruct);
                        }
                        vNodeNewStruct = vItNewStruct.nextNode();
                        vNodeOldStyles = vItOldStyles != null ? vItOldStyles.nextNode() : null;
                    }
                }
            }
        }
    }

    public static class UseStyleByXpath
    extends MergeRule {
        protected String fSrcXpath;
        protected XPath fXPath = null;
        protected boolean fOnlyInNewStruct = false;

        public UseStyleByXpath(String pXpath, boolean pOnlyInNewStruct) {
            this.fSrcXpath = pXpath;
            this.fOnlyInNewStruct = pOnlyInNewStruct;
        }

        public XPath getXPath() throws Exception {
            if (this.fXPath == null) {
                this.fXPath = XPath.createXPath(this.fSrcXpath, null, OD_PREFIX_RESOLVER, 0);
            }
            return this.fXPath;
        }

        public void applyMergeRule(Block pBlock, OdStyleMerger pMerger) throws Exception {
            block7: {
                XObject vStylesNewStruct;
                XPath vXPath = this.getXPath();
                XPathContext vCtx = pBlock.getXPathContext();
                XObject xObject = vStylesNewStruct = pBlock.getBlockContent() != null ? vXPath.execute(vCtx, pBlock.getBlockContent()) : null;
                if (vStylesNewStruct == null || vStylesNewStruct.getType() != 4) break block7;
                Block vOldStylesBlock = pMerger.getBlockInOldStyles(pBlock);
                NodeIterator vItNewStruct = vStylesNewStruct.nodeset();
                if (this.fOnlyInNewStruct || vOldStylesBlock == null || vOldStylesBlock.getBlockContent() == null) {
                    Node vNodeNewStruct = vItNewStruct.nextNode();
                    while (vNodeNewStruct != null) {
                        if (vNodeNewStruct.getNodeType() == 2) {
                            pMerger.addStyleInResult(vNodeNewStruct.getNodeValue(), vNodeNewStruct, vNodeNewStruct, true);
                        }
                        vNodeNewStruct = vItNewStruct.nextNode();
                    }
                } else {
                    Node vNodeOldStyles;
                    XObject vStylesOldStyles = vOldStylesBlock != null && vOldStylesBlock.getBlockContent() != null ? vXPath.execute(vCtx, vOldStylesBlock.getBlockContent()) : null;
                    NodeIterator vItOldStyles = null;
                    if (vStylesOldStyles != null && vStylesOldStyles.getType() == 4) {
                        vItOldStyles = vStylesOldStyles.nodeset();
                    }
                    Node vNodeNewStruct = vItNewStruct.nextNode();
                    Node node = vNodeOldStyles = vItOldStyles != null ? vItOldStyles.nextNode() : null;
                    while (vNodeNewStruct != null) {
                        Node vAttrStyle;
                        Node node2 = vAttrStyle = vNodeOldStyles != null ? vNodeOldStyles : vNodeNewStruct;
                        if (vAttrStyle.getNodeType() == 2) {
                            pMerger.addStyleInResult(vAttrStyle.getNodeValue(), vAttrStyle, vNodeNewStruct, false);
                        }
                        vNodeNewStruct = vItNewStruct.nextNode();
                        vNodeOldStyles = vItOldStyles != null ? vItOldStyles.nextNode() : null;
                    }
                }
            }
        }
    }

    public static class UseStyleByName
    extends MergeRule {
        protected String fStyleName;
        protected boolean fOnlyInNewStruct = false;

        public UseStyleByName(String pStyleName, boolean pOnlyInNewStruct) {
            this.fStyleName = pStyleName;
            this.fOnlyInNewStruct = pOnlyInNewStruct;
        }

        public void applyMergeRule(Block pBlock, OdStyleMerger pMerger) throws Exception {
            pMerger.addStyleInResult(this.fStyleName, pBlock.getBlockContent(), null, this.fOnlyInNewStruct);
        }
    }

    public static abstract class MergeRule {
        public abstract void applyMergeRule(Block var1, OdStyleMerger var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Block {
        protected String fCode = null;
        protected String fStructSgn = null;
        protected String fRefOdName = null;
        protected String fContentXPath = null;
        protected Element fRoot = null;
        protected Element fContent = null;
        protected List<MergeRule> fMergeRules = new ArrayList<MergeRule>();

        public String getCode() {
            return this.fCode;
        }

        public String getStructSgn() {
            return this.fStructSgn;
        }

        public String getRefOdName() {
            return this.fRefOdName;
        }

        public Element getBlockRoot() {
            return this.fRoot;
        }

        public Element getBlockContent() throws Exception {
            if (this.fContent == null) {
                Element vBlockRoot = this.getBlockRoot();
                if (vBlockRoot != null && this.fContentXPath != null && this.fContentXPath.length() > 0) {
                    try {
                        XPath vXPath = XPath.createXPath(this.fContentXPath, null, OD_PREFIX_RESOLVER, 0);
                        XObject vResult = vXPath.execute(this.getXPathContext(), this.getBlockRoot());
                        this.fContent = (Element)vResult.nodeset().nextNode();
                    }
                    catch (Exception e) {
                        throw (Exception)LogMgr.addMessage((Throwable)e, "Content block '%1$s' error (xpath : %2$s)", this.fCode, this.fContentXPath);
                    }
                    assert (this.fContent != null) : "Content block '" + this.fCode + "' not found : " + this.fContentXPath;
                } else {
                    this.fContent = vBlockRoot;
                }
            }
            return this.fContent;
        }

        public List<MergeRule> getMergeRules() {
            return this.fMergeRules;
        }

        public void setCode(String pCode) {
            this.fCode = pCode;
        }

        public void setStructSgn(String pStructSgn) {
            this.fStructSgn = pStructSgn;
        }

        public void setRefOdName(String pRefOdName) {
            this.fRefOdName = pRefOdName;
        }

        public void setContentXPath(String pContentXPath) {
            this.fContentXPath = pContentXPath;
        }

        public void setBlockRoot(Element pBlockRoot) {
            this.fRoot = pBlockRoot;
        }

        public void addMergeRules(MergeRule pMergeRules) {
            this.fMergeRules.add(pMergeRules);
        }

        public void applyMergeRules(OdStyleMerger pMerger) throws Exception {
            for (MergeRule vRule : this.fMergeRules) {
                vRule.applyMergeRule(this, pMerger);
            }
        }

        public XPathContext getXPathContext() {
            return OdStyle.this.fXPathContext;
        }
    }
}

